/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.console.excel;

import com.bstek.ureport.build.ReportBuilder;
import com.bstek.ureport.cache.CacheUtils;
import com.bstek.ureport.console.BaseServletAction;
import com.bstek.ureport.console.exception.ReportDesignException;
import com.bstek.ureport.definition.ReportDefinition;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.export.ExportConfigure;
import com.bstek.ureport.export.ExportConfigureImpl;
import com.bstek.ureport.export.ExportManager;
import com.bstek.ureport.export.excel.low.Excel97Producer;
import com.bstek.ureport.model.Report;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class ExportExcel97ServletAction
extends BaseServletAction {
    private ReportBuilder reportBuilder;
    private ExportManager exportManager;
    private Excel97Producer excelProducer = new Excel97Producer();

    @Override
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = this.retriveMethod(req);
        if (method != null) {
            this.invokeMethod(method, req, resp);
        } else {
            this.buildExcel(req, resp, false, false);
        }
    }

    public void paging(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.buildExcel(req, resp, true, false);
    }

    public void sheet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.buildExcel(req, resp, false, true);
    }

    public void buildExcel(HttpServletRequest req, HttpServletResponse resp, boolean withPage, boolean withSheet) throws IOException {
        String file = req.getParameter("_u");
        if (StringUtils.isBlank((String)file)) {
            throw new ReportComputeException("Report file can not be null.");
        }
        String fileName = req.getParameter("_n");
        fileName = StringUtils.isNotBlank((String)fileName) ? this.decode(fileName) : "ureport.xls";
        resp.setContentType("application/octet-stream;charset=ISO8859-1");
        resp.setHeader("Content-Disposition", "attachment;filename=\"" + fileName + "\"");
        Map<String, Object> parameters = this.buildParameters(req);
        String fullName = String.valueOf(file) + parameters.toString();
        ServletOutputStream outputStream = resp.getOutputStream();
        if (file.equals("p")) {
            Report report = CacheUtils.getReport((String)fullName);
            if (report == null) {
                ReportDefinition reportDefinition = (ReportDefinition)req.getSession().getAttribute("p");
                if (reportDefinition == null) {
                    throw new ReportDesignException("Report data has expired,can not do export excel.");
                }
                report = this.reportBuilder.buildReport(reportDefinition, parameters);
            }
            if (withPage) {
                this.excelProducer.produceWithPaging(report, (OutputStream)outputStream);
            } else if (withSheet) {
                this.excelProducer.produceWithSheet(report, (OutputStream)outputStream);
            } else {
                this.excelProducer.produce(report, (OutputStream)outputStream);
            }
        } else {
            ExportConfigureImpl configure = new ExportConfigureImpl(file, parameters, (OutputStream)outputStream);
            if (withPage) {
                this.exportManager.exportExcelWithPaging((ExportConfigure)configure);
            } else if (withSheet) {
                this.exportManager.exportExcelWithPagingSheet((ExportConfigure)configure);
            } else {
                this.exportManager.exportExcel((ExportConfigure)configure);
            }
        }
        outputStream.flush();
        outputStream.close();
    }

    public void setReportBuilder(ReportBuilder reportBuilder) {
        this.reportBuilder = reportBuilder;
    }

    public void setExportManager(ExportManager exportManager) {
        this.exportManager = exportManager;
    }

    @Override
    public String url() {
        return "/excel97";
    }
}

