/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.console.pdf;

import com.bstek.ureport.build.ReportBuilder;
import com.bstek.ureport.cache.CacheUtils;
import com.bstek.ureport.console.BaseServletAction;
import com.bstek.ureport.console.exception.ReportDesignException;
import com.bstek.ureport.definition.Paper;
import com.bstek.ureport.definition.ReportDefinition;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.export.ExportConfigure;
import com.bstek.ureport.export.ExportConfigureImpl;
import com.bstek.ureport.export.ExportManager;
import com.bstek.ureport.export.ReportRender;
import com.bstek.ureport.export.pdf.PdfProducer;
import com.bstek.ureport.model.Report;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;

public class ExportPdfServletAction
extends BaseServletAction {
    private ReportBuilder reportBuilder;
    private ExportManager exportManager;
    private ReportRender reportRender;
    private PdfProducer pdfProducer = new PdfProducer();

    @Override
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = this.retriveMethod(req);
        if (method != null) {
            this.invokeMethod(method, req, resp);
        } else {
            this.buildPdf(req, resp, false);
        }
    }

    public void show(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.buildPdf(req, resp, true);
    }

    public void buildPdf(HttpServletRequest req, HttpServletResponse resp, boolean forPrint) throws IOException {
        String file = req.getParameter("_u");
        if (StringUtils.isBlank((String)file)) {
            throw new ReportComputeException("Report file can not be null.");
        }
        String fileName = req.getParameter("_n");
        fileName = StringUtils.isNotBlank((String)fileName) ? this.decode(fileName) : "ureport.pdf";
        if (forPrint) {
            resp.setContentType("application/pdf");
            resp.setHeader("Content-Disposition", "inline;filename=\"" + fileName + "\"");
        } else {
            resp.setContentType("application/octet-stream;charset=ISO8859-1");
            resp.setHeader("Content-Disposition", "attachment;filename=\"" + fileName + "\"");
        }
        Map<String, Object> parameters = this.buildParameters(req);
        String fullName = String.valueOf(file) + parameters.toString();
        ServletOutputStream outputStream = resp.getOutputStream();
        if (file.equals("p")) {
            Report report = CacheUtils.getReport((String)fullName);
            if (report == null) {
                ReportDefinition reportDefinition = (ReportDefinition)req.getSession().getAttribute("p");
                if (reportDefinition == null) {
                    throw new ReportDesignException("Report data has expired,can not do export pdf.");
                }
                report = this.reportBuilder.buildReport(reportDefinition, parameters);
            }
            this.pdfProducer.produce(report, (OutputStream)outputStream);
        } else {
            ExportConfigureImpl configure = new ExportConfigureImpl(file, parameters, (OutputStream)outputStream);
            this.exportManager.exportPdf((ExportConfigure)configure);
        }
        outputStream.flush();
        outputStream.close();
    }

    public void newPaging(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ReportDefinition reportDefinition;
        String file = req.getParameter("_u");
        if (StringUtils.isBlank((String)file)) {
            throw new ReportComputeException("Report file can not be null.");
        }
        Report report = null;
        Map<String, Object> parameters = this.buildParameters(req);
        String fullName = String.valueOf(file) + parameters.toString();
        if (file.equals("p")) {
            report = CacheUtils.getReport((String)fullName);
            reportDefinition = (ReportDefinition)req.getSession().getAttribute("p");
            if (report == null) {
                if (reportDefinition == null) {
                    throw new ReportDesignException("Report data has expired,can not do export pdf.");
                }
                report = this.reportBuilder.buildReport(reportDefinition, parameters);
            }
        } else {
            report = CacheUtils.getReport((String)fullName);
            if (report == null) {
                reportDefinition = this.reportRender.getReportDefinition(file);
                report = this.reportRender.render(reportDefinition, parameters);
            }
        }
        String paper = req.getParameter("_paper");
        ObjectMapper mapper = new ObjectMapper();
        Paper newPaper = (Paper)mapper.readValue(paper, Paper.class);
        report.rePaging(newPaper);
    }

    public void setReportRender(ReportRender reportRender) {
        this.reportRender = reportRender;
    }

    public void setExportManager(ExportManager exportManager) {
        this.exportManager = exportManager;
    }

    public void setReportBuilder(ReportBuilder reportBuilder) {
        this.reportBuilder = reportBuilder;
    }

    @Override
    public String url() {
        return "/pdf";
    }
}

