/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.console.chart;

import com.bstek.ureport.cache.CacheUtils;
import com.bstek.ureport.chart.ChartData;
import com.bstek.ureport.console.RenderPageServletAction;
import com.bstek.ureport.model.Report;
import com.bstek.ureport.utils.UnitUtils;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ChartServletAction
extends RenderPageServletAction {
    @Override
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = this.retriveMethod(req);
        if (method != null) {
            this.invokeMethod(method, req, resp);
        }
    }

    public void storeData(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map map;
        ChartData chartData;
        String file = req.getParameter("_u");
        Map<String, Object> parameters = this.buildParameters(req);
        String fullName = String.valueOf(file) + parameters.toString();
        Report report = CacheUtils.getReport((String)fullName);
        if (report == null) {
            return;
        }
        String chartId = req.getParameter("_chartId");
        String base64Data = req.getParameter("_base64Data");
        String prefix = "data:image/png;base64,";
        if (base64Data != null && base64Data.startsWith(prefix)) {
            base64Data = base64Data.substring(prefix.length(), base64Data.length());
        }
        if ((chartData = (ChartData)(map = report.getContext().getChartDataMap()).get(chartId)) == null) {
            return;
        }
        chartData.setBase64Data(base64Data);
        String width = req.getParameter("_width");
        String height = req.getParameter("_height");
        chartData.setHeight(UnitUtils.pixelToPoint((double)Integer.valueOf(height).intValue()));
        chartData.setWidth(UnitUtils.pixelToPoint((double)Integer.valueOf(width).intValue()));
    }

    @Override
    public String url() {
        return "/chart";
    }
}

