/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.console.importexcel;

import com.bstek.ureport.console.importexcel.ExcelParser;
import com.bstek.ureport.console.importexcel.Span;
import com.bstek.ureport.definition.Alignment;
import com.bstek.ureport.definition.Border;
import com.bstek.ureport.definition.CellDefinition;
import com.bstek.ureport.definition.CellStyle;
import com.bstek.ureport.definition.ColumnDefinition;
import com.bstek.ureport.definition.Orientation;
import com.bstek.ureport.definition.PagingMode;
import com.bstek.ureport.definition.Paper;
import com.bstek.ureport.definition.PaperSize;
import com.bstek.ureport.definition.PaperType;
import com.bstek.ureport.definition.ReportDefinition;
import com.bstek.ureport.definition.RowDefinition;
import com.bstek.ureport.definition.value.SimpleValue;
import com.bstek.ureport.definition.value.Value;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public class HSSFExcelParser
extends ExcelParser {
    @Override
    public ReportDefinition parse(InputStream inputStream) throws Exception {
        ReportDefinition report = new ReportDefinition();
        ArrayList<RowDefinition> rowDefs = new ArrayList<RowDefinition>();
        report.setRows(rowDefs);
        ArrayList<ColumnDefinition> columnDefs = new ArrayList<ColumnDefinition>();
        report.setColumns(columnDefs);
        ArrayList<CellDefinition> cellDefs = new ArrayList<CellDefinition>();
        report.setCells(cellDefs);
        HSSFWorkbook book = new HSSFWorkbook(inputStream);
        HSSFSheet sheet = book.getSheetAt(0);
        int firstRow = 0;
        int rowCount = sheet.getPhysicalNumberOfRows();
        int maxColumnCount = this.buildMaxColumn(sheet);
        int i = firstRow;
        while (i < rowCount) {
            RowDefinition rowDef;
            HSSFRow row = sheet.getRow(i);
            if (row == null) {
                rowDef = new RowDefinition();
                rowDef.setHeight(20);
                rowDef.setRowNumber(i + 1);
                rowDefs.add(rowDef);
                this.addBlankCells(cellDefs, i + 1, maxColumnCount);
            } else {
                rowDef = new RowDefinition();
                int height = row.getHeight() / 20;
                rowDef.setHeight(height);
                rowDef.setRowNumber(i + 1);
                rowDefs.add(rowDef);
                int j = 0;
                while (j < maxColumnCount) {
                    boolean isMergeRegion = this.isMergedRegion(sheet, i, j);
                    if (!isMergeRegion) {
                        HSSFCell cell = row.getCell(j);
                        if (cell == null) {
                            CellDefinition cellDef = new CellDefinition();
                            cellDef.setValue((Value)new SimpleValue(""));
                            cellDef.setRowNumber(i + 1);
                            cellDef.setColumnNumber(j + 1);
                            cellDefs.add(cellDef);
                        } else {
                            Span span = this.getSpan(sheet, i, j);
                            Object value = null;
                            CellType cellType = cell.getCellTypeEnum();
                            switch (cellType) {
                                case STRING: {
                                    value = cell.getStringCellValue();
                                    break;
                                }
                                case BOOLEAN: {
                                    value = cell.getBooleanCellValue();
                                    break;
                                }
                                case NUMERIC: {
                                    value = cell.getNumericCellValue();
                                    break;
                                }
                                case FORMULA: {
                                    value = cell.getCellFormula();
                                    break;
                                }
                                default: {
                                    value = "";
                                }
                            }
                            CellDefinition cellDef = new CellDefinition();
                            cellDef.setValue((Value)new SimpleValue(value != null ? value.toString() : ""));
                            cellDef.setRowNumber(i + 1);
                            cellDef.setColumnNumber(j + 1);
                            cellDef.setRowSpan(span.getRowSpan());
                            cellDef.setColSpan(span.getColSpan());
                            cellDef.setCellStyle(this.buildCellStyle(cell, book));
                            cellDefs.add(cellDef);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < maxColumnCount) {
            ColumnDefinition col = new ColumnDefinition();
            int width = sheet.getColumnWidth(i);
            col.setWidth(width / 37);
            col.setColumnNumber(i + 1);
            columnDefs.add(col);
            ++i;
        }
        book.close();
        inputStream.close();
        Paper paper = new Paper();
        paper.setPaperType(PaperType.A4);
        paper.setOrientation(Orientation.portrait);
        paper.setPagingMode(PagingMode.fitpage);
        PaperSize pageSize = PaperType.A4.getPaperSize();
        paper.setWidth(pageSize.getWidth());
        paper.setHeight(paper.getHeight());
        report.setPaper(paper);
        return report;
    }

    private CellStyle buildCellStyle(HSSFCell cell, HSSFWorkbook book) {
        Border border;
        HSSFColor bgcolor;
        HSSFColor color;
        CellStyle style = new CellStyle();
        HSSFCellStyle cellStyle = cell.getCellStyle();
        HorizontalAlignment align = cellStyle.getAlignmentEnum();
        if (align.equals((Object)HorizontalAlignment.CENTER)) {
            style.setAlign(Alignment.center);
        } else if (align.equals((Object)HorizontalAlignment.RIGHT)) {
            style.setAlign(Alignment.right);
        } else {
            style.setAlign(Alignment.left);
        }
        VerticalAlignment valign = cellStyle.getVerticalAlignmentEnum();
        if (valign.equals((Object)VerticalAlignment.BOTTOM)) {
            style.setValign(Alignment.bottom);
        } else if (valign.equals((Object)VerticalAlignment.TOP)) {
            style.setValign(Alignment.top);
        } else if (valign.equals((Object)VerticalAlignment.CENTER)) {
            style.setValign(Alignment.middle);
        } else {
            style.setValign(Alignment.middle);
        }
        HSSFFont font = cellStyle.getFont((Workbook)book);
        if (font.getBold()) {
            style.setBold(Boolean.valueOf(true));
        }
        if (font.getItalic()) {
            style.setItalic(Boolean.valueOf(true));
        }
        if (font.getUnderline() != 0) {
            style.setUnderline(Boolean.valueOf(true));
        }
        if ((color = font.getHSSFColor(book)) != null) {
            short[] rgb = color.getTriplet();
            style.setForecolor(String.valueOf(rgb[0]) + "," + rgb[1] + "," + rgb[2]);
        } else {
            style.setForecolor("0,0,0");
        }
        FillPatternType pattern = cellStyle.getFillPatternEnum();
        if (pattern != null && pattern.equals((Object)FillPatternType.SOLID_FOREGROUND) && (bgcolor = cellStyle.getFillForegroundColorColor()) != null) {
            short[] rgb = bgcolor.getTriplet();
            style.setBgcolor(String.valueOf(rgb[0]) + "," + rgb[1] + "," + rgb[2]);
        }
        int fontSize = font.getFontHeight() / 20;
        style.setFontSize(fontSize);
        BorderStyle borderStyle = cellStyle.getBorderLeftEnum();
        if (!borderStyle.equals((Object)BorderStyle.NONE)) {
            border = new Border();
            border.setColor("0,0,0");
            border.setStyle(com.bstek.ureport.definition.BorderStyle.solid);
            border.setWidth(1);
            style.setLeftBorder(border);
        }
        if (!(borderStyle = cellStyle.getBorderRightEnum()).equals((Object)BorderStyle.NONE)) {
            border = new Border();
            border.setColor("0,0,0");
            border.setStyle(com.bstek.ureport.definition.BorderStyle.solid);
            border.setWidth(1);
            style.setRightBorder(border);
        }
        if (!(borderStyle = cellStyle.getBorderTopEnum()).equals((Object)BorderStyle.NONE)) {
            border = new Border();
            border.setColor("0,0,0");
            border.setStyle(com.bstek.ureport.definition.BorderStyle.solid);
            border.setWidth(1);
            style.setTopBorder(border);
        }
        if (!(borderStyle = cellStyle.getBorderBottomEnum()).equals((Object)BorderStyle.NONE)) {
            border = new Border();
            border.setColor("0,0,0");
            border.setStyle(com.bstek.ureport.definition.BorderStyle.solid);
            border.setWidth(1);
            style.setBottomBorder(border);
        }
        return style;
    }

    private Span getSpan(HSSFSheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        int i = 0;
        while (i < sheetMergeCount) {
            CellRangeAddress range = sheet.getMergedRegion(i);
            int firstColumn = range.getFirstColumn();
            int lastColumn = range.getLastColumn();
            int firstRow = range.getFirstRow();
            if (row == firstRow && column == firstColumn) {
                int colSpan;
                int lastRow = range.getLastRow();
                int rowSpan = lastRow - firstRow;
                if (rowSpan > 0) {
                    ++rowSpan;
                }
                if ((colSpan = lastColumn - firstColumn) > 0) {
                    ++colSpan;
                }
                return new Span(rowSpan, colSpan);
            }
            ++i;
        }
        return new Span(0, 0);
    }

    private boolean isMergedRegion(HSSFSheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        int i = 0;
        while (i < sheetMergeCount) {
            CellRangeAddress range = sheet.getMergedRegion(i);
            int firstColumn = range.getFirstColumn();
            int lastColumn = range.getLastColumn();
            int firstRow = range.getFirstRow();
            int lastRow = range.getLastRow();
            if (row > firstRow && row < lastRow && column > firstColumn && column < lastColumn) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int buildMaxColumn(HSSFSheet sheet) {
        int rowCount = sheet.getPhysicalNumberOfRows();
        int maxColumnCount = 0;
        int i = 0;
        while (i < rowCount) {
            int columnCount;
            HSSFRow row = sheet.getRow(i);
            if (row != null && (columnCount = row.getPhysicalNumberOfCells()) > maxColumnCount) {
                maxColumnCount = columnCount;
            }
            ++i;
        }
        return maxColumnCount;
    }

    protected void addBlankCells(List<CellDefinition> cellDefs, int rowNumber, int totalColumn) {
        int i = 0;
        while (i < totalColumn) {
            CellDefinition cellDef = new CellDefinition();
            cellDef.setValue((Value)new SimpleValue(""));
            cellDef.setRowNumber(rowNumber);
            cellDef.setColumnNumber(i + 1);
            cellDefs.add(cellDef);
            ++i;
        }
    }

    @Override
    public boolean support(String name) {
        return name.toLowerCase().endsWith(".xls");
    }
}

