/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.console.cache;

import com.bstek.ureport.cache.ReportCache;
import com.bstek.ureport.console.RequestHolder;
import com.bstek.ureport.console.cache.ReportMapObject;
import com.bstek.ureport.model.Report;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class HttpSessionReportCache
implements ReportCache {
    private Map<String, ReportMapObject> sessionReportMap = new HashMap<String, ReportMapObject>();
    private boolean disabled;

    public Report getReport(String file) {
        HttpServletRequest req = RequestHolder.getRequest();
        if (req == null) {
            return null;
        }
        ReportMapObject reportMapObject = this.getReportMap(req);
        return reportMapObject.getReport(file);
    }

    public void storeReport(String file, Report report) {
        HttpServletRequest req = RequestHolder.getRequest();
        if (req == null) {
            return;
        }
        ReportMapObject reportMapObject = this.getReportMap(req);
        reportMapObject.put(file, report);
    }

    public boolean disabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    private ReportMapObject getReportMap(HttpServletRequest req) {
        ArrayList<String> expiredList = new ArrayList<String>();
        for (String key : this.sessionReportMap.keySet()) {
            ReportMapObject reportObj = this.sessionReportMap.get(key);
            if (!reportObj.isExpired()) continue;
            expiredList.add(key);
        }
        for (String key : expiredList) {
            this.sessionReportMap.remove(key);
        }
        String sessionId = req.getSession().getId();
        ReportMapObject reportObject = this.sessionReportMap.get(sessionId);
        if (reportObject != null) {
            return reportObject;
        }
        ReportMapObject reportMapObject = new ReportMapObject();
        this.sessionReportMap.put(sessionId, reportMapObject);
        return reportMapObject;
    }
}

