/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.console.html;

import com.bstek.ureport.build.ReportBuilder;
import com.bstek.ureport.build.paging.Page;
import com.bstek.ureport.cache.CacheUtils;
import com.bstek.ureport.chart.ChartData;
import com.bstek.ureport.console.MobileUtils;
import com.bstek.ureport.console.RenderPageServletAction;
import com.bstek.ureport.console.cache.TempObjectCache;
import com.bstek.ureport.console.exception.ReportDesignException;
import com.bstek.ureport.console.html.Tools;
import com.bstek.ureport.definition.Paper;
import com.bstek.ureport.definition.ReportDefinition;
import com.bstek.ureport.definition.searchform.FormPosition;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.export.ExportManager;
import com.bstek.ureport.export.FullPageData;
import com.bstek.ureport.export.PageBuilder;
import com.bstek.ureport.export.ReportRender;
import com.bstek.ureport.export.SinglePageData;
import com.bstek.ureport.export.html.HtmlProducer;
import com.bstek.ureport.export.html.HtmlReport;
import com.bstek.ureport.export.html.SearchFormData;
import com.bstek.ureport.model.Report;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.codehaus.jackson.map.ObjectMapper;

public class HtmlPreviewServletAction
extends RenderPageServletAction {
    private ExportManager exportManager;
    private ReportBuilder reportBuilder;
    private ReportRender reportRender;
    private HtmlProducer htmlProducer = new HtmlProducer();

    @Override
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = this.retriveMethod(req);
        if (method != null) {
            this.invokeMethod(method, req, resp);
        } else {
            VelocityContext context = new VelocityContext();
            HtmlReport htmlReport = null;
            String errorMsg = null;
            try {
                htmlReport = this.loadReport(req);
            }
            catch (Exception ex) {
                if (!(ex instanceof ReportDesignException)) {
                    ex.printStackTrace();
                }
                errorMsg = this.buildExceptionMessage(ex);
            }
            String title = this.buildTitle(req);
            context.put("title", (Object)title);
            if (htmlReport == null) {
                context.put("content", (Object)("<div style='color:red'><strong>\u62a5\u8868\u8ba1\u7b97\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a</strong><br><div style=\"margin:10px\">" + errorMsg + "</div></div>"));
                context.put("error", (Object)true);
                context.put("searchFormJs", (Object)"");
                context.put("downSearchFormHtml", (Object)"");
                context.put("upSearchFormHtml", (Object)"");
            } else {
                SearchFormData formData = htmlReport.getSearchFormData();
                if (formData != null) {
                    context.put("searchFormJs", (Object)formData.getJs());
                    if (formData.getFormPosition().equals((Object)FormPosition.up)) {
                        context.put("upSearchFormHtml", (Object)formData.getHtml());
                        context.put("downSearchFormHtml", (Object)"");
                    } else {
                        context.put("downSearchFormHtml", (Object)formData.getHtml());
                        context.put("upSearchFormHtml", (Object)"");
                    }
                } else {
                    context.put("searchFormJs", (Object)"");
                    context.put("downSearchFormHtml", (Object)"");
                    context.put("upSearchFormHtml", (Object)"");
                }
                context.put("content", (Object)htmlReport.getContent());
                context.put("style", (Object)htmlReport.getStyle());
                context.put("reportAlign", (Object)htmlReport.getReportAlign());
                context.put("totalPage", (Object)htmlReport.getTotalPage());
                context.put("totalPageWithCol", (Object)htmlReport.getTotalPageWithCol());
                context.put("pageIndex", (Object)htmlReport.getPageIndex());
                context.put("chartDatas", (Object)this.convertJson(htmlReport.getChartDatas()));
                context.put("error", (Object)false);
                context.put("file", (Object)req.getParameter("_u"));
                context.put("intervalRefreshValue", (Object)htmlReport.getHtmlIntervalRefreshValue());
                String customParameters = this.buildCustomParameters(req);
                context.put("customParameters", (Object)customParameters);
                context.put("_t", (Object)"");
                Tools tools = null;
                if (MobileUtils.isMobile(req)) {
                    tools = new Tools(false);
                    tools.setShow(false);
                } else {
                    String toolsInfo = req.getParameter("_t");
                    if (StringUtils.isNotBlank((String)toolsInfo)) {
                        tools = new Tools(false);
                        if (toolsInfo.equals("0")) {
                            tools.setShow(false);
                        } else {
                            String[] infos;
                            for (String name : infos = toolsInfo.split(",")) {
                                tools.doInit(name);
                            }
                        }
                        context.put("_t", (Object)toolsInfo);
                        context.put("hasTools", (Object)true);
                    } else {
                        tools = new Tools(true);
                    }
                }
                context.put("tools", (Object)tools);
            }
            context.put("contextPath", (Object)req.getContextPath());
            resp.setContentType("text/html");
            resp.setCharacterEncoding("utf-8");
            Template template = this.ve.getTemplate("ureport-html/html-preview.html", "utf-8");
            PrintWriter writer = resp.getWriter();
            template.merge((Context)context, (Writer)writer);
            writer.close();
        }
    }

    private String buildTitle(HttpServletRequest req) {
        String title = req.getParameter("_title");
        if (StringUtils.isBlank((String)title)) {
            title = req.getParameter("_u");
            int point = (title = this.decode(title)).lastIndexOf(".ureport.xml");
            if (point > -1) {
                title = title.substring(0, point);
            }
            if (title.equals("p")) {
                title = "\u8bbe\u8ba1\u4e2d\u62a5\u8868";
            }
        } else {
            title = this.decode(title);
        }
        return title + "-ureport";
    }

    private String convertJson(Collection<ChartData> data) {
        if (data == null || data.size() == 0) {
            return "";
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            String json = mapper.writeValueAsString(data);
            return json;
        }
        catch (Exception e) {
            throw new ReportComputeException(e);
        }
    }

    public void loadData(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HtmlReport htmlReport = this.loadReport(req);
        this.writeObjectToJson(resp, htmlReport);
    }

    public void loadPrintPages(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String file = req.getParameter("_u");
        if (StringUtils.isBlank((String)(file = this.decode(file)))) {
            throw new ReportComputeException("Report file can not be null.");
        }
        Map<String, Object> parameters = this.buildParameters(req);
        String fullName = file + parameters.toString();
        Report report = CacheUtils.getReport((String)fullName);
        if (report == null) {
            ReportDefinition reportDefinition = null;
            if (fullName.equals("p")) {
                reportDefinition = (ReportDefinition)TempObjectCache.getObject("p");
                if (reportDefinition == null) {
                    throw new ReportDesignException("Report data has expired,can not do export excel.");
                }
            } else {
                reportDefinition = this.reportRender.getReportDefinition(file);
            }
            report = this.reportBuilder.buildReport(reportDefinition, parameters);
        }
        FullPageData pageData = PageBuilder.buildFullPageData((Report)report);
        StringBuilder sb = new StringBuilder();
        List list = pageData.getPageList();
        com.bstek.ureport.build.Context context = report.getContext();
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                String html;
                List columnPages = (List)list.get(i);
                if (i == 0) {
                    html = this.htmlProducer.produce(context, columnPages, pageData.getColumnMargin(), false);
                    sb.append(html);
                    continue;
                }
                html = this.htmlProducer.produce(context, columnPages, pageData.getColumnMargin(), false);
                sb.append(html);
            }
        } else {
            List pages = report.getPages();
            for (int i = 0; i < pages.size(); ++i) {
                String html;
                Page page = (Page)pages.get(i);
                if (i == 0) {
                    html = this.htmlProducer.produce(context, page, false);
                    sb.append(html);
                    continue;
                }
                html = this.htmlProducer.produce(context, page, true);
                sb.append(html);
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("html", sb.toString());
        this.writeObjectToJson(resp, map);
    }

    public void loadPagePaper(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String file = req.getParameter("_u");
        if (StringUtils.isBlank((String)(file = this.decode(file)))) {
            throw new ReportComputeException("Report file can not be null.");
        }
        ReportDefinition report = null;
        if (file.equals("p")) {
            report = (ReportDefinition)TempObjectCache.getObject("p");
            if (report == null) {
                throw new ReportDesignException("Report data has expired.");
            }
        } else {
            report = this.reportRender.getReportDefinition(file);
        }
        Paper paper = report.getPaper();
        this.writeObjectToJson(resp, paper);
    }

    private HtmlReport loadReport(HttpServletRequest req) {
        Map<String, Object> parameters = this.buildParameters(req);
        HtmlReport htmlReport = null;
        String file = req.getParameter("_u");
        file = this.decode(file);
        String fullName = file + parameters.toString();
        String pageIndex = req.getParameter("_i");
        String reload = req.getParameter("_r");
        if (StringUtils.isBlank((String)file)) {
            throw new ReportComputeException("Report file can not be null.");
        }
        if (file.equals("p")) {
            Report report = null;
            if (StringUtils.isNotBlank((String)pageIndex) && !pageIndex.equals("0") && StringUtils.isBlank((String)reload)) {
                report = CacheUtils.getReport((String)fullName);
            }
            ReportDefinition reportDefinition = (ReportDefinition)TempObjectCache.getObject("p");
            if (report == null) {
                if (reportDefinition == null) {
                    throw new ReportDesignException("Report data has expired,can not do preview.");
                }
                report = this.reportBuilder.buildReport(reportDefinition, parameters);
                CacheUtils.storeReport((String)fullName, (Report)report);
            }
            htmlReport = new HtmlReport();
            String html = null;
            if (StringUtils.isNotBlank((String)pageIndex) && !pageIndex.equals("0")) {
                com.bstek.ureport.build.Context context = report.getContext();
                int index = Integer.valueOf(pageIndex);
                SinglePageData pageData = PageBuilder.buildSinglePageData((int)index, (Report)report);
                List pages = pageData.getPages();
                if (pages.size() == 1) {
                    Page page = (Page)pages.get(0);
                    html = this.htmlProducer.produce(context, page, false);
                } else {
                    html = this.htmlProducer.produce(context, pages, pageData.getColumnMargin(), false);
                }
                htmlReport.setTotalPage(pageData.getTotalPages());
                htmlReport.setPageIndex(index);
            } else {
                html = this.htmlProducer.produce(report);
            }
            if (report.getPaper().isColumnEnabled()) {
                htmlReport.setColumn(report.getPaper().getColumnCount());
            }
            htmlReport.setChartDatas(report.getContext().getChartDataMap().values());
            htmlReport.setContent(html);
            htmlReport.setTotalPage(report.getPages().size());
            htmlReport.setStyle(reportDefinition.getStyle());
            htmlReport.setSearchFormData(reportDefinition.buildSearchFormData(report.getContext().getDatasetMap(), parameters));
            htmlReport.setReportAlign(report.getPaper().getHtmlReportAlign().name());
            htmlReport.setHtmlIntervalRefreshValue(report.getPaper().getHtmlIntervalRefreshValue());
        } else if (StringUtils.isNotBlank((String)pageIndex) && !pageIndex.equals("0")) {
            int index = Integer.valueOf(pageIndex);
            htmlReport = this.exportManager.exportHtml(file, req.getContextPath(), parameters, index);
        } else {
            htmlReport = this.exportManager.exportHtml(file, req.getContextPath(), parameters);
        }
        return htmlReport;
    }

    private String buildCustomParameters(HttpServletRequest req) {
        StringBuilder sb = new StringBuilder();
        Enumeration enumeration = req.getParameterNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (obj == null) continue;
            String name = obj.toString();
            String value = req.getParameter(name);
            if (name == null || value == null || name.startsWith("_") && !name.equals("_n")) continue;
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(name);
            sb.append("=");
            sb.append(value);
        }
        return sb.toString();
    }

    private String buildExceptionMessage(Throwable throwable) {
        Throwable root = this.buildRootException(throwable);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        root.printStackTrace(pw);
        String trace = sw.getBuffer().toString();
        trace = trace.replaceAll("\n", "<br>");
        pw.close();
        return trace;
    }

    public void setExportManager(ExportManager exportManager) {
        this.exportManager = exportManager;
    }

    public void setReportBuilder(ReportBuilder reportBuilder) {
        this.reportBuilder = reportBuilder;
    }

    public void setReportRender(ReportRender reportRender) {
        this.reportRender = reportRender;
    }

    @Override
    public String url() {
        return "/preview";
    }
}

