/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.console.designer;

import com.bstek.ureport.cache.CacheUtils;
import com.bstek.ureport.console.RenderPageServletAction;
import com.bstek.ureport.console.cache.TempObjectCache;
import com.bstek.ureport.console.designer.ReportDefinitionWrapper;
import com.bstek.ureport.console.designer.ReportUtils;
import com.bstek.ureport.console.exception.ReportDesignException;
import com.bstek.ureport.definition.ReportDefinition;
import com.bstek.ureport.dsl.ReportParserLexer;
import com.bstek.ureport.dsl.ReportParserParser;
import com.bstek.ureport.export.ReportRender;
import com.bstek.ureport.expression.ScriptErrorListener;
import com.bstek.ureport.parser.ReportParser;
import com.bstek.ureport.provider.report.ReportProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class DesignerServletAction
extends RenderPageServletAction {
    private ReportRender reportRender;
    private ReportParser reportParser;
    private List<ReportProvider> reportProviders = new ArrayList<ReportProvider>();

    @Override
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = this.retriveMethod(req);
        if (method != null) {
            this.invokeMethod(method, req, resp);
        } else {
            VelocityContext context = new VelocityContext();
            context.put("contextPath", (Object)req.getContextPath());
            resp.setContentType("text/html");
            resp.setCharacterEncoding("utf-8");
            Template template = this.ve.getTemplate("ureport-html/designer.html", "utf-8");
            PrintWriter writer = resp.getWriter();
            template.merge((Context)context, (Writer)writer);
            writer.close();
        }
    }

    public void scriptValidation(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String content = req.getParameter("content");
        ANTLRInputStream antlrInputStream = new ANTLRInputStream(content);
        ReportParserLexer lexer = new ReportParserLexer((CharStream)antlrInputStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        ReportParserParser parser = new ReportParserParser((TokenStream)tokenStream);
        ScriptErrorListener errorListener = new ScriptErrorListener();
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        parser.expression();
        List infos = errorListener.getInfos();
        this.writeObjectToJson(resp, infos);
    }

    public void conditionScriptValidation(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String content = req.getParameter("content");
        ANTLRInputStream antlrInputStream = new ANTLRInputStream(content);
        ReportParserLexer lexer = new ReportParserLexer((CharStream)antlrInputStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        ReportParserParser parser = new ReportParserParser((TokenStream)tokenStream);
        ScriptErrorListener errorListener = new ScriptErrorListener();
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        parser.expr();
        List infos = errorListener.getInfos();
        this.writeObjectToJson(resp, infos);
    }

    public void parseDatasetName(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String expr = req.getParameter("expr");
        ANTLRInputStream antlrInputStream = new ANTLRInputStream(expr);
        ReportParserLexer lexer = new ReportParserLexer((CharStream)antlrInputStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        ReportParserParser parser = new ReportParserParser((TokenStream)tokenStream);
        parser.removeErrorListeners();
        ReportParserParser.DatasetContext ctx = parser.dataset();
        String datasetName = ctx.Identifier().getText();
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("datasetName", datasetName);
        this.writeObjectToJson(resp, result);
    }

    public void savePreviewData(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String content = req.getParameter("content");
        content = this.decode(content);
        InputStream inputStream = IOUtils.toInputStream((String)content, (String)"utf-8");
        ReportDefinition reportDef = this.reportParser.parse(inputStream, "p");
        this.reportRender.rebuildReportDefinition(reportDef);
        IOUtils.closeQuietly((InputStream)inputStream);
        TempObjectCache.putObject("p", reportDef);
    }

    public void loadReport(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String file = req.getParameter("file");
        if (file == null) {
            throw new ReportDesignException("Report file can not be null.");
        }
        Object obj = TempObjectCache.getObject(file = ReportUtils.decodeFileName(file));
        if (obj != null && obj instanceof ReportDefinition) {
            ReportDefinition reportDef = (ReportDefinition)obj;
            TempObjectCache.removeObject(file);
            this.writeObjectToJson(resp, new ReportDefinitionWrapper(reportDef));
        } else {
            ReportDefinition reportDef = this.reportRender.parseReport(file);
            this.writeObjectToJson(resp, new ReportDefinitionWrapper(reportDef));
        }
    }

    public void deleteReportFile(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String file = req.getParameter("file");
        if (file == null) {
            throw new ReportDesignException("Report file can not be null.");
        }
        ReportProvider targetReportProvider = null;
        for (ReportProvider provider : this.reportProviders) {
            if (!file.startsWith(provider.getPrefix())) continue;
            targetReportProvider = provider;
            break;
        }
        if (targetReportProvider == null) {
            throw new ReportDesignException("File [" + file + "] not found available report provider.");
        }
        targetReportProvider.deleteReport(file);
    }

    public void saveReportFile(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String file = req.getParameter("file");
        file = ReportUtils.decodeFileName(file);
        String content = req.getParameter("content");
        content = this.decode(content);
        ReportProvider targetReportProvider = null;
        for (ReportProvider provider : this.reportProviders) {
            if (!file.startsWith(provider.getPrefix())) continue;
            targetReportProvider = provider;
            break;
        }
        if (targetReportProvider == null) {
            throw new ReportDesignException("File [" + file + "] not found available report provider.");
        }
        targetReportProvider.saveReport(file, content);
        InputStream inputStream = IOUtils.toInputStream((String)content, (String)"utf-8");
        ReportDefinition reportDef = this.reportParser.parse(inputStream, file);
        this.reportRender.rebuildReportDefinition(reportDef);
        CacheUtils.cacheReportDefinition((String)file, (ReportDefinition)reportDef);
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    public void loadReportProviders(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.writeObjectToJson(resp, this.reportProviders);
    }

    public void setReportRender(ReportRender reportRender) {
        this.reportRender = reportRender;
    }

    public void setReportParser(ReportParser reportParser) {
        this.reportParser = reportParser;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        super.setApplicationContext(applicationContext);
        Collection providers = applicationContext.getBeansOfType(ReportProvider.class).values();
        for (ReportProvider provider : providers) {
            if (provider.disabled() || provider.getName() == null) continue;
            this.reportProviders.add(provider);
        }
    }

    @Override
    public String url() {
        return "/designer";
    }
}

