/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.graphml.report.impl;

import com.buschmais.jqassistant.core.analysis.api.Result;
import com.buschmais.jqassistant.core.analysis.api.rule.Concept;
import com.buschmais.jqassistant.core.analysis.api.rule.ExecutableRule;
import com.buschmais.jqassistant.core.analysis.api.rule.Rule;
import com.buschmais.jqassistant.core.report.api.AbstractReportPlugin;
import com.buschmais.jqassistant.core.report.api.ReportContext;
import com.buschmais.jqassistant.core.report.api.ReportException;
import com.buschmais.jqassistant.core.report.api.ReportHelper;
import com.buschmais.jqassistant.core.report.api.ReportPlugin;
import com.buschmais.jqassistant.core.report.api.graph.SubGraphFactory;
import com.buschmais.jqassistant.core.report.api.graph.model.SubGraph;
import com.buschmais.jqassistant.core.shared.reflection.ClassHelper;
import com.buschmais.jqassistant.plugin.graphml.report.decorator.YedGraphMLDecorator;
import com.buschmais.jqassistant.plugin.graphml.report.impl.XmlGraphMLWriter;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ReportPlugin.Default
public class GraphMLReportPlugin
extends AbstractReportPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphMLReportPlugin.class);
    public static final String GRAPHML = "graphml";
    public static final String FILEEXTENSION_GRAPHML = ".graphml";
    private static final String CONCEPT_PATTERN = "graphml.report.conceptPattern";
    private static final String GRAPHMML_REPORT_DIRECTORY = "graphml.report.directory";
    private static final String GRAPHML_DEFAULT_DECORATOR = "graphml.report.defaultDecorator";
    private ReportContext reportContext;
    private String conceptPattern = ".*\\.graphml$";
    private File reportDirectory;
    private SubGraphFactory subGraphFactory;
    private XmlGraphMLWriter xmlGraphMLWriter;

    public void configure(ReportContext reportContext, Map<String, Object> properties) {
        this.reportContext = reportContext;
        this.conceptPattern = this.getProperty(properties, CONCEPT_PATTERN, this.conceptPattern);
        String reportDirectoryValue = (String)properties.get(GRAPHMML_REPORT_DIRECTORY);
        File file = this.reportDirectory = reportDirectoryValue != null ? new File(reportDirectoryValue) : reportContext.getReportDirectory(GRAPHML);
        if (this.reportDirectory.mkdirs()) {
            LOGGER.info("Created directory " + this.reportDirectory.getAbsolutePath());
        }
        String defaultDecorator = this.getProperty(properties, GRAPHML_DEFAULT_DECORATOR, YedGraphMLDecorator.class.getName());
        ClassHelper classHelper = new ClassHelper(GraphMLReportPlugin.class.getClassLoader());
        Class defaultDecoratorType = classHelper.getType(defaultDecorator);
        this.xmlGraphMLWriter = new XmlGraphMLWriter(classHelper, defaultDecoratorType, properties);
    }

    private String getProperty(Map<String, Object> properties, String property, String defaultValue) {
        String value = (String)properties.get(property);
        return value != null ? value : defaultValue;
    }

    public void begin() {
        this.subGraphFactory = new SubGraphFactory();
    }

    public void setResult(Result<? extends ExecutableRule> result) throws ReportException {
        ExecutableRule rule = result.getRule();
        Set selectedReports = result.getRule().getReport().getSelectedTypes();
        if (selectedReports != null && selectedReports.contains(GRAPHML) || rule instanceof Concept && rule.getId().matches(this.conceptPattern)) {
            SubGraph subGraph = this.subGraphFactory.createSubGraph(result);
            try {
                String fileName = ReportHelper.escapeRuleId((Rule)rule);
                if (!fileName.endsWith(FILEEXTENSION_GRAPHML)) {
                    fileName = fileName + FILEEXTENSION_GRAPHML;
                }
                File file = new File(this.reportDirectory, fileName);
                this.xmlGraphMLWriter.write(result, subGraph, file);
                this.reportContext.addReport("GraphML", result.getRule(), ReportContext.ReportType.LINK, file.toURI().toURL());
            }
            catch (IOException | XMLStreamException e) {
                throw new ReportException("Cannot write custom report.", (Throwable)e);
            }
        }
    }
}

