/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.graphml.report.impl;

import com.buschmais.jqassistant.core.analysis.api.Result;
import com.buschmais.jqassistant.core.report.api.graph.model.Node;
import com.buschmais.jqassistant.core.report.api.graph.model.PropertyContainer;
import com.buschmais.jqassistant.core.report.api.graph.model.Relationship;
import com.buschmais.jqassistant.core.report.api.graph.model.SubGraph;
import com.buschmais.jqassistant.core.shared.reflection.ClassHelper;
import com.buschmais.jqassistant.plugin.graphml.report.api.GraphMLDecorator;
import com.buschmais.jqassistant.plugin.graphml.report.impl.GraphMLNamespaceContext;
import com.buschmais.jqassistant.plugin.graphml.report.impl.MetaInformation;
import com.sun.xml.txw2.output.IndentingXMLStreamWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

class XmlGraphMLWriter {
    private static final String GRAPHML_DECORATOR = "graphml.report.decorator";
    private static final XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
    private ClassHelper classHelper;
    private Class<? extends GraphMLDecorator> defaultDecoratorClass;
    private Map<String, Object> properties;

    XmlGraphMLWriter(ClassHelper classHelper, Class<? extends GraphMLDecorator> defaultDecoratorClass, Map<String, Object> properties) {
        this.classHelper = classHelper;
        this.defaultDecoratorClass = defaultDecoratorClass;
        this.properties = properties;
    }

    void write(Result<?> result, SubGraph graph, File file) throws IOException, XMLStreamException {
        try (PrintWriter writer = new PrintWriter(new FileWriter(file));
             GraphMLDecorator decorator = this.getGraphMLDecorator(result);){
            IndentingXMLStreamWriter xmlWriter = new IndentingXMLStreamWriter(xmlOutputFactory.createXMLStreamWriter(writer));
            decorator.initialize(result, graph, (XMLStreamWriter)xmlWriter, file, this.properties);
            GraphMLNamespaceContext context = new GraphMLNamespaceContext(decorator.getNamespaces(), decorator.getSchemaLocations());
            xmlWriter.setNamespaceContext(context);
            this.writeHeader((XMLStreamWriter)xmlWriter, context);
            Collection<Node> nodes = this.getAllNodes(graph);
            Collection<Relationship> relationships = this.getAllRelationships(graph);
            this.writeKeyTypes((XMLStreamWriter)xmlWriter, nodes, relationships);
            decorator.writeKeys();
            this.writeSubgraph(graph, (XMLStreamWriter)xmlWriter, decorator);
            HashSet<Long> allNodeIds = new HashSet<Long>();
            for (Node node : nodes) {
                allNodeIds.add(node.getId());
            }
            for (Relationship relationship : relationships) {
                long startId = relationship.getStartNode().getId();
                long endId = relationship.getEndNode().getId();
                if (!allNodeIds.contains(startId) || !allNodeIds.contains(endId)) continue;
                this.writeRelationship((XMLStreamWriter)xmlWriter, decorator, relationship);
            }
            this.writeFooter((XMLStreamWriter)xmlWriter);
            decorator.close();
        }
    }

    private GraphMLDecorator getGraphMLDecorator(Result<?> result) {
        String graphMLDecorator = result.getRule().getReport().getProperties().getProperty(GRAPHML_DECORATOR);
        Class decoratorClass = graphMLDecorator != null ? this.classHelper.getType(graphMLDecorator) : this.defaultDecoratorClass;
        return (GraphMLDecorator)this.classHelper.createInstance(decoratorClass);
    }

    private void writeSubgraph(SubGraph graph, XMLStreamWriter writer, GraphMLDecorator decorator) throws XMLStreamException, IOException {
        Node parent = graph.getParent();
        if (parent != null) {
            this.writeNode(writer, decorator, parent, false);
        }
        writer.writeStartElement("graph");
        writer.writeAttribute("id", "G" + graph.hashCode());
        writer.writeAttribute("edgedefault", "directed");
        this.newLine(writer);
        for (Node node : graph.getNodes().values()) {
            this.writeNode(writer, decorator, node, true);
        }
        for (SubGraph subgraph : graph.getSubGraphs().values()) {
            this.writeSubgraph(subgraph, writer, decorator);
        }
        this.endElement(writer);
        if (parent != null) {
            writer.writeEndElement();
        }
    }

    private void writeKeyTypes(XMLStreamWriter writer, Collection<Node> allNodes, Collection<Relationship> allRelationships) throws IOException, XMLStreamException {
        HashMap<String, Class> keyTypes = new HashMap<String, Class>();
        keyTypes.put("labels", String.class);
        for (Node node : allNodes) {
            this.updateKeyTypes(keyTypes, (PropertyContainer)node);
        }
        this.writeKeyTypes(writer, keyTypes, "node");
        keyTypes.clear();
        for (Relationship rel : allRelationships) {
            this.updateKeyTypes(keyTypes, (PropertyContainer)rel);
        }
        this.writeKeyTypes(writer, keyTypes, "edge");
    }

    private void writeKeyTypes(XMLStreamWriter writer, Map<String, Class> keyTypes, String forType) throws IOException, XMLStreamException {
        for (Map.Entry<String, Class> entry : keyTypes.entrySet()) {
            String type = MetaInformation.typeFor(entry.getValue(), MetaInformation.GRAPHML_ALLOWED);
            if (type == null) continue;
            writer.writeEmptyElement("key");
            writer.writeAttribute("id", entry.getKey());
            writer.writeAttribute("for", forType);
            writer.writeAttribute("attr.name", entry.getKey());
            writer.writeAttribute("attr.type", type);
            this.newLine(writer);
        }
    }

    private void updateKeyTypes(Map<String, Class> keyTypes, PropertyContainer pc) {
        for (Map.Entry entry : pc.getProperties().entrySet()) {
            String prop = (String)entry.getKey();
            Object value = entry.getValue();
            Class storedClass = keyTypes.get(prop);
            if (storedClass == null) {
                keyTypes.put(prop, value.getClass());
                continue;
            }
            if (storedClass == Void.TYPE || storedClass.equals(value.getClass())) continue;
            keyTypes.put(prop, Void.TYPE);
        }
    }

    private void writeNode(XMLStreamWriter writer, GraphMLDecorator decorator, Node node, boolean withEnd) throws IOException, XMLStreamException {
        if (decorator.isWriteNode(node)) {
            writer.writeStartElement("node");
            writer.writeAttribute("id", this.id(node));
            decorator.writeNodeAttributes(node);
            this.writeLabels(writer, node);
            this.writeLabelsAsData(writer, node);
            decorator.writeNodeElements(node);
            this.writeProps(writer, (PropertyContainer)node);
            if (withEnd) {
                this.endElement(writer);
            }
        }
    }

    private String id(Node node) {
        return "n" + node.getId();
    }

    private void writeLabels(XMLStreamWriter writer, Node node) throws IOException, XMLStreamException {
        String labelsString = MetaInformation.getLabelsString(node);
        if (!labelsString.isEmpty()) {
            writer.writeAttribute("labels", labelsString);
        }
    }

    private void writeLabelsAsData(XMLStreamWriter writer, Node node) throws IOException, XMLStreamException {
        String labelsString = MetaInformation.getLabelsString(node);
        if (labelsString.isEmpty()) {
            return;
        }
        this.writeData(writer, "labels", labelsString);
    }

    private void writeRelationship(XMLStreamWriter writer, GraphMLDecorator decorator, Relationship relationship) throws IOException, XMLStreamException {
        if (decorator.isWriteRelationship(relationship)) {
            writer.writeStartElement("edge");
            writer.writeAttribute("id", this.id(relationship));
            writer.writeAttribute("source", this.id(relationship.getStartNode()));
            writer.writeAttribute("target", this.id(relationship.getEndNode()));
            writer.writeAttribute("label", relationship.getType());
            decorator.writeRelationshipAttributes(relationship);
            this.writeData(writer, "label", relationship.getType());
            decorator.writeRelationshipElements(relationship);
            this.writeProps(writer, (PropertyContainer)relationship);
            this.endElement(writer);
        }
    }

    private String id(Relationship rel) {
        return "e" + rel.getId();
    }

    private void endElement(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEndElement();
        this.newLine(writer);
    }

    private void writeProps(XMLStreamWriter writer, PropertyContainer node) throws IOException, XMLStreamException {
        for (Map.Entry entry : node.getProperties().entrySet()) {
            this.writeData(writer, (String)entry.getKey(), entry.getValue());
        }
    }

    private void writeData(XMLStreamWriter writer, String prop, Object value) throws IOException, XMLStreamException {
        writer.writeStartElement("data");
        writer.writeAttribute("key", prop);
        if (value != null) {
            writer.writeCharacters(value.toString());
        }
        writer.writeEndElement();
    }

    private void writeFooter(XMLStreamWriter writer) throws IOException, XMLStreamException {
        this.endElement(writer);
        writer.writeEndDocument();
    }

    private void writeHeader(XMLStreamWriter writer, GraphMLNamespaceContext context) throws IOException, XMLStreamException {
        writer.writeStartDocument("UTF-8", "1.0");
        this.newLine(writer);
        writer.writeStartElement("graphml");
        writer.writeNamespace("xmlns", "http://graphml.graphdrawing.org/xmlns");
        for (Map.Entry<String, String> entry : context.getNamespaces().entrySet()) {
            writer.writeAttribute("xmlns", "http://graphml.graphdrawing.org/xmlns", entry.getKey(), entry.getValue());
        }
        if (!context.getSchemaLocations().isEmpty()) {
            StringBuilder schemaLocations = new StringBuilder();
            for (Map.Entry<String, String> entry : context.getSchemaLocations().entrySet()) {
                schemaLocations.append(entry.getKey()).append(" ").append(entry.getValue());
            }
            writer.writeAttribute("xsi", "", "schemaLocation", schemaLocations.toString());
        }
        this.newLine(writer);
    }

    private void newLine(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeCharacters("\n");
    }

    private Collection<Node> getAllNodes(SubGraph graph) {
        LinkedHashMap<Long, Node> allNodes = new LinkedHashMap<Long, Node>();
        Node parentNode = graph.getParent();
        if (parentNode != null) {
            allNodes.put(parentNode.getId(), parentNode);
        }
        allNodes.putAll(graph.getNodes());
        for (SubGraph subgraph : graph.getSubGraphs().values()) {
            allNodes.putAll(subgraph.getNodes());
        }
        return allNodes.values();
    }

    private Collection<Relationship> getAllRelationships(SubGraph graph) {
        LinkedHashMap allRels = new LinkedHashMap();
        allRels.putAll(graph.getRelationships());
        for (SubGraph subgraph : graph.getSubGraphs().values()) {
            allRels.putAll(subgraph.getRelationships());
        }
        return allRels.values();
    }
}

