/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.maven3.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.ArrayValueDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.ArtifactDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.BaseDependencyDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.PropertyDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.ValueDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.ArtifactResolver;
import com.buschmais.jqassistant.plugin.maven3.api.model.BaseProfileDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.ConfigurableDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenActivationFileDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenActivationOSDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenArtifactDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenConfigurationDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenContributorDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenDependentDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenDeveloperDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenExecutionGoalDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenLicenseDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenModuleDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenOrganizationDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenParticipantRoleDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenPluginDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenPluginExecutionDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenPomDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenProfileActivationDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenProfileDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenProjectParticipantDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenRepositoryDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.PluginDependsOnDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.PomDependsOnDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.PomManagesDependencyDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.ProfileDependsOnDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.ProfileManagesDependencyDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.MavenRepositoryResolver;
import com.buschmais.jqassistant.plugin.maven3.impl.scanner.artifact.DependencyCoordinates;
import com.buschmais.jqassistant.plugin.maven3.impl.scanner.artifact.MavenArtifactResolver;
import com.buschmais.jqassistant.plugin.maven3.impl.scanner.artifact.ModelCoordinates;
import com.buschmais.jqassistant.plugin.maven3.impl.scanner.artifact.ParentCoordinates;
import com.buschmais.jqassistant.plugin.maven3.impl.scanner.artifact.PluginCoordinates;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Developer;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class MavenModelScannerPlugin
extends AbstractScannerPlugin<Model, MavenPomDescriptor> {
    private ArtifactResolver defaultArtifactResolver;

    public void initialize() {
        this.defaultArtifactResolver = new MavenArtifactResolver();
    }

    public Class<? extends Model> getType() {
        return Model.class;
    }

    public Class<MavenPomDescriptor> getDescriptorType() {
        return MavenPomDescriptor.class;
    }

    public boolean accepts(Model item, String path, Scope scope) throws IOException {
        return true;
    }

    public MavenPomDescriptor scan(Model model, String path, Scope scope, Scanner scanner) throws IOException {
        MavenPomDescriptor pomDescriptor = this.createMavenPomDescriptor(model, scanner);
        ScannerContext scannerContext = scanner.getContext();
        Store store = scannerContext.getStore();
        this.addParent(pomDescriptor, model, scannerContext);
        this.addProfiles(pomDescriptor, model, scannerContext);
        this.addProperties(pomDescriptor, model.getProperties(), store);
        this.addModules(pomDescriptor, model.getModules(), store);
        this.addManagedDependencies(pomDescriptor, model.getDependencyManagement(), scannerContext, PomManagesDependencyDescriptor.class);
        this.addDependencies(pomDescriptor, model.getDependencies(), PomDependsOnDescriptor.class, scannerContext);
        this.addManagedPlugins(pomDescriptor, (BuildBase)model.getBuild(), scannerContext);
        this.addPlugins(pomDescriptor, (BuildBase)model.getBuild(), scannerContext);
        this.addLicenses(pomDescriptor, model, store);
        this.addDevelopers(pomDescriptor, model, store);
        this.addContributors(pomDescriptor, model, store);
        this.addOrganization(pomDescriptor, model, store);
        this.addRepository(MavenModelScannerPlugin.of(pomDescriptor), model.getRepositories(), store);
        return pomDescriptor;
    }

    private void addOrganization(MavenPomDescriptor pomDescriptor, Model model, Store store) {
        Organization mavenOrganization = model.getOrganization();
        if (null != mavenOrganization) {
            MavenOrganizationDescriptor organization = (MavenOrganizationDescriptor)store.create(MavenOrganizationDescriptor.class);
            organization.setName(mavenOrganization.getName());
            organization.setUrl(mavenOrganization.getUrl());
            pomDescriptor.setOrganization(organization);
        }
    }

    private void addContributors(MavenPomDescriptor pomDescriptor, Model model, Store store) {
        List contributors = model.getContributors();
        for (Contributor contributor : contributors) {
            MavenContributorDescriptor contributorDescriptor = (MavenContributorDescriptor)store.create(MavenContributorDescriptor.class);
            this.addCommonParticipantAttributes(contributorDescriptor, contributor, store);
            pomDescriptor.getContributors().add(contributorDescriptor);
        }
    }

    private void addCommonParticipantAttributes(MavenProjectParticipantDescriptor participant, Contributor contributor, Store store) {
        participant.setName(contributor.getName());
        participant.setEmail(contributor.getEmail());
        participant.setUrl(contributor.getUrl());
        participant.setOrganization(contributor.getOrganization());
        participant.setOrganizationUrl(contributor.getOrganizationUrl());
        participant.setTimezone(contributor.getTimezone());
        if (contributor.getRoles() != null) {
            for (String role : contributor.getRoles()) {
                MavenParticipantRoleDescriptor developerRoleDescriptor = (MavenParticipantRoleDescriptor)store.create(MavenParticipantRoleDescriptor.class);
                developerRoleDescriptor.setName(role);
                participant.getRoles().add(developerRoleDescriptor);
            }
        }
    }

    protected MavenPomDescriptor createMavenPomDescriptor(Model model, Scanner scanner) {
        ScannerContext context = scanner.getContext();
        MavenPomDescriptor pomDescriptor = (MavenPomDescriptor)context.peek(MavenPomDescriptor.class);
        pomDescriptor.setName(model.getName());
        pomDescriptor.setGroupId(model.getGroupId());
        pomDescriptor.setArtifactId(model.getArtifactId());
        pomDescriptor.setPackaging(model.getPackaging());
        pomDescriptor.setVersion(model.getVersion());
        String pomFqn = this.getFullyQualifiedName(model);
        pomDescriptor.setFullQualifiedName(pomFqn);
        ModelCoordinates artifactCoordinates = new ModelCoordinates(model);
        MavenArtifactDescriptor artifact = this.getArtifactResolver(context).resolve(artifactCoordinates, context);
        if (MavenPomDescriptor.class.isAssignableFrom(artifact.getClass())) {
            pomDescriptor = (MavenPomDescriptor)MavenPomDescriptor.class.cast(artifact);
        }
        pomDescriptor.getDescribes().add((ArtifactDescriptor)artifact);
        return pomDescriptor;
    }

    private String getFullyQualifiedName(Model model) {
        StringBuilder id = new StringBuilder();
        id.append(model.getGroupId() == null ? "[inherited]" : model.getGroupId());
        id.append(":");
        id.append(model.getArtifactId());
        id.append(":pom:");
        id.append(model.getVersion() == null ? "[inherited]" : model.getVersion());
        return id.toString();
    }

    private void addActivation(MavenProfileDescriptor mavenProfileDescriptor, Activation activation, Store store) {
        ActivationProperty property;
        ActivationOS os;
        if (null == activation) {
            return;
        }
        MavenProfileActivationDescriptor profileActivationDescriptor = (MavenProfileActivationDescriptor)store.create(MavenProfileActivationDescriptor.class);
        mavenProfileDescriptor.setActivation(profileActivationDescriptor);
        profileActivationDescriptor.setJdk(activation.getJdk());
        profileActivationDescriptor.setActiveByDefault(activation.isActiveByDefault());
        ActivationFile activationFile = activation.getFile();
        if (null != activationFile) {
            MavenActivationFileDescriptor activationFileDescriptor = (MavenActivationFileDescriptor)store.create(MavenActivationFileDescriptor.class);
            profileActivationDescriptor.setActivationFile(activationFileDescriptor);
            activationFileDescriptor.setExists(activationFile.getExists());
            activationFileDescriptor.setMissing(activationFile.getMissing());
        }
        if (null != (os = activation.getOs())) {
            MavenActivationOSDescriptor osDescriptor = (MavenActivationOSDescriptor)store.create(MavenActivationOSDescriptor.class);
            profileActivationDescriptor.setActivationOS(osDescriptor);
            osDescriptor.setArch(os.getArch());
            osDescriptor.setFamily(os.getFamily());
            osDescriptor.setName(os.getName());
            osDescriptor.setVersion(os.getVersion());
        }
        if (null != (property = activation.getProperty())) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)store.create(PropertyDescriptor.class);
            profileActivationDescriptor.setProperty(propertyDescriptor);
            propertyDescriptor.setName(property.getName());
            propertyDescriptor.setValue(property.getValue());
        }
    }

    private void addConfiguration(ConfigurableDescriptor configurableDescriptor, Xpp3Dom config, Store store) {
        Xpp3Dom[] children;
        if (null == config) {
            return;
        }
        MavenConfigurationDescriptor configDescriptor = (MavenConfigurationDescriptor)store.create(MavenConfigurationDescriptor.class);
        configurableDescriptor.setConfiguration(configDescriptor);
        for (Xpp3Dom child : children = config.getChildren()) {
            configDescriptor.getValues().add(this.getConfigChildNodes(child, store));
        }
    }

    private <P extends MavenDependentDescriptor, D extends BaseDependencyDescriptor> void addDependencies(P dependent, List<Dependency> dependencies, Class<D> dependencyType, ScannerContext scannerContext) {
        for (Dependency dependency : dependencies) {
            MavenArtifactDescriptor dependencyArtifactDescriptor = this.getMavenArtifactDescriptor(dependency, scannerContext);
            BaseDependencyDescriptor dependencyDescriptor = (BaseDependencyDescriptor)scannerContext.getStore().create(dependent, dependencyType, (Descriptor)dependencyArtifactDescriptor);
            dependencyDescriptor.setOptional(dependency.isOptional());
            dependencyDescriptor.setScope(dependency.getScope());
        }
    }

    private void addExecutionGoals(MavenPluginExecutionDescriptor executionDescriptor, PluginExecution pluginExecution, Store store) {
        List goals = pluginExecution.getGoals();
        for (String goal : goals) {
            MavenExecutionGoalDescriptor goalDescriptor = (MavenExecutionGoalDescriptor)store.create(MavenExecutionGoalDescriptor.class);
            goalDescriptor.setName(goal);
            executionDescriptor.getGoals().add(goalDescriptor);
        }
    }

    private void addLicenses(MavenPomDescriptor pomDescriptor, Model model, Store store) {
        List licenses = model.getLicenses();
        for (License license : licenses) {
            MavenLicenseDescriptor licenseDescriptor = (MavenLicenseDescriptor)store.create(MavenLicenseDescriptor.class);
            licenseDescriptor.setUrl(license.getUrl());
            licenseDescriptor.setComments(license.getComments());
            licenseDescriptor.setName(license.getName());
            licenseDescriptor.setDistribution(license.getDistribution());
            pomDescriptor.getLicenses().add(licenseDescriptor);
        }
    }

    private void addDevelopers(MavenPomDescriptor pomDescriptor, Model model, Store store) {
        List developers = model.getDevelopers();
        for (Developer developer : developers) {
            MavenDeveloperDescriptor developerDescriptor = (MavenDeveloperDescriptor)store.create(MavenDeveloperDescriptor.class);
            developerDescriptor.setId(developer.getId());
            this.addCommonParticipantAttributes(developerDescriptor, (Contributor)developer, store);
            pomDescriptor.getDevelopers().add(developerDescriptor);
        }
    }

    private void addManagedDependencies(MavenDependentDescriptor pomDescriptor, DependencyManagement dependencyManagement, ScannerContext scannerContext, Class<? extends BaseDependencyDescriptor> relationClass) {
        if (null == dependencyManagement) {
            return;
        }
        List dependencies = dependencyManagement.getDependencies();
        this.addDependencies(pomDescriptor, dependencies, relationClass, scannerContext);
    }

    private void addManagedPlugins(BaseProfileDescriptor pomDescriptor, BuildBase build, ScannerContext scannerContext) {
        if (null == build) {
            return;
        }
        PluginManagement pluginManagement = build.getPluginManagement();
        if (null == pluginManagement) {
            return;
        }
        List<MavenPluginDescriptor> pluginDescriptors = this.createMavenPluginDescriptors(pluginManagement.getPlugins(), scannerContext);
        pomDescriptor.getManagedPlugins().addAll(pluginDescriptors);
    }

    private List<MavenPluginDescriptor> createMavenPluginDescriptors(List<Plugin> plugins, ScannerContext context) {
        Store store = context.getStore();
        ArrayList<MavenPluginDescriptor> pluginDescriptors = new ArrayList<MavenPluginDescriptor>();
        for (Plugin plugin : plugins) {
            MavenPluginDescriptor mavenPluginDescriptor = (MavenPluginDescriptor)store.create(MavenPluginDescriptor.class);
            MavenArtifactDescriptor artifactDescriptor = this.getArtifactResolver(context).resolve(new PluginCoordinates(plugin), context);
            mavenPluginDescriptor.setArtifact(artifactDescriptor);
            mavenPluginDescriptor.setInherited(plugin.isInherited());
            this.addDependencies(mavenPluginDescriptor, plugin.getDependencies(), PluginDependsOnDescriptor.class, context);
            this.addPluginExecutions(mavenPluginDescriptor, plugin, store);
            this.addConfiguration(mavenPluginDescriptor, (Xpp3Dom)plugin.getConfiguration(), store);
            pluginDescriptors.add(mavenPluginDescriptor);
        }
        return pluginDescriptors;
    }

    private ArtifactResolver getArtifactResolver(ScannerContext context) {
        return (ArtifactResolver)context.peekOrDefault(ArtifactResolver.class, (Object)this.defaultArtifactResolver);
    }

    private void addModules(BaseProfileDescriptor pomDescriptor, List<String> modules, Store store) {
        for (String module : modules) {
            MavenModuleDescriptor moduleDescriptor = (MavenModuleDescriptor)store.create(MavenModuleDescriptor.class);
            moduleDescriptor.setName(module);
            pomDescriptor.getModules().add(moduleDescriptor);
        }
    }

    private void addParent(MavenPomDescriptor pomDescriptor, Model model, ScannerContext context) {
        Parent parent = model.getParent();
        if (null != parent) {
            ArtifactResolver resolver = this.getArtifactResolver(context);
            MavenArtifactDescriptor parentDescriptor = resolver.resolve(new ParentCoordinates(parent), context);
            pomDescriptor.setParent((ArtifactDescriptor)parentDescriptor);
        }
    }

    private void addPluginExecutions(MavenPluginDescriptor mavenPluginDescriptor, Plugin plugin, Store store) {
        List executions = plugin.getExecutions();
        for (PluginExecution pluginExecution : executions) {
            MavenPluginExecutionDescriptor executionDescriptor = (MavenPluginExecutionDescriptor)store.create(MavenPluginExecutionDescriptor.class);
            executionDescriptor.setId(pluginExecution.getId());
            executionDescriptor.setPhase(pluginExecution.getPhase());
            executionDescriptor.setInherited(pluginExecution.isInherited());
            mavenPluginDescriptor.getExecutions().add(executionDescriptor);
            this.addExecutionGoals(executionDescriptor, pluginExecution, store);
            this.addConfiguration(executionDescriptor, (Xpp3Dom)pluginExecution.getConfiguration(), store);
        }
    }

    private void addPlugins(BaseProfileDescriptor pomDescriptor, BuildBase build, ScannerContext scannerContext) {
        if (null == build) {
            return;
        }
        List plugins = build.getPlugins();
        List<MavenPluginDescriptor> pluginDescriptors = this.createMavenPluginDescriptors(plugins, scannerContext);
        pomDescriptor.getPlugins().addAll(pluginDescriptors);
    }

    private void addProfileDependencies(MavenProfileDescriptor profileDescriptor, List<Dependency> dependencies, ScannerContext scannerContext) {
        for (Dependency dependency : dependencies) {
            MavenArtifactDescriptor dependencyArtifactDescriptor = this.getMavenArtifactDescriptor(dependency, scannerContext);
            Store store = scannerContext.getStore();
            ProfileDependsOnDescriptor profileDependsOnDescriptor = (ProfileDependsOnDescriptor)store.create((Descriptor)profileDescriptor, ProfileDependsOnDescriptor.class, (Descriptor)dependencyArtifactDescriptor);
            profileDependsOnDescriptor.setOptional(dependency.isOptional());
            profileDependsOnDescriptor.setScope(dependency.getScope());
        }
    }

    private void addProfiles(MavenPomDescriptor pomDescriptor, Model model, ScannerContext scannerContext) {
        List profiles = model.getProfiles();
        Store store = scannerContext.getStore();
        for (Profile profile : profiles) {
            MavenProfileDescriptor mavenProfileDescriptor = (MavenProfileDescriptor)store.create(MavenProfileDescriptor.class);
            pomDescriptor.getProfiles().add(mavenProfileDescriptor);
            mavenProfileDescriptor.setId(profile.getId());
            this.addProperties(mavenProfileDescriptor, profile.getProperties(), store);
            this.addModules(mavenProfileDescriptor, profile.getModules(), store);
            this.addPlugins(mavenProfileDescriptor, profile.getBuild(), scannerContext);
            this.addManagedPlugins(mavenProfileDescriptor, profile.getBuild(), scannerContext);
            this.addManagedDependencies(mavenProfileDescriptor, profile.getDependencyManagement(), scannerContext, ProfileManagesDependencyDescriptor.class);
            this.addProfileDependencies(mavenProfileDescriptor, profile.getDependencies(), scannerContext);
            this.addActivation(mavenProfileDescriptor, profile.getActivation(), store);
            this.addRepository(MavenModelScannerPlugin.of(mavenProfileDescriptor), profile.getRepositories(), store);
        }
    }

    private void addRepository(RepositoryHolder holder, List<Repository> repositories, Store store) {
        for (Repository repo : repositories) {
            MavenRepositoryDescriptor repoDescriptor = MavenRepositoryResolver.resolve(store, repo.getUrl());
            repoDescriptor.setName(repo.getName());
            repoDescriptor.setId(repo.getId());
            repoDescriptor.setLayout(repo.getLayout() != null ? repo.getLayout() : "default");
            WrappedPolicy relPolicy = new WrappedPolicy(repo.getReleases());
            WrappedPolicy snapPolicy = new WrappedPolicy(repo.getSnapshots());
            repoDescriptor.setReleasesChecksumPolicy(relPolicy.getChecksumPolicy());
            repoDescriptor.setReleasesUpdatePolicy(relPolicy.getUpdatePolicy());
            repoDescriptor.setReleasesEnabled(relPolicy.isEnabled());
            repoDescriptor.setSnapshotsChecksumPolicy(snapPolicy.getChecksumPolicy());
            repoDescriptor.setSnapshotsUpdatePolicy(snapPolicy.getUpdatePolicy());
            repoDescriptor.setSnapshotsEnabled(snapPolicy.isEnabled());
            holder.getRepositories().add(repoDescriptor);
        }
    }

    private void addProperties(BaseProfileDescriptor pomDescriptor, Properties properties, Store store) {
        Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)store.create(PropertyDescriptor.class);
            propertyDescriptor.setName(entry.getKey().toString());
            propertyDescriptor.setValue(entry.getValue().toString());
            pomDescriptor.getProperties().add(propertyDescriptor);
        }
    }

    private MavenArtifactDescriptor getMavenArtifactDescriptor(Dependency dependency, ScannerContext context) {
        DependencyCoordinates coordinates = new DependencyCoordinates(dependency);
        return this.getArtifactResolver(context).resolve(coordinates, context);
    }

    private ValueDescriptor<?> getConfigChildNodes(Xpp3Dom node, Store store) {
        Xpp3Dom[] children = node.getChildren();
        if (children.length == 0) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)store.create(PropertyDescriptor.class);
            propertyDescriptor.setName(node.getName());
            propertyDescriptor.setValue(node.getValue());
            return propertyDescriptor;
        }
        ArrayValueDescriptor childDescriptor = (ArrayValueDescriptor)store.create(ArrayValueDescriptor.class);
        childDescriptor.setName(node.getName());
        for (Xpp3Dom child : children) {
            childDescriptor.getValue().add(this.getConfigChildNodes(child, store));
        }
        return childDescriptor;
    }

    private static RepositoryHolder of(final MavenProfileDescriptor profileDescriptor) {
        return new RepositoryHolder(){

            @Override
            public List<MavenRepositoryDescriptor> getRepositories() {
                return profileDescriptor.getRepositories();
            }
        };
    }

    private static RepositoryHolder of(final MavenPomDescriptor pomDescriptor) {
        return new RepositoryHolder(){

            @Override
            public List<MavenRepositoryDescriptor> getRepositories() {
                return pomDescriptor.getRepositories();
            }
        };
    }

    static class WrappedPolicy {
        RepositoryPolicy original;

        private WrappedPolicy(RepositoryPolicy policy) {
            this.original = policy;
        }

        public String getChecksumPolicy() {
            if (this.original != null) {
                return (String)MoreObjects.firstNonNull((Object)this.original.getChecksumPolicy(), (Object)"warn");
            }
            return "warn";
        }

        public String getUpdatePolicy() {
            if (this.original != null) {
                return (String)MoreObjects.firstNonNull((Object)this.original.getUpdatePolicy(), (Object)"daily");
            }
            return "daily";
        }

        public boolean isEnabled() {
            boolean result = true;
            if (this.original != null) {
                result = (Boolean)MoreObjects.firstNonNull((Object)this.original.isEnabled(), (Object)true);
            }
            return result;
        }
    }

    protected static interface RepositoryHolder {
        public List<MavenRepositoryDescriptor> getRepositories();
    }
}

