/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.maven3.impl.scanner.artifact;

import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.ArtifactResolver;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.Coordinates;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.MavenArtifactHelper;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenArtifactDescriptor;
import com.buschmais.xo.api.Query;
import java.util.HashMap;

public class MavenArtifactResolver
implements ArtifactResolver {
    @Override
    public MavenArtifactDescriptor resolve(Coordinates coordinates, ScannerContext scannerContext) {
        MavenArtifactDescriptor artifactDescriptor = this.find(coordinates, scannerContext);
        if (artifactDescriptor == null) {
            artifactDescriptor = this.createArtifactDescriptor(coordinates, scannerContext);
        }
        return artifactDescriptor;
    }

    private MavenArtifactDescriptor find(Coordinates coordinates, ScannerContext scannerContext) {
        String id = MavenArtifactHelper.getId(coordinates);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fqn", id);
        Query.Result result = scannerContext.getStore().executeQuery("MATCH (a:Maven:Artifact:File) WHERE a.fqn={fqn} RETURN a", params);
        return result.hasResult() ? (MavenArtifactDescriptor)((Query.Result.CompositeRowObject)result.getSingleResult()).get("a", MavenArtifactDescriptor.class) : null;
    }

    private MavenArtifactDescriptor createArtifactDescriptor(Coordinates coordinates, ScannerContext scannerContext) {
        String id = MavenArtifactHelper.getId(coordinates);
        MavenArtifactDescriptor artifactDescriptor = (MavenArtifactDescriptor)scannerContext.getStore().create(MavenArtifactDescriptor.class, id);
        MavenArtifactHelper.setCoordinates(artifactDescriptor, coordinates);
        return artifactDescriptor;
    }
}

