/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.internal;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Params {
    private Map<String, Object> m = new HashMap<String, Object>();

    public void add(String paramName, Object value) {
        if (value == null) {
            throw new RuntimeException("The param {" + paramName + "} cannot be null");
        }
        this.m.put(paramName, Params.toValStr(value));
    }

    public void addOpt(String paramName, Object value) {
        this.m.put(paramName, value != null ? Params.toValStr(value) : "");
    }

    public int size() {
        return this.m.size();
    }

    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    public Set<String> keys() {
        return this.m.keySet();
    }

    public Set<Map.Entry<String, Object>> entries() {
        return this.m.entrySet();
    }

    private static Object toValStr(Object value) {
        Class<?> c = value.getClass();
        if (c == String.class || c == Integer.class || c == Long.class || c == Boolean.class || c == Double.class) {
            return value.toString();
        }
        if (c.isEnum()) {
            return value.toString().toLowerCase();
        }
        if (c == Timestamp.class) {
            return Params.asUnixTimestamp((Timestamp)value);
        }
        if (value instanceof List) {
            List origList = (List)value;
            ArrayList<String> l = new ArrayList<String>(origList.size());
            for (Object item : origList) {
                l.add((String)Params.toValStr(item));
            }
            return l;
        }
        if (value instanceof Object[]) {
            Object[] origList = (Object[])value;
            ArrayList<String> l = new ArrayList<String>(origList.length);
            for (Object item : origList) {
                l.add((String)Params.toValStr(item));
            }
            return l;
        }
        throw new RuntimeException("Type [" + c.getName() + "] not handled");
    }

    private static String asUnixTimestamp(Timestamp ts) {
        return String.valueOf(ts.getTime() / 1000L);
    }

    public String toString() {
        return this.m.toString();
    }
}

