/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.enums.Gateway;
import com.chargebee.org.json.JSONObject;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Card
extends Resource<Card> {
    public Card(String jsonStr) {
        super(jsonStr);
    }

    public Card(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String customerId() {
        return this.reqString("customer_id");
    }

    public Status status() {
        return this.reqEnum("status", Status.class);
    }

    public Gateway gateway() {
        return this.reqEnum("gateway", Gateway.class);
    }

    public String firstName() {
        return this.optString("first_name");
    }

    public String lastName() {
        return this.optString("last_name");
    }

    public String iin() {
        return this.reqString("iin");
    }

    public String last4() {
        return this.reqString("last4");
    }

    public CardType cardType() {
        return this.optEnum("card_type", CardType.class);
    }

    public Integer expiryMonth() {
        return this.reqInteger("expiry_month");
    }

    public Integer expiryYear() {
        return this.reqInteger("expiry_year");
    }

    public String billingAddr1() {
        return this.optString("billing_addr1");
    }

    public String billingAddr2() {
        return this.optString("billing_addr2");
    }

    public String billingCity() {
        return this.optString("billing_city");
    }

    public String billingStateCode() {
        return this.optString("billing_state_code");
    }

    public String billingState() {
        return this.optString("billing_state");
    }

    public String billingCountry() {
        return this.optString("billing_country");
    }

    public String billingZip() {
        return this.optString("billing_zip");
    }

    public String ipAddress() {
        return this.optString("ip_address");
    }

    public String maskedNumber() {
        return this.optString("masked_number");
    }

    public static Request retrieve(String id) throws IOException {
        String uri = Card.uri("cards", Card.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static UpdateCardForCustomerRequest updateCardForCustomer(String id) throws IOException {
        String uri = Card.uri("customers", Card.nullCheck(id), "credit_card");
        return new UpdateCardForCustomerRequest(HttpUtil.Method.POST, uri);
    }

    public static Request deleteCardForCustomer(String id) throws IOException {
        String uri = Card.uri("customers", Card.nullCheck(id), "delete_card");
        return new Request(HttpUtil.Method.POST, uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdateCardForCustomerRequest
    extends Request<UpdateCardForCustomerRequest> {
        private UpdateCardForCustomerRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateCardForCustomerRequest gateway(Gateway gateway) {
            this.params.addOpt("gateway", (Object)gateway);
            return this;
        }

        public UpdateCardForCustomerRequest tmpToken(String tmpToken) {
            this.params.addOpt("tmp_token", tmpToken);
            return this;
        }

        public UpdateCardForCustomerRequest firstName(String firstName) {
            this.params.addOpt("first_name", firstName);
            return this;
        }

        public UpdateCardForCustomerRequest lastName(String lastName) {
            this.params.addOpt("last_name", lastName);
            return this;
        }

        public UpdateCardForCustomerRequest number(String number) {
            this.params.add("number", number);
            return this;
        }

        public UpdateCardForCustomerRequest expiryMonth(Integer expiryMonth) {
            this.params.add("expiry_month", expiryMonth);
            return this;
        }

        public UpdateCardForCustomerRequest expiryYear(Integer expiryYear) {
            this.params.add("expiry_year", expiryYear);
            return this;
        }

        public UpdateCardForCustomerRequest cvv(String cvv) {
            this.params.addOpt("cvv", cvv);
            return this;
        }

        public UpdateCardForCustomerRequest billingAddr1(String billingAddr1) {
            this.params.addOpt("billing_addr1", billingAddr1);
            return this;
        }

        public UpdateCardForCustomerRequest billingAddr2(String billingAddr2) {
            this.params.addOpt("billing_addr2", billingAddr2);
            return this;
        }

        public UpdateCardForCustomerRequest billingCity(String billingCity) {
            this.params.addOpt("billing_city", billingCity);
            return this;
        }

        public UpdateCardForCustomerRequest billingStateCode(String billingStateCode) {
            this.params.addOpt("billing_state_code", billingStateCode);
            return this;
        }

        public UpdateCardForCustomerRequest billingState(String billingState) {
            this.params.addOpt("billing_state", billingState);
            return this;
        }

        public UpdateCardForCustomerRequest billingZip(String billingZip) {
            this.params.addOpt("billing_zip", billingZip);
            return this;
        }

        public UpdateCardForCustomerRequest billingCountry(String billingCountry) {
            this.params.addOpt("billing_country", billingCountry);
            return this;
        }

        public UpdateCardForCustomerRequest ipAddress(String ipAddress) {
            this.params.addOpt("ip_address", ipAddress);
            return this;
        }

        @Deprecated
        public UpdateCardForCustomerRequest customerVatNumber(String customerVatNumber) {
            this.params.addOpt("customer[vat_number]", customerVatNumber);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CardType {
        VISA,
        MASTERCARD,
        AMERICAN_EXPRESS,
        DISCOVER,
        JCB,
        DINERS_CLUB,
        OTHER,
        NOT_APPLICABLE,
        _UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        VALID,
        EXPIRING,
        EXPIRED,
        _UNKNOWN;

    }
}

