/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.internal.ResultBase;
import com.chargebee.models.enums.EventType;
import com.chargebee.models.enums.Source;
import com.chargebee.org.json.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Event
extends Resource<Event> {
    public Event(InputStream is) throws IOException {
        super(is);
    }

    public Event(BufferedReader rd) throws IOException {
        super(rd);
    }

    public Event(String jsonStr) {
        super(jsonStr);
    }

    public Event(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public Timestamp occurredAt() {
        return this.reqTimestamp("occurred_at");
    }

    public Source source() {
        return this.reqEnum("source", Source.class);
    }

    public String user() {
        return this.optString("user");
    }

    @Deprecated
    public WebhookStatus webhookStatus() {
        return this.reqEnum("webhook_status", WebhookStatus.class);
    }

    @Deprecated
    public String webhookFailureReason() {
        return this.optString("webhook_failure_reason");
    }

    public List<Webhook> webhooks() {
        return this.optList("webhooks", Webhook.class);
    }

    public EventType eventType() {
        return this.optEnum("event_type", EventType.class);
    }

    public static EventListRequest list() throws IOException {
        String uri = Event.uri("events");
        return new EventListRequest(uri);
    }

    public static Request retrieve(String id) throws IOException {
        String uri = Event.uri("events", Event.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public Content content() {
        return new Content(this.optJSONObject("content"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EventListRequest
    extends ListRequest<EventListRequest> {
        private EventListRequest(String uri) {
            super(uri);
        }

        public EventListRequest limit(Integer limit) {
            this.params.addOpt("limit", limit);
            return this;
        }

        @Override
        public EventListRequest offset(String offset) {
            this.params.addOpt("offset", offset);
            return this;
        }

        public EventListRequest startTime(Timestamp startTime) {
            this.params.addOpt("start_time", startTime);
            return this;
        }

        public EventListRequest endTime(Timestamp endTime) {
            this.params.addOpt("end_time", endTime);
            return this;
        }

        public EventListRequest webhookStatus(WebhookStatus webhookStatus) {
            this.params.addOpt("webhook_status", (Object)webhookStatus);
            return this;
        }

        public EventListRequest eventType(EventType eventType) {
            this.params.addOpt("event_type", (Object)eventType);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class Content
    extends ResultBase {
        public Content(JSONObject jsonObj) {
            super(jsonObj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Webhook
    extends Resource<Webhook> {
        public Webhook(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String id() {
            return this.reqString("id");
        }

        public WebhookStatus webhookStatus() {
            return this.reqEnum("webhook_status", WebhookStatus.class);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum WebhookStatus {
            NOT_CONFIGURED,
            SCHEDULED,
            SUCCEEDED,
            RE_SCHEDULED,
            FAILED,
            SKIPPED,
            _UNKNOWN;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static enum WebhookStatus {
        NOT_CONFIGURED,
        SCHEDULED,
        SUCCEEDED,
        RE_SCHEDULED,
        FAILED,
        SKIPPED,
        NOT_APPLICABLE,
        _UNKNOWN;

    }
}

