/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.Transaction;
import com.chargebee.models.enums.PaymentMethod;
import com.chargebee.org.json.JSONObject;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invoice
extends Resource<Invoice> {
    public Invoice(String jsonStr) {
        super(jsonStr);
    }

    public Invoice(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String poNumber() {
        return this.optString("po_number");
    }

    public String customerId() {
        return this.reqString("customer_id");
    }

    public String subscriptionId() {
        return this.optString("subscription_id");
    }

    public Boolean recurring() {
        return this.reqBoolean("recurring");
    }

    public Status status() {
        return this.reqEnum("status", Status.class);
    }

    public String vatNumber() {
        return this.optString("vat_number");
    }

    public Timestamp startDate() {
        return this.reqTimestamp("start_date");
    }

    public Timestamp endDate() {
        return this.optTimestamp("end_date");
    }

    public Integer amount() {
        return this.optInteger("amount");
    }

    public Integer amountDue() {
        return this.optInteger("amount_due");
    }

    public Timestamp paidOn() {
        return this.optTimestamp("paid_on");
    }

    public DunningStatus dunningStatus() {
        return this.optEnum("dunning_status", DunningStatus.class);
    }

    public Timestamp nextRetry() {
        return this.optTimestamp("next_retry");
    }

    public Integer subTotal() {
        return this.reqInteger("sub_total");
    }

    public Integer tax() {
        return this.reqInteger("tax");
    }

    public Boolean firstInvoice() {
        return this.optBoolean("first_invoice");
    }

    public String currencyCode() {
        return this.optString("currency_code");
    }

    public List<LineItem> lineItems() {
        return this.optList("line_items", LineItem.class);
    }

    public List<Discount> discounts() {
        return this.optList("discounts", Discount.class);
    }

    public List<Tax> taxes() {
        return this.optList("taxes", Tax.class);
    }

    public List<LinkedTransaction> linkedTransactions() {
        return this.optList("linked_transactions", LinkedTransaction.class);
    }

    public List<LinkedOrder> linkedOrders() {
        return this.optList("linked_orders", LinkedOrder.class);
    }

    public List<Note> notes() {
        return this.optList("notes", Note.class);
    }

    public ShippingAddress shippingAddress() {
        return this.optSubResource("shipping_address", ShippingAddress.class);
    }

    public BillingAddress billingAddress() {
        return this.optSubResource("billing_address", BillingAddress.class);
    }

    public static CreateRequest create() throws IOException {
        String uri = Invoice.uri("invoices");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static ChargeRequest charge() throws IOException {
        String uri = Invoice.uri("invoices", "charge");
        return new ChargeRequest(HttpUtil.Method.POST, uri);
    }

    public static ChargeAddonRequest chargeAddon() throws IOException {
        String uri = Invoice.uri("invoices", "charge_addon");
        return new ChargeAddonRequest(HttpUtil.Method.POST, uri);
    }

    public static Request stopDunning(String id) throws IOException {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "stop_dunning");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static InvoiceListRequest list() throws IOException {
        String uri = Invoice.uri("invoices");
        return new InvoiceListRequest(uri);
    }

    public static ListRequest invoicesForCustomer(String id) throws IOException {
        String uri = Invoice.uri("customers", Invoice.nullCheck(id), "invoices");
        return new ListRequest(uri);
    }

    public static ListRequest invoicesForSubscription(String id) throws IOException {
        String uri = Invoice.uri("subscriptions", Invoice.nullCheck(id), "invoices");
        return new ListRequest(uri);
    }

    public static Request retrieve(String id) throws IOException {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static Request pdf(String id) throws IOException {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "pdf");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static AddChargeRequest addCharge(String id) throws IOException {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "add_charge");
        return new AddChargeRequest(HttpUtil.Method.POST, uri);
    }

    public static AddAddonChargeRequest addAddonCharge(String id) throws IOException {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "add_addon_charge");
        return new AddAddonChargeRequest(HttpUtil.Method.POST, uri);
    }

    public static Request collect(String id) throws IOException {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "collect");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static Request collectPayment(String id) throws IOException {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "collect_payment");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static RefundRequest refund(String id) throws IOException {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "refund");
        return new RefundRequest(HttpUtil.Method.POST, uri);
    }

    public static RecordRefundRequest recordRefund(String id) throws IOException {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "record_refund");
        return new RecordRefundRequest(HttpUtil.Method.POST, uri);
    }

    public static VoidInvoiceRequest voidInvoice(String id) throws IOException {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "void");
        return new VoidInvoiceRequest(HttpUtil.Method.POST, uri);
    }

    public static DeleteRequest delete(String id) throws IOException {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "delete");
        return new DeleteRequest(HttpUtil.Method.POST, uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteRequest
    extends Request<DeleteRequest> {
        private DeleteRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public DeleteRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VoidInvoiceRequest
    extends Request<VoidInvoiceRequest> {
        private VoidInvoiceRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public VoidInvoiceRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RecordRefundRequest
    extends Request<RecordRefundRequest> {
        private RecordRefundRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RecordRefundRequest memo(String memo) {
            this.params.add("memo", memo);
            return this;
        }

        public RecordRefundRequest transactionAmount(Integer transactionAmount) {
            this.params.addOpt("transaction[amount]", transactionAmount);
            return this;
        }

        public RecordRefundRequest transactionPaymentMethod(PaymentMethod transactionPaymentMethod) {
            this.params.add("transaction[payment_method]", (Object)transactionPaymentMethod);
            return this;
        }

        public RecordRefundRequest transactionReferenceNumber(String transactionReferenceNumber) {
            this.params.addOpt("transaction[reference_number]", transactionReferenceNumber);
            return this;
        }

        public RecordRefundRequest transactionDate(Timestamp transactionDate) {
            this.params.add("transaction[date]", transactionDate);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RefundRequest
    extends Request<RefundRequest> {
        private RefundRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RefundRequest refundAmount(Integer refundAmount) {
            this.params.addOpt("refund_amount", refundAmount);
            return this;
        }

        public RefundRequest memo(String memo) {
            this.params.addOpt("memo", memo);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddAddonChargeRequest
    extends Request<AddAddonChargeRequest> {
        private AddAddonChargeRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public AddAddonChargeRequest addonId(String addonId) {
            this.params.add("addon_id", addonId);
            return this;
        }

        public AddAddonChargeRequest addonQuantity(Integer addonQuantity) {
            this.params.addOpt("addon_quantity", addonQuantity);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddChargeRequest
    extends Request<AddChargeRequest> {
        private AddChargeRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public AddChargeRequest amount(Integer amount) {
            this.params.add("amount", amount);
            return this;
        }

        public AddChargeRequest description(String description) {
            this.params.add("description", description);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InvoiceListRequest
    extends ListRequest<InvoiceListRequest> {
        private InvoiceListRequest(String uri) {
            super(uri);
        }

        public InvoiceListRequest limit(Integer limit) {
            this.params.addOpt("limit", limit);
            return this;
        }

        @Override
        public InvoiceListRequest offset(String offset) {
            this.params.addOpt("offset", offset);
            return this;
        }

        public InvoiceListRequest paidOnAfter(Timestamp paidOnAfter) {
            this.params.addOpt("paid_on_after", paidOnAfter);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChargeAddonRequest
    extends Request<ChargeAddonRequest> {
        private ChargeAddonRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ChargeAddonRequest customerId(String customerId) {
            this.params.addOpt("customer_id", customerId);
            return this;
        }

        public ChargeAddonRequest subscriptionId(String subscriptionId) {
            this.params.addOpt("subscription_id", subscriptionId);
            return this;
        }

        public ChargeAddonRequest addonId(String addonId) {
            this.params.add("addon_id", addonId);
            return this;
        }

        public ChargeAddonRequest addonQuantity(Integer addonQuantity) {
            this.params.addOpt("addon_quantity", addonQuantity);
            return this;
        }

        public ChargeAddonRequest coupon(String coupon) {
            this.params.addOpt("coupon", coupon);
            return this;
        }

        public ChargeAddonRequest poNumber(String poNumber) {
            this.params.addOpt("po_number", poNumber);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChargeRequest
    extends Request<ChargeRequest> {
        private ChargeRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ChargeRequest customerId(String customerId) {
            this.params.addOpt("customer_id", customerId);
            return this;
        }

        public ChargeRequest subscriptionId(String subscriptionId) {
            this.params.addOpt("subscription_id", subscriptionId);
            return this;
        }

        public ChargeRequest amount(Integer amount) {
            this.params.add("amount", amount);
            return this;
        }

        public ChargeRequest description(String description) {
            this.params.add("description", description);
            return this;
        }

        public ChargeRequest coupon(String coupon) {
            this.params.addOpt("coupon", coupon);
            return this;
        }

        public ChargeRequest poNumber(String poNumber) {
            this.params.addOpt("po_number", poNumber);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest customerId(String customerId) {
            this.params.add("customer_id", customerId);
            return this;
        }

        public CreateRequest coupon(String coupon) {
            this.params.addOpt("coupon", coupon);
            return this;
        }

        public CreateRequest poNumber(String poNumber) {
            this.params.addOpt("po_number", poNumber);
            return this;
        }

        public CreateRequest shippingAddressFirstName(String shippingAddressFirstName) {
            this.params.addOpt("shipping_address[first_name]", shippingAddressFirstName);
            return this;
        }

        public CreateRequest shippingAddressLastName(String shippingAddressLastName) {
            this.params.addOpt("shipping_address[last_name]", shippingAddressLastName);
            return this;
        }

        public CreateRequest shippingAddressEmail(String shippingAddressEmail) {
            this.params.addOpt("shipping_address[email]", shippingAddressEmail);
            return this;
        }

        public CreateRequest shippingAddressCompany(String shippingAddressCompany) {
            this.params.addOpt("shipping_address[company]", shippingAddressCompany);
            return this;
        }

        public CreateRequest shippingAddressPhone(String shippingAddressPhone) {
            this.params.addOpt("shipping_address[phone]", shippingAddressPhone);
            return this;
        }

        public CreateRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public CreateRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public CreateRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public CreateRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public CreateRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public CreateRequest shippingAddressState(String shippingAddressState) {
            this.params.addOpt("shipping_address[state]", shippingAddressState);
            return this;
        }

        public CreateRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public CreateRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public CreateRequest addonId(int index, String addonId) {
            this.params.addOpt("addons[id][" + index + "]", addonId);
            return this;
        }

        public CreateRequest addonQuantity(int index, Integer addonQuantity) {
            this.params.addOpt("addons[quantity][" + index + "]", addonQuantity);
            return this;
        }

        public CreateRequest chargeAmount(int index, Integer chargeAmount) {
            this.params.addOpt("charges[amount][" + index + "]", chargeAmount);
            return this;
        }

        public CreateRequest chargeDescription(int index, String chargeDescription) {
            this.params.addOpt("charges[description][" + index + "]", chargeDescription);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BillingAddress
    extends Resource<BillingAddress> {
        public BillingAddress(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String firstName() {
            return this.optString("first_name");
        }

        public String lastName() {
            return this.optString("last_name");
        }

        public String email() {
            return this.optString("email");
        }

        public String company() {
            return this.optString("company");
        }

        public String phone() {
            return this.optString("phone");
        }

        public String line1() {
            return this.optString("line1");
        }

        public String line2() {
            return this.optString("line2");
        }

        public String line3() {
            return this.optString("line3");
        }

        public String city() {
            return this.optString("city");
        }

        public String stateCode() {
            return this.optString("state_code");
        }

        public String state() {
            return this.optString("state");
        }

        public String country() {
            return this.optString("country");
        }

        public String zip() {
            return this.optString("zip");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShippingAddress
    extends Resource<ShippingAddress> {
        public ShippingAddress(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String firstName() {
            return this.optString("first_name");
        }

        public String lastName() {
            return this.optString("last_name");
        }

        public String email() {
            return this.optString("email");
        }

        public String company() {
            return this.optString("company");
        }

        public String phone() {
            return this.optString("phone");
        }

        public String line1() {
            return this.optString("line1");
        }

        public String line2() {
            return this.optString("line2");
        }

        public String line3() {
            return this.optString("line3");
        }

        public String city() {
            return this.optString("city");
        }

        public String stateCode() {
            return this.optString("state_code");
        }

        public String state() {
            return this.optString("state");
        }

        public String country() {
            return this.optString("country");
        }

        public String zip() {
            return this.optString("zip");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Note
    extends Resource<Note> {
        public Note(JSONObject jsonObj) {
            super(jsonObj);
        }

        public EntityType entityType() {
            return this.reqEnum("entity_type", EntityType.class);
        }

        public String note() {
            return this.reqString("note");
        }

        public String entityId() {
            return this.optString("entity_id");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum EntityType {
            PLAN,
            ADDON,
            COUPON,
            SUBSCRIPTION,
            CUSTOMER,
            _UNKNOWN;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LinkedOrder
    extends Resource<LinkedOrder> {
        public LinkedOrder(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String id() {
            return this.reqString("id");
        }

        public Status status() {
            return this.optEnum("status", Status.class);
        }

        public String referenceId() {
            return this.optString("reference_id");
        }

        public String fulfillmentStatus() {
            return this.optString("fulfillment_status");
        }

        public String batchId() {
            return this.optString("batch_id");
        }

        public Timestamp createdAt() {
            return this.reqTimestamp("created_at");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Status {
            NEW,
            PROCESSING,
            COMPLETE,
            CANCELLED,
            VOIDED,
            _UNKNOWN;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LinkedTransaction
    extends Resource<LinkedTransaction> {
        public LinkedTransaction(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String txnId() {
            return this.reqString("txn_id");
        }

        public Integer appliedAmount() {
            return this.reqInteger("applied_amount");
        }

        public Transaction.Type txnType() {
            return this.reqEnum("txn_type", Transaction.Type.class);
        }

        public Transaction.Status txnStatus() {
            return this.optEnum("txn_status", Transaction.Status.class);
        }

        public Timestamp txnDate() {
            return this.optTimestamp("txn_date");
        }

        public Integer txnAmount() {
            return this.optInteger("txn_amount");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Tax
    extends Resource<Tax> {
        public Tax(JSONObject jsonObj) {
            super(jsonObj);
        }

        public Integer amount() {
            return this.reqInteger("amount");
        }

        public String description() {
            return this.optString("description");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Discount
    extends Resource<Discount> {
        public Discount(JSONObject jsonObj) {
            super(jsonObj);
        }

        public Integer amount() {
            return this.reqInteger("amount");
        }

        public String description() {
            return this.optString("description");
        }

        public Type type() {
            return this.reqEnum("type", Type.class);
        }

        public String entityId() {
            return this.optString("entity_id");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            COUPON,
            CREDIT_ADJUSTMENT,
            ACCOUNT_CREDITS,
            _UNKNOWN;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LineItem
    extends Resource<LineItem> {
        public LineItem(JSONObject jsonObj) {
            super(jsonObj);
        }

        public Timestamp dateFrom() {
            return this.reqTimestamp("date_from");
        }

        public Timestamp dateTo() {
            return this.reqTimestamp("date_to");
        }

        public Integer unitAmount() {
            return this.reqInteger("unit_amount");
        }

        public Integer quantity() {
            return this.optInteger("quantity");
        }

        public Boolean isTaxed() {
            return this.reqBoolean("is_taxed");
        }

        public Integer tax() {
            return this.optInteger("tax");
        }

        public Double taxRate() {
            return this.optDouble("tax_rate");
        }

        public Integer amount() {
            return this.reqInteger("amount");
        }

        public String description() {
            return this.reqString("description");
        }

        public Type type() {
            return this.reqEnum("type", Type.class);
        }

        public EntityType entityType() {
            return this.reqEnum("entity_type", EntityType.class);
        }

        public String entityId() {
            return this.optString("entity_id");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum EntityType {
            PLAN,
            ADDON,
            ADHOC,
            _UNKNOWN;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            CHARGE,
            PRORATED_CHARGE,
            SETUP_CHARGE,
            _UNKNOWN;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DunningStatus {
        IN_PROGRESS,
        EXHAUSTED,
        STOPPED,
        SUCCESS,
        _UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        PAID,
        PAYMENT_DUE,
        NOT_PAID,
        VOIDED,
        PENDING,
        _UNKNOWN;

    }
}

