/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.org.json.JSONObject;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Coupon
extends Resource<Coupon> {
    public Coupon(String jsonStr) {
        super(jsonStr);
    }

    public Coupon(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String name() {
        return this.reqString("name");
    }

    public String invoiceName() {
        return this.optString("invoice_name");
    }

    public DiscountType discountType() {
        return this.reqEnum("discount_type", DiscountType.class);
    }

    public Double discountPercentage() {
        return this.optDouble("discount_percentage");
    }

    public Integer discountAmount() {
        return this.optInteger("discount_amount");
    }

    @Deprecated
    public Integer discountQuantity() {
        return this.optInteger("discount_quantity");
    }

    public DurationType durationType() {
        return this.reqEnum("duration_type", DurationType.class);
    }

    public Integer durationMonth() {
        return this.optInteger("duration_month");
    }

    public Timestamp validTill() {
        return this.optTimestamp("valid_till");
    }

    public Integer maxRedemptions() {
        return this.optInteger("max_redemptions");
    }

    public Status status() {
        return this.optEnum("status", Status.class);
    }

    @Deprecated
    public ApplyDiscountOn applyDiscountOn() {
        return this.reqEnum("apply_discount_on", ApplyDiscountOn.class);
    }

    public ApplyOn applyOn() {
        return this.reqEnum("apply_on", ApplyOn.class);
    }

    public PlanConstraint planConstraint() {
        return this.reqEnum("plan_constraint", PlanConstraint.class);
    }

    public AddonConstraint addonConstraint() {
        return this.reqEnum("addon_constraint", AddonConstraint.class);
    }

    public Timestamp createdAt() {
        return this.reqTimestamp("created_at");
    }

    public Timestamp archivedAt() {
        return this.optTimestamp("archived_at");
    }

    public List<String> planIds() {
        return this.optList("plan_ids", String.class);
    }

    public List<String> addonIds() {
        return this.optList("addon_ids", String.class);
    }

    public Integer redemptions() {
        return this.optInteger("redemptions");
    }

    public String invoiceNotes() {
        return this.optString("invoice_notes");
    }

    public JSONObject metaData() {
        return this.optJSONObject("meta_data");
    }

    public static CreateRequest create() throws IOException {
        String uri = Coupon.uri("coupons");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static ListRequest list() throws IOException {
        String uri = Coupon.uri("coupons");
        return new ListRequest(uri);
    }

    public static Request retrieve(String id) throws IOException {
        String uri = Coupon.uri("coupons", Coupon.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest id(String id) {
            this.params.add("id", id);
            return this;
        }

        public CreateRequest name(String name) {
            this.params.add("name", name);
            return this;
        }

        public CreateRequest invoiceName(String invoiceName) {
            this.params.addOpt("invoice_name", invoiceName);
            return this;
        }

        public CreateRequest discountType(DiscountType discountType) {
            this.params.add("discount_type", (Object)discountType);
            return this;
        }

        public CreateRequest discountAmount(Integer discountAmount) {
            this.params.addOpt("discount_amount", discountAmount);
            return this;
        }

        public CreateRequest discountPercentage(Double discountPercentage) {
            this.params.addOpt("discount_percentage", discountPercentage);
            return this;
        }

        @Deprecated
        public CreateRequest discountQuantity(Integer discountQuantity) {
            this.params.addOpt("discount_quantity", discountQuantity);
            return this;
        }

        public CreateRequest applyOn(ApplyOn applyOn) {
            this.params.add("apply_on", (Object)applyOn);
            return this;
        }

        public CreateRequest planConstraint(PlanConstraint planConstraint) {
            this.params.addOpt("plan_constraint", (Object)planConstraint);
            return this;
        }

        public CreateRequest addonConstraint(AddonConstraint addonConstraint) {
            this.params.addOpt("addon_constraint", (Object)addonConstraint);
            return this;
        }

        public CreateRequest planIds(List<String> planIds) {
            this.params.addOpt("plan_ids", planIds);
            return this;
        }

        public CreateRequest planIds(String ... planIds) {
            this.params.addOpt("plan_ids", planIds);
            return this;
        }

        public CreateRequest addonIds(List<String> addonIds) {
            this.params.addOpt("addon_ids", addonIds);
            return this;
        }

        public CreateRequest addonIds(String ... addonIds) {
            this.params.addOpt("addon_ids", addonIds);
            return this;
        }

        public CreateRequest durationType(DurationType durationType) {
            this.params.add("duration_type", (Object)durationType);
            return this;
        }

        public CreateRequest durationMonth(Integer durationMonth) {
            this.params.addOpt("duration_month", durationMonth);
            return this;
        }

        public CreateRequest validTill(Timestamp validTill) {
            this.params.addOpt("valid_till", validTill);
            return this;
        }

        public CreateRequest maxRedemptions(Integer maxRedemptions) {
            this.params.addOpt("max_redemptions", maxRedemptions);
            return this;
        }

        public CreateRequest invoiceNotes(String invoiceNotes) {
            this.params.addOpt("invoice_notes", invoiceNotes);
            return this;
        }

        public CreateRequest metaData(JSONObject metaData) {
            this.params.addOpt("meta_data", metaData);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AddonConstraint {
        NONE,
        ALL,
        SPECIFIC,
        NOT_APPLICABLE,
        _UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PlanConstraint {
        NONE,
        ALL,
        SPECIFIC,
        NOT_APPLICABLE,
        _UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ApplyOn {
        INVOICE_AMOUNT,
        SPECIFIED_ITEMS_TOTAL,
        EACH_SPECIFIED_ITEM,
        EACH_UNIT_OF_SPECIFIED_ITEMS,
        _UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static enum ApplyDiscountOn {
        PLANS,
        PLANS_AND_ADDONS,
        PLANS_WITH_QUANTITY,
        NOT_APPLICABLE,
        _UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        ACTIVE,
        EXPIRED,
        ARCHIVED,
        _UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DurationType {
        ONE_TIME,
        FOREVER,
        LIMITED_PERIOD,
        _UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DiscountType {
        FIXED_AMOUNT,
        PERCENTAGE,
        OFFER_QUANTITY,
        _UNKNOWN;

    }
}

