/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.enums.PriceType;
import com.chargebee.models.enums.SubscriptionStatus;
import com.chargebee.models.enums.Taxability;
import com.chargebee.org.json.JSONObject;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Estimate
extends Resource<Estimate> {
    public Estimate(String jsonStr) {
        super(jsonStr);
    }

    public Estimate(JSONObject jsonObj) {
        super(jsonObj);
    }

    public Timestamp createdAt() {
        return this.reqTimestamp("created_at");
    }

    public Boolean recurring() {
        return this.reqBoolean("recurring");
    }

    public String subscriptionId() {
        return this.optString("subscription_id");
    }

    public SubscriptionStatus subscriptionStatus() {
        return this.optEnum("subscription_status", SubscriptionStatus.class);
    }

    public Timestamp termEndsAt() {
        return this.optTimestamp("term_ends_at");
    }

    public Boolean collectNow() {
        return this.reqBoolean("collect_now");
    }

    public PriceType priceType() {
        return this.reqEnum("price_type", PriceType.class);
    }

    public Integer amount() {
        return this.reqInteger("amount");
    }

    public Integer creditsApplied() {
        return this.reqInteger("credits_applied");
    }

    public Integer amountDue() {
        return this.reqInteger("amount_due");
    }

    public Integer subTotal() {
        return this.reqInteger("sub_total");
    }

    public List<LineItem> lineItems() {
        return this.optList("line_items", LineItem.class);
    }

    public List<Discount> discounts() {
        return this.optList("discounts", Discount.class);
    }

    public List<Tax> taxes() {
        return this.optList("taxes", Tax.class);
    }

    public static CreateSubscriptionRequest createSubscription() throws IOException {
        String uri = Estimate.uri("estimates", "create_subscription");
        return new CreateSubscriptionRequest(HttpUtil.Method.POST, uri);
    }

    public static UpdateSubscriptionRequest updateSubscription() throws IOException {
        String uri = Estimate.uri("estimates", "update_subscription");
        return new UpdateSubscriptionRequest(HttpUtil.Method.POST, uri);
    }

    public static RenewalEstimateRequest renewalEstimate(String id) throws IOException {
        String uri = Estimate.uri("subscriptions", Estimate.nullCheck(id), "renewal_estimate");
        return new RenewalEstimateRequest(HttpUtil.Method.GET, uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RenewalEstimateRequest
    extends Request<RenewalEstimateRequest> {
        private RenewalEstimateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RenewalEstimateRequest includeDelayedCharges(Boolean includeDelayedCharges) {
            this.params.addOpt("include_delayed_charges", includeDelayedCharges);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdateSubscriptionRequest
    extends Request<UpdateSubscriptionRequest> {
        private UpdateSubscriptionRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateSubscriptionRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        public UpdateSubscriptionRequest replaceAddonList(Boolean replaceAddonList) {
            this.params.addOpt("replace_addon_list", replaceAddonList);
            return this;
        }

        public UpdateSubscriptionRequest prorate(Boolean prorate) {
            this.params.addOpt("prorate", prorate);
            return this;
        }

        public UpdateSubscriptionRequest endOfTerm(Boolean endOfTerm) {
            this.params.addOpt("end_of_term", endOfTerm);
            return this;
        }

        public UpdateSubscriptionRequest includeDelayedCharges(Boolean includeDelayedCharges) {
            this.params.addOpt("include_delayed_charges", includeDelayedCharges);
            return this;
        }

        public UpdateSubscriptionRequest subscriptionId(String subscriptionId) {
            this.params.add("subscription[id]", subscriptionId);
            return this;
        }

        public UpdateSubscriptionRequest subscriptionPlanId(String subscriptionPlanId) {
            this.params.addOpt("subscription[plan_id]", subscriptionPlanId);
            return this;
        }

        public UpdateSubscriptionRequest subscriptionPlanQuantity(Integer subscriptionPlanQuantity) {
            this.params.addOpt("subscription[plan_quantity]", subscriptionPlanQuantity);
            return this;
        }

        public UpdateSubscriptionRequest subscriptionStartDate(Timestamp subscriptionStartDate) {
            this.params.addOpt("subscription[start_date]", subscriptionStartDate);
            return this;
        }

        public UpdateSubscriptionRequest subscriptionTrialEnd(Timestamp subscriptionTrialEnd) {
            this.params.addOpt("subscription[trial_end]", subscriptionTrialEnd);
            return this;
        }

        public UpdateSubscriptionRequest subscriptionCoupon(String subscriptionCoupon) {
            this.params.addOpt("subscription[coupon]", subscriptionCoupon);
            return this;
        }

        public UpdateSubscriptionRequest billingAddressCountry(String billingAddressCountry) {
            this.params.addOpt("billing_address[country]", billingAddressCountry);
            return this;
        }

        public UpdateSubscriptionRequest billingAddressStateCode(String billingAddressStateCode) {
            this.params.addOpt("billing_address[state_code]", billingAddressStateCode);
            return this;
        }

        public UpdateSubscriptionRequest billingAddressZip(String billingAddressZip) {
            this.params.addOpt("billing_address[zip]", billingAddressZip);
            return this;
        }

        public UpdateSubscriptionRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public UpdateSubscriptionRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public UpdateSubscriptionRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public UpdateSubscriptionRequest customerVatNumber(String customerVatNumber) {
            this.params.addOpt("customer[vat_number]", customerVatNumber);
            return this;
        }

        public UpdateSubscriptionRequest customerTaxability(Taxability customerTaxability) {
            this.params.addOpt("customer[taxability]", (Object)customerTaxability);
            return this;
        }

        public UpdateSubscriptionRequest addonId(int index, String addonId) {
            this.params.addOpt("addons[id][" + index + "]", addonId);
            return this;
        }

        public UpdateSubscriptionRequest addonQuantity(int index, Integer addonQuantity) {
            this.params.addOpt("addons[quantity][" + index + "]", addonQuantity);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateSubscriptionRequest
    extends Request<CreateSubscriptionRequest> {
        private CreateSubscriptionRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateSubscriptionRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        public CreateSubscriptionRequest subscriptionId(String subscriptionId) {
            this.params.addOpt("subscription[id]", subscriptionId);
            return this;
        }

        public CreateSubscriptionRequest subscriptionPlanId(String subscriptionPlanId) {
            this.params.add("subscription[plan_id]", subscriptionPlanId);
            return this;
        }

        public CreateSubscriptionRequest subscriptionPlanQuantity(Integer subscriptionPlanQuantity) {
            this.params.addOpt("subscription[plan_quantity]", subscriptionPlanQuantity);
            return this;
        }

        public CreateSubscriptionRequest subscriptionStartDate(Timestamp subscriptionStartDate) {
            this.params.addOpt("subscription[start_date]", subscriptionStartDate);
            return this;
        }

        public CreateSubscriptionRequest subscriptionTrialEnd(Timestamp subscriptionTrialEnd) {
            this.params.addOpt("subscription[trial_end]", subscriptionTrialEnd);
            return this;
        }

        public CreateSubscriptionRequest subscriptionCoupon(String subscriptionCoupon) {
            this.params.addOpt("subscription[coupon]", subscriptionCoupon);
            return this;
        }

        public CreateSubscriptionRequest billingAddressCountry(String billingAddressCountry) {
            this.params.addOpt("billing_address[country]", billingAddressCountry);
            return this;
        }

        public CreateSubscriptionRequest billingAddressStateCode(String billingAddressStateCode) {
            this.params.addOpt("billing_address[state_code]", billingAddressStateCode);
            return this;
        }

        public CreateSubscriptionRequest billingAddressZip(String billingAddressZip) {
            this.params.addOpt("billing_address[zip]", billingAddressZip);
            return this;
        }

        public CreateSubscriptionRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public CreateSubscriptionRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public CreateSubscriptionRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public CreateSubscriptionRequest customerVatNumber(String customerVatNumber) {
            this.params.addOpt("customer[vat_number]", customerVatNumber);
            return this;
        }

        public CreateSubscriptionRequest customerTaxability(Taxability customerTaxability) {
            this.params.addOpt("customer[taxability]", (Object)customerTaxability);
            return this;
        }

        public CreateSubscriptionRequest addonId(int index, String addonId) {
            this.params.addOpt("addons[id][" + index + "]", addonId);
            return this;
        }

        public CreateSubscriptionRequest addonQuantity(int index, Integer addonQuantity) {
            this.params.addOpt("addons[quantity][" + index + "]", addonQuantity);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Tax
    extends Resource<Tax> {
        public Tax(JSONObject jsonObj) {
            super(jsonObj);
        }

        public Integer amount() {
            return this.reqInteger("amount");
        }

        public String description() {
            return this.optString("description");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Discount
    extends Resource<Discount> {
        public Discount(JSONObject jsonObj) {
            super(jsonObj);
        }

        public Integer amount() {
            return this.reqInteger("amount");
        }

        public String description() {
            return this.optString("description");
        }

        public Type type() {
            return this.reqEnum("type", Type.class);
        }

        public String entityId() {
            return this.optString("entity_id");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            COUPON,
            CREDIT_ADJUSTMENT,
            ACCOUNT_CREDITS,
            _UNKNOWN;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LineItem
    extends Resource<LineItem> {
        public LineItem(JSONObject jsonObj) {
            super(jsonObj);
        }

        public Timestamp dateFrom() {
            return this.reqTimestamp("date_from");
        }

        public Timestamp dateTo() {
            return this.reqTimestamp("date_to");
        }

        public Integer unitAmount() {
            return this.reqInteger("unit_amount");
        }

        public Integer quantity() {
            return this.optInteger("quantity");
        }

        public Boolean isTaxed() {
            return this.reqBoolean("is_taxed");
        }

        public Integer tax() {
            return this.optInteger("tax");
        }

        public Double taxRate() {
            return this.optDouble("tax_rate");
        }

        public Integer amount() {
            return this.reqInteger("amount");
        }

        public String description() {
            return this.reqString("description");
        }

        public Type type() {
            return this.reqEnum("type", Type.class);
        }

        public EntityType entityType() {
            return this.reqEnum("entity_type", EntityType.class);
        }

        public String entityId() {
            return this.optString("entity_id");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum EntityType {
            PLAN,
            ADDON,
            ADHOC,
            _UNKNOWN;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            CHARGE,
            PRORATED_CHARGE,
            SETUP_CHARGE,
            _UNKNOWN;

        }
    }
}

