/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.enums.Gateway;
import com.chargebee.models.enums.PaymentMethod;
import com.chargebee.org.json.JSONObject;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transaction
extends Resource<Transaction> {
    public Transaction(String jsonStr) {
        super(jsonStr);
    }

    public Transaction(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String customerId() {
        return this.optString("customer_id");
    }

    public String subscriptionId() {
        return this.optString("subscription_id");
    }

    public PaymentMethod paymentMethod() {
        return this.reqEnum("payment_method", PaymentMethod.class);
    }

    public String referenceNumber() {
        return this.optString("reference_number");
    }

    public Gateway gateway() {
        return this.reqEnum("gateway", Gateway.class);
    }

    @Deprecated
    public String description() {
        return this.optString("description");
    }

    public Type type() {
        return this.reqEnum("type", Type.class);
    }

    public Timestamp date() {
        return this.optTimestamp("date");
    }

    public Integer amount() {
        return this.optInteger("amount");
    }

    public String idAtGateway() {
        return this.optString("id_at_gateway");
    }

    public Status status() {
        return this.optEnum("status", Status.class);
    }

    public InitiatorType initiatorType() {
        return this.optEnum("initiator_type", InitiatorType.class);
    }

    public Boolean threeDSecure() {
        return this.optBoolean("three_d_secure");
    }

    public String errorCode() {
        return this.optString("error_code");
    }

    public String errorText() {
        return this.optString("error_text");
    }

    public Timestamp voidedAt() {
        return this.optTimestamp("voided_at");
    }

    @Deprecated
    public String voidDescription() {
        return this.optString("void_description");
    }

    public Integer amountUnused() {
        return this.optInteger("amount_unused");
    }

    public String maskedCardNumber() {
        return this.optString("masked_card_number");
    }

    public String referenceTransactionId() {
        return this.optString("reference_transaction_id");
    }

    public String refundedTxnId() {
        return this.optString("refunded_txn_id");
    }

    public String reversalTransactionId() {
        return this.optString("reversal_transaction_id");
    }

    public List<LinkedInvoice> linkedInvoices() {
        return this.optList("linked_invoices", LinkedInvoice.class);
    }

    public List<LinkedRefund> linkedRefunds() {
        return this.optList("linked_refunds", LinkedRefund.class);
    }

    public String currencyCode() {
        return this.optString("currency_code");
    }

    public static ListRequest list() throws IOException {
        String uri = Transaction.uri("transactions");
        return new ListRequest(uri);
    }

    public static ListRequest transactionsForCustomer(String id) throws IOException {
        String uri = Transaction.uri("customers", Transaction.nullCheck(id), "transactions");
        return new ListRequest(uri);
    }

    public static ListRequest transactionsForSubscription(String id) throws IOException {
        String uri = Transaction.uri("subscriptions", Transaction.nullCheck(id), "transactions");
        return new ListRequest(uri);
    }

    public static ListRequest transactionsForInvoice(String id) throws IOException {
        String uri = Transaction.uri("invoices", Transaction.nullCheck(id), "transactions");
        return new ListRequest(uri);
    }

    public static Request retrieve(String id) throws IOException {
        String uri = Transaction.uri("transactions", Transaction.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static RecordPaymentRequest recordPayment(String id) throws IOException {
        String uri = Transaction.uri("invoices", Transaction.nullCheck(id), "record_payment");
        return new RecordPaymentRequest(HttpUtil.Method.POST, uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RecordPaymentRequest
    extends Request<RecordPaymentRequest> {
        private RecordPaymentRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RecordPaymentRequest amount(Integer amount) {
            this.params.addOpt("amount", amount);
            return this;
        }

        public RecordPaymentRequest paymentMethod(PaymentMethod paymentMethod) {
            this.params.add("payment_method", (Object)paymentMethod);
            return this;
        }

        public RecordPaymentRequest paidAt(Timestamp paidAt) {
            this.params.add("paid_at", paidAt);
            return this;
        }

        public RecordPaymentRequest referenceNumber(String referenceNumber) {
            this.params.addOpt("reference_number", referenceNumber);
            return this;
        }

        public RecordPaymentRequest memo(String memo) {
            this.params.addOpt("memo", memo);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LinkedRefund
    extends Resource<LinkedRefund> {
        public LinkedRefund(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String txnId() {
            return this.reqString("txn_id");
        }

        public Status txnStatus() {
            return this.reqEnum("txn_status", Status.class);
        }

        public Timestamp txnDate() {
            return this.reqTimestamp("txn_date");
        }

        public Integer txnAmount() {
            return this.reqInteger("txn_amount");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LinkedInvoice
    extends Resource<LinkedInvoice> {
        public LinkedInvoice(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String invoiceId() {
            return this.reqString("invoice_id");
        }

        public Integer appliedAmount() {
            return this.reqInteger("applied_amount");
        }

        public Timestamp appliedAt() {
            return this.reqTimestamp("applied_at");
        }

        public Timestamp invoiceDate() {
            return this.optTimestamp("invoice_date");
        }

        public Integer invoiceAmount() {
            return this.optInteger("invoice_amount");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InitiatorType {
        CUSTOMER,
        MERCHANT,
        _UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        IN_PROGRESS,
        SUCCESS,
        VOIDED,
        FAILURE,
        TIMEOUT,
        NEEDS_ATTENTION,
        _UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        AUTHORIZATION,
        PAYMENT,
        REFUND,
        PAYMENT_REVERSAL,
        _UNKNOWN;

    }
}

