/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee;

public class Environment {
    public final String apiKey;
    public final String siteName;
    public int connectTimeout = Integer.getInteger("com.chargebee.api.http.timeout.connect", 15000);
    public int readTimeout = Integer.getInteger("com.chargebee.api.http.timeout.read", 60000);
    public static final String CHARSET = "UTF-8";
    public static final String API_VERSION = "v2";
    public static final String LIBRARY_VERSION = "2.3.3";
    private final String apiBaseUrl;
    private static Environment defaultEnv;

    public Environment(String siteName, String apiKey) {
        this.apiKey = apiKey;
        this.siteName = siteName;
        String domainSuffix = System.getProperty("com.chargebee.api.domain.suffix", "chargebee.com");
        String proto = System.getProperty("com.chargebee.api.protocol", "https");
        this.apiBaseUrl = proto + "://" + siteName + "." + domainSuffix + "/api/" + API_VERSION;
    }

    public static void configure(String siteName, String apikey) {
        defaultEnv = new Environment(siteName, apikey);
    }

    public static Environment defaultConfig() {
        if (defaultEnv == null) {
            throw new RuntimeException("The default environment has not been configured");
        }
        return defaultEnv;
    }

    public String apiBaseUrl() {
        return this.apiBaseUrl;
    }
}

