/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.EnumFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.filters.TimestampFilter;
import com.chargebee.filters.enums.SortOrder;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.org.json.JSONObject;
import java.io.IOException;
import java.sql.Timestamp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Order
extends Resource<Order> {
    public Order(String jsonStr) {
        super(jsonStr);
    }

    public Order(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String invoiceId() {
        return this.reqString("invoice_id");
    }

    public Status status() {
        return this.optEnum("status", Status.class);
    }

    public String referenceId() {
        return this.optString("reference_id");
    }

    public String fulfillmentStatus() {
        return this.optString("fulfillment_status");
    }

    public String note() {
        return this.optString("note");
    }

    public String trackingId() {
        return this.optString("tracking_id");
    }

    public String batchId() {
        return this.optString("batch_id");
    }

    public String createdBy() {
        return this.optString("created_by");
    }

    public Timestamp createdAt() {
        return this.reqTimestamp("created_at");
    }

    public Timestamp statusUpdateAt() {
        return this.optTimestamp("status_update_at");
    }

    public static CreateRequest create() throws IOException {
        String uri = Order.uri("orders");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static UpdateRequest update(String id) throws IOException {
        String uri = Order.uri("orders", Order.nullCheck(id));
        return new UpdateRequest(HttpUtil.Method.POST, uri);
    }

    public static Request retrieve(String id) throws IOException {
        String uri = Order.uri("orders", Order.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static OrderListRequest list() throws IOException {
        String uri = Order.uri("orders");
        return new OrderListRequest(uri);
    }

    @Deprecated
    public static ListRequest ordersForInvoice(String id) throws IOException {
        String uri = Order.uri("invoices", Order.nullCheck(id), "orders");
        return new ListRequest(uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OrderListRequest
    extends ListRequest<OrderListRequest> {
        private OrderListRequest(String uri) {
            super(uri);
        }

        public StringFilter<OrderListRequest> id() {
            return new StringFilter<OrderListRequest>("id", this).supportsMultiOperators(true);
        }

        public StringFilter<OrderListRequest> invoiceId() {
            return new StringFilter<OrderListRequest>("invoice_id", this).supportsMultiOperators(true);
        }

        public EnumFilter<Status, OrderListRequest> status() {
            return new EnumFilter<Status, OrderListRequest>("status", this);
        }

        public TimestampFilter<OrderListRequest> createdAt() {
            return new TimestampFilter<OrderListRequest>("created_at", this);
        }

        public OrderListRequest sortByCreatedAt(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "created_at");
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdateRequest
    extends Request<UpdateRequest> {
        private UpdateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateRequest status(Status status) {
            this.params.addOpt("status", (Object)status);
            return this;
        }

        public UpdateRequest referenceId(String referenceId) {
            this.params.addOpt("reference_id", referenceId);
            return this;
        }

        public UpdateRequest fulfillmentStatus(String fulfillmentStatus) {
            this.params.addOpt("fulfillment_status", fulfillmentStatus);
            return this;
        }

        public UpdateRequest note(String note) {
            this.params.addOpt("note", note);
            return this;
        }

        public UpdateRequest trackingId(String trackingId) {
            this.params.addOpt("tracking_id", trackingId);
            return this;
        }

        public UpdateRequest batchId(String batchId) {
            this.params.addOpt("batch_id", batchId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest id(String id) {
            this.params.addOpt("id", id);
            return this;
        }

        public CreateRequest invoiceId(String invoiceId) {
            this.params.add("invoice_id", invoiceId);
            return this;
        }

        public CreateRequest status(Status status) {
            this.params.addOpt("status", (Object)status);
            return this;
        }

        public CreateRequest referenceId(String referenceId) {
            this.params.addOpt("reference_id", referenceId);
            return this;
        }

        public CreateRequest fulfillmentStatus(String fulfillmentStatus) {
            this.params.addOpt("fulfillment_status", fulfillmentStatus);
            return this;
        }

        public CreateRequest note(String note) {
            this.params.addOpt("note", note);
            return this;
        }

        public CreateRequest trackingId(String trackingId) {
            this.params.addOpt("tracking_id", trackingId);
            return this;
        }

        public CreateRequest batchId(String batchId) {
            this.params.addOpt("batch_id", batchId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        NEW,
        PROCESSING,
        COMPLETE,
        CANCELLED,
        VOIDED,
        _UNKNOWN;

    }
}

