/*
 * Decompiled with CFR 0.152.
 */
package com.chrylis.codec.base58;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.ArrayUtils;

public class Base58Codec {
    public static final Charset CHARSET_ASCII = Charset.forName("US-ASCII");
    public static final BigInteger BASE = BigInteger.valueOf(58L);
    public static final int BLOCK_LENGTH_BYTES = 29;
    public static final int BLOCK_LENGTH_DIGITS = 128;
    public static final char[] ALPHABET = "123456789abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ".toCharArray();

    public static String doEncode(byte[] source) {
        BigInteger dividend;
        if (source.length == 0) {
            return "";
        }
        if (source[0] >= 0) {
            dividend = new BigInteger(source);
        } else {
            byte[] paddedSource = new byte[source.length + 1];
            System.arraycopy(source, 0, paddedSource, 1, source.length);
            dividend = new BigInteger(paddedSource);
        }
        if (dividend.equals(BigInteger.ZERO)) {
            return "1";
        }
        StringBuilder sb = new StringBuilder();
        while (dividend.compareTo(BigInteger.ZERO) > 0) {
            BigInteger[] qr = dividend.divideAndRemainder(BASE);
            int base58DigitValue = qr[1].intValue();
            sb.append(ALPHABET[base58DigitValue]);
            dividend = qr[0];
        }
        return sb.reverse().toString();
    }

    public String encode(byte[] source) {
        return Base58Codec.doEncode(source);
    }

    public static String doEncode(long value) {
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.putLong(value);
        bb.flip();
        return Base58Codec.doEncode(bb.array());
    }

    public String encode(long value) {
        return Base58Codec.doEncode(value);
    }

    public static byte[] doDecode(String source) {
        BigInteger value = BigInteger.ZERO;
        Iterator<Character> it = Base58Codec.stringIterator(source);
        while (it.hasNext()) {
            value = value.add(BigInteger.valueOf(ArrayUtils.indexOf((char[])ALPHABET, (char)it.next().charValue())));
            if (!it.hasNext()) continue;
            value = value.multiply(BASE);
        }
        return value.toByteArray();
    }

    public byte[] decode(String source) {
        return Base58Codec.doDecode(source);
    }

    public static byte[] doDecode(String source, int numBytes) {
        return Base58Codec.padToSize(Base58Codec.doDecode(source), numBytes);
    }

    public byte[] decode(String source, int numBytes) {
        return Base58Codec.doDecode(source, numBytes);
    }

    public static Iterator<Character> stringIterator(final String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        return new Iterator<Character>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < string.length();
            }

            @Override
            public Character next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return Character.valueOf(string.charAt(this.index++));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static byte[] padToSize(byte[] array, int size) {
        if (size == array.length) {
            return array;
        }
        if (size > array.length) {
            byte[] target = new byte[size];
            System.arraycopy(array, 0, target, size - array.length, array.length);
            return target;
        }
        int i = 0;
        while (i < array.length - size) {
            if (array[i] != 0) {
                throw new IllegalArgumentException("requested size " + size + " is shorter than existing length " + array.length + " and the leading bytes are not zeroes");
            }
            ++i;
        }
        byte[] target = new byte[size];
        System.arraycopy(array, array.length - size, target, 0, size);
        return target;
    }
}

