/*
 * Copyright (c) 2011-13 Miles Sabin 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package shapeless

class HMapBuilder[R[_, _]] {

  def apply[K0, V0]
    (e0 : (K0, V0))
    (implicit ev0 : R[K0, V0])
    = new HMap[R](Map(e0))

  def apply[K0, V0, K1, V1]
    (e0 : (K0, V0), e1 : (K1, V1))
    (implicit ev0 : R[K0, V0], ev1 : R[K1, V1])
    = new HMap[R](Map(e0, e1))

  def apply[K0, V0, K1, V1, K2, V2]
    (e0 : (K0, V0), e1 : (K1, V1), e2 : (K2, V2))
    (implicit ev0 : R[K0, V0], ev1 : R[K1, V1], ev2 : R[K2, V2])
    = new HMap[R](Map(e0, e1, e2))

  def apply[K0, V0, K1, V1, K2, V2, K3, V3]
    (e0 : (K0, V0), e1 : (K1, V1), e2 : (K2, V2), e3 : (K3, V3))
    (implicit ev0 : R[K0, V0], ev1 : R[K1, V1], ev2 : R[K2, V2], ev3 : R[K3, V3])
    = new HMap[R](Map(e0, e1, e2, e3))

  def apply[K0, V0, K1, V1, K2, V2, K3, V3, K4, V4]
    (e0 : (K0, V0), e1 : (K1, V1), e2 : (K2, V2), e3 : (K3, V3), e4 : (K4, V4))
    (implicit ev0 : R[K0, V0], ev1 : R[K1, V1], ev2 : R[K2, V2], ev3 : R[K3, V3], ev4 : R[K4, V4])
    = new HMap[R](Map(e0, e1, e2, e3, e4))

  def apply[K0, V0, K1, V1, K2, V2, K3, V3, K4, V4, K5, V5]
    (e0 : (K0, V0), e1 : (K1, V1), e2 : (K2, V2), e3 : (K3, V3), e4 : (K4, V4), e5 : (K5, V5))
    (implicit ev0 : R[K0, V0], ev1 : R[K1, V1], ev2 : R[K2, V2], ev3 : R[K3, V3], ev4 : R[K4, V4], ev5 : R[K5, V5])
    = new HMap[R](Map(e0, e1, e2, e3, e4, e5))

  def apply[K0, V0, K1, V1, K2, V2, K3, V3, K4, V4, K5, V5, K6, V6]
    (e0 : (K0, V0), e1 : (K1, V1), e2 : (K2, V2), e3 : (K3, V3), e4 : (K4, V4), e5 : (K5, V5), e6 : (K6, V6))
    (implicit ev0 : R[K0, V0], ev1 : R[K1, V1], ev2 : R[K2, V2], ev3 : R[K3, V3], ev4 : R[K4, V4], ev5 : R[K5, V5], ev6 : R[K6, V6])
    = new HMap[R](Map(e0, e1, e2, e3, e4, e5, e6))

  def apply[K0, V0, K1, V1, K2, V2, K3, V3, K4, V4, K5, V5, K6, V6, K7, V7]
    (e0 : (K0, V0), e1 : (K1, V1), e2 : (K2, V2), e3 : (K3, V3), e4 : (K4, V4), e5 : (K5, V5), e6 : (K6, V6), e7 : (K7, V7))
    (implicit ev0 : R[K0, V0], ev1 : R[K1, V1], ev2 : R[K2, V2], ev3 : R[K3, V3], ev4 : R[K4, V4], ev5 : R[K5, V5], ev6 : R[K6, V6], ev7 : R[K7, V7])
    = new HMap[R](Map(e0, e1, e2, e3, e4, e5, e6, e7))

  def apply[K0, V0, K1, V1, K2, V2, K3, V3, K4, V4, K5, V5, K6, V6, K7, V7, K8, V8]
    (e0 : (K0, V0), e1 : (K1, V1), e2 : (K2, V2), e3 : (K3, V3), e4 : (K4, V4), e5 : (K5, V5), e6 : (K6, V6), e7 : (K7, V7), e8 : (K8, V8))
    (implicit ev0 : R[K0, V0], ev1 : R[K1, V1], ev2 : R[K2, V2], ev3 : R[K3, V3], ev4 : R[K4, V4], ev5 : R[K5, V5], ev6 : R[K6, V6], ev7 : R[K7, V7], ev8 : R[K8, V8])
    = new HMap[R](Map(e0, e1, e2, e3, e4, e5, e6, e7, e8))

  def apply[K0, V0, K1, V1, K2, V2, K3, V3, K4, V4, K5, V5, K6, V6, K7, V7, K8, V8, K9, V9]
    (e0 : (K0, V0), e1 : (K1, V1), e2 : (K2, V2), e3 : (K3, V3), e4 : (K4, V4), e5 : (K5, V5), e6 : (K6, V6), e7 : (K7, V7), e8 : (K8, V8), e9 : (K9, V9))
    (implicit ev0 : R[K0, V0], ev1 : R[K1, V1], ev2 : R[K2, V2], ev3 : R[K3, V3], ev4 : R[K4, V4], ev5 : R[K5, V5], ev6 : R[K6, V6], ev7 : R[K7, V7], ev8 : R[K8, V8], ev9 : R[K9, V9])
    = new HMap[R](Map(e0, e1, e2, e3, e4, e5, e6, e7, e8, e9))
}
