/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.token;

import biscuit.format.schema.Schema;
import com.clevercloud.biscuit.datalog.Caveat;
import com.clevercloud.biscuit.datalog.Fact;
import com.clevercloud.biscuit.datalog.ID;
import com.clevercloud.biscuit.datalog.Rule;
import com.clevercloud.biscuit.datalog.SymbolTable;
import com.clevercloud.biscuit.datalog.World;
import com.clevercloud.biscuit.error.Error;
import com.clevercloud.biscuit.error.FailedCaveat;
import com.clevercloud.biscuit.error.LogicError;
import com.google.protobuf.InvalidProtocolBufferException;
import io.vavr.API;
import io.vavr.control.Either;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class Block {
    final long index;
    final SymbolTable symbols;
    final String context;
    final List<Fact> facts;
    final List<Rule> rules;
    final List<Caveat> caveats;

    public Block(long index, SymbolTable base_symbols) {
        this.index = index;
        this.symbols = base_symbols;
        this.context = "";
        this.facts = new ArrayList<Fact>();
        this.rules = new ArrayList<Rule>();
        this.caveats = new ArrayList<Caveat>();
    }

    public Block(long index, SymbolTable base_symbols, String context, List<Fact> facts, List<Rule> rules, List<Caveat> caveats) {
        this.index = index;
        this.symbols = base_symbols;
        this.context = context;
        this.facts = facts;
        this.rules = rules;
        this.caveats = caveats;
    }

    Either<LogicError, Void> check(long i, World w, SymbolTable symbols, List<Caveat> verifier_caveats, HashMap<String, Rule> queries, HashMap<String, HashMap<Long, Set<Fact>>> query_results) {
        Set<Fact> res;
        int k;
        Caveat c;
        boolean successful;
        int j;
        World world = new World(w);
        long authority_index = (Long)symbols.get("authority").get();
        long ambient_index = (Long)symbols.get("ambient").get();
        for (Fact fact : this.facts) {
            if (fact.predicate().ids().get(0).equals(new ID.Symbol(authority_index)) || fact.predicate().ids().get(0).equals(new ID.Symbol(ambient_index))) {
                LogicError logicError = new LogicError();
                logicError.getClass();
                return API.Left((Object)logicError.new LogicError.InvalidBlockFact(i, symbols.print_fact(fact)));
            }
            world.add_fact(fact);
        }
        for (Rule rule : this.rules) {
            world.add_rule(rule);
        }
        world.run();
        ArrayList<FailedCaveat> errors = new ArrayList<FailedCaveat>();
        for (j = 0; j < this.caveats.size(); ++j) {
            successful = false;
            c = this.caveats.get(j);
            for (k = 0; k < c.queries().size(); ++k) {
                res = world.query_rule(c.queries().get(k));
                if (res.isEmpty()) continue;
                successful = true;
                break;
            }
            if (successful) continue;
            FailedCaveat failedCaveat = new FailedCaveat();
            failedCaveat.getClass();
            errors.add(failedCaveat.new FailedCaveat.FailedBlock(i, j, symbols.print_caveat(this.caveats.get(j))));
        }
        for (j = 0; j < verifier_caveats.size(); ++j) {
            successful = false;
            c = verifier_caveats.get(j);
            for (k = 0; k < c.queries().size(); ++k) {
                res = world.query_rule(c.queries().get(k));
                if (res.isEmpty()) continue;
                successful = true;
                break;
            }
            if (successful) continue;
            FailedCaveat failedCaveat = new FailedCaveat();
            failedCaveat.getClass();
            errors.add(failedCaveat.new FailedCaveat.FailedVerifier(j, symbols.print_caveat(verifier_caveats.get(j))));
        }
        for (String name : queries.keySet()) {
            Set<Fact> res2 = world.query_rule(queries.get(name));
            query_results.get(name).put(new Long(this.index), res2);
        }
        if (errors.isEmpty()) {
            return API.Right(null);
        }
        LogicError logicError = new LogicError();
        logicError.getClass();
        return API.Left((Object)logicError.new LogicError.FailedCaveats(errors));
    }

    public String print(SymbolTable symbol_table) {
        StringBuilder s = new StringBuilder();
        s.append("Block[");
        s.append(this.index);
        s.append("] {\n\t\tsymbols: ");
        s.append(this.symbols.symbols);
        s.append("\n\t\tcontext: ");
        s.append(this.context);
        s.append("\n\t\tfacts: [");
        for (Fact f : this.facts) {
            s.append("\n\t\t\t");
            s.append(symbol_table.print_fact(f));
        }
        s.append("\n\t\t]\n\t\trules: [");
        for (Rule r : this.rules) {
            s.append("\n\t\t\t");
            s.append(symbol_table.print_rule(r));
        }
        s.append("\n\t\t]\n\t\tcaveats: [");
        for (Caveat c : this.caveats) {
            s.append("\n\t\t\t");
            s.append(symbol_table.print_caveat(c));
        }
        s.append("\n\t\t]\n\t}");
        return s.toString();
    }

    public Schema.Block serialize() {
        int i;
        Schema.Block.Builder b = Schema.Block.newBuilder().setIndex((int)this.index);
        for (i = 0; i < this.symbols.symbols.size(); ++i) {
            b.addSymbols(this.symbols.symbols.get(i));
        }
        if (!this.context.isEmpty()) {
            b.setContext(this.context);
        }
        for (i = 0; i < this.facts.size(); ++i) {
            b.addFacts(this.facts.get(i).serialize());
        }
        for (i = 0; i < this.rules.size(); ++i) {
            b.addRules(this.rules.get(i).serialize());
        }
        for (i = 0; i < this.caveats.size(); ++i) {
            b.addCaveats(this.caveats.get(i).serialize());
        }
        return b.build();
    }

    public static Either<Error.FormatError, Block> deserialize(Schema.Block b) {
        SymbolTable symbols = new SymbolTable();
        for (Object s : b.getSymbolsList()) {
            symbols.add((String)s);
        }
        ArrayList<Fact> facts = new ArrayList<Fact>();
        for (Schema.Fact fact : b.getFactsList()) {
            Either<Error.FormatError, Fact> res = Fact.deserialize(fact);
            if (res.isLeft()) {
                Error.FormatError e = (Error.FormatError)res.getLeft();
                return API.Left((Object)e);
            }
            facts.add((Fact)res.get());
        }
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (Schema.Rule rule : b.getRulesList()) {
            Either<Error.FormatError, Rule> res = Rule.deserialize(rule);
            if (res.isLeft()) {
                Error.FormatError e = (Error.FormatError)res.getLeft();
                return API.Left((Object)e);
            }
            rules.add((Rule)res.get());
        }
        ArrayList<Caveat> arrayList = new ArrayList<Caveat>();
        for (Schema.Caveat caveat : b.getCaveatsList()) {
            Either<Error.FormatError, Caveat> res = Caveat.deserialize(caveat);
            if (res.isLeft()) {
                Error.FormatError e = (Error.FormatError)res.getLeft();
                return API.Left((Object)e);
            }
            arrayList.add((Caveat)res.get());
        }
        return API.Right((Object)new Block(b.getIndex(), symbols, b.getContext(), facts, rules, arrayList));
    }

    public static Either<Error.FormatError, Block> from_bytes(byte[] slice) {
        try {
            Schema.Block data = Schema.Block.parseFrom(slice);
            return Block.deserialize(data);
        }
        catch (InvalidProtocolBufferException e) {
            Error.FormatError formatError = new Error().new Error.FormatError();
            formatError.getClass();
            return API.Left((Object)formatError.new Error.FormatError.DeserializationError(e.toString()));
        }
    }

    public Either<Error.FormatError, byte[]> to_bytes() {
        Schema.Block b = this.serialize();
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            b.writeTo(stream);
            byte[] data = stream.toByteArray();
            return API.Right((Object)data);
        }
        catch (IOException e) {
            Error.FormatError formatError = new Error().new Error.FormatError();
            formatError.getClass();
            return API.Left((Object)formatError.new Error.FormatError.SerializationError(e.toString()));
        }
    }
}

