/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.datalog.constraints;

import biscuit.format.schema.Schema;
import com.clevercloud.biscuit.error.Error;
import io.vavr.API;
import io.vavr.control.Either;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public abstract class IntConstraint
implements Serializable {
    public abstract boolean check(long var1);

    public abstract Schema.IntConstraint serialize();

    public static Either<Error.FormatError, IntConstraint> deserialize_enum(Schema.IntConstraint c) {
        if (c.getKind() == Schema.IntConstraint.Kind.LOWER) {
            return Lower.deserialize(c);
        }
        if (c.getKind() == Schema.IntConstraint.Kind.LARGER) {
            return Greater.deserialize(c);
        }
        if (c.getKind() == Schema.IntConstraint.Kind.LOWER_OR_EQUAL) {
            return LowerOrEqual.deserialize(c);
        }
        if (c.getKind() == Schema.IntConstraint.Kind.LARGER_OR_EQUAL) {
            return GreaterOrEqual.deserialize(c);
        }
        if (c.getKind() == Schema.IntConstraint.Kind.EQUAL) {
            return Equal.deserialize(c);
        }
        if (c.getKind() == Schema.IntConstraint.Kind.IN) {
            return InSet.deserialize(c);
        }
        if (c.getKind() == Schema.IntConstraint.Kind.NOT_IN) {
            return NotInSet.deserialize(c);
        }
        Error.FormatError formatError = new Error.FormatError(new Error());
        formatError.getClass();
        return API.Left((Object)new Error.FormatError.DeserializationError(formatError, "invalid int constraint kind"));
    }

    public static final class NotInSet
    extends IntConstraint
    implements Serializable {
        private final Set<Long> value;

        @Override
        public boolean check(long value) {
            return !this.value.contains(value);
        }

        public NotInSet(Set<Long> value) {
            this.value = value;
        }

        public String toString() {
            return "not in " + this.value;
        }

        @Override
        public Schema.IntConstraint serialize() {
            Schema.IntConstraint.Builder b = Schema.IntConstraint.newBuilder().setKind(Schema.IntConstraint.Kind.NOT_IN);
            for (Long l : this.value) {
                b.addNotInSet(l);
            }
            return b.build();
        }

        public static Either<Error.FormatError, IntConstraint> deserialize(Schema.IntConstraint i) {
            HashSet<Long> values = new HashSet<Long>();
            for (long l : i.getNotInSetList()) {
                values.add(l);
            }
            if (values.isEmpty()) {
                Error.FormatError formatError = new Error.FormatError(new Error());
                formatError.getClass();
                return API.Left((Object)new Error.FormatError.DeserializationError(formatError, "invalid Int constraint"));
            }
            return API.Right((Object)new NotInSet(values));
        }
    }

    public static final class InSet
    extends IntConstraint
    implements Serializable {
        private final Set<Long> value;

        @Override
        public boolean check(long value) {
            return this.value.contains(value);
        }

        public InSet(Set<Long> value) {
            this.value = value;
        }

        public String toString() {
            return "in " + this.value;
        }

        @Override
        public Schema.IntConstraint serialize() {
            Schema.IntConstraint.Builder b = Schema.IntConstraint.newBuilder().setKind(Schema.IntConstraint.Kind.IN);
            for (Long l : this.value) {
                b.addInSet(l);
            }
            return b.build();
        }

        public static Either<Error.FormatError, IntConstraint> deserialize(Schema.IntConstraint i) {
            HashSet<Long> values = new HashSet<Long>();
            for (long l : i.getInSetList()) {
                values.add(l);
            }
            if (values.isEmpty()) {
                Error.FormatError formatError = new Error.FormatError(new Error());
                formatError.getClass();
                return API.Left((Object)new Error.FormatError.DeserializationError(formatError, "invalid Int constraint"));
            }
            return API.Right((Object)new InSet(values));
        }
    }

    public static final class LowerOrEqual
    extends IntConstraint
    implements Serializable {
        private final long value;

        @Override
        public boolean check(long value) {
            return this.value >= value;
        }

        public LowerOrEqual(long value) {
            this.value = value;
        }

        public String toString() {
            return "<= " + this.value;
        }

        @Override
        public Schema.IntConstraint serialize() {
            return Schema.IntConstraint.newBuilder().setKind(Schema.IntConstraint.Kind.LOWER_OR_EQUAL).setLowerOrEqual(this.value).build();
        }

        public static Either<Error.FormatError, IntConstraint> deserialize(Schema.IntConstraint i) {
            if (!i.hasLowerOrEqual()) {
                Error.FormatError formatError = new Error.FormatError(new Error());
                formatError.getClass();
                return API.Left((Object)new Error.FormatError.DeserializationError(formatError, "invalid Int constraint"));
            }
            return API.Right((Object)new LowerOrEqual(i.getLowerOrEqual()));
        }
    }

    public static final class Lower
    extends IntConstraint
    implements Serializable {
        private final long value;

        @Override
        public boolean check(long value) {
            return this.value > value;
        }

        public Lower(long value) {
            this.value = value;
        }

        public String toString() {
            return "< " + this.value;
        }

        @Override
        public Schema.IntConstraint serialize() {
            return Schema.IntConstraint.newBuilder().setKind(Schema.IntConstraint.Kind.LOWER).setLower(this.value).build();
        }

        public static Either<Error.FormatError, IntConstraint> deserialize(Schema.IntConstraint i) {
            if (!i.hasLower()) {
                Error.FormatError formatError = new Error.FormatError(new Error());
                formatError.getClass();
                return API.Left((Object)new Error.FormatError.DeserializationError(formatError, "invalid Int constraint"));
            }
            return API.Right((Object)new Lower(i.getLower()));
        }
    }

    public static final class GreaterOrEqual
    extends IntConstraint
    implements Serializable {
        private final long value;

        @Override
        public boolean check(long value) {
            return this.value <= value;
        }

        public GreaterOrEqual(long value) {
            this.value = value;
        }

        public String toString() {
            return ">= " + this.value;
        }

        @Override
        public Schema.IntConstraint serialize() {
            return Schema.IntConstraint.newBuilder().setKind(Schema.IntConstraint.Kind.LARGER_OR_EQUAL).setLargerOrEqual(this.value).build();
        }

        public static Either<Error.FormatError, IntConstraint> deserialize(Schema.IntConstraint i) {
            if (!i.hasLargerOrEqual()) {
                Error.FormatError formatError = new Error.FormatError(new Error());
                formatError.getClass();
                return API.Left((Object)new Error.FormatError.DeserializationError(formatError, "invalid Int constraint"));
            }
            return API.Right((Object)new GreaterOrEqual(i.getLargerOrEqual()));
        }
    }

    public static final class Greater
    extends IntConstraint
    implements Serializable {
        private final long value;

        @Override
        public boolean check(long value) {
            return this.value < value;
        }

        public Greater(long value) {
            this.value = value;
        }

        public String toString() {
            return "> " + this.value;
        }

        @Override
        public Schema.IntConstraint serialize() {
            return Schema.IntConstraint.newBuilder().setKind(Schema.IntConstraint.Kind.LARGER).setLarger(this.value).build();
        }

        public static Either<Error.FormatError, IntConstraint> deserialize(Schema.IntConstraint i) {
            if (!i.hasLarger()) {
                Error.FormatError formatError = new Error.FormatError(new Error());
                formatError.getClass();
                return API.Left((Object)new Error.FormatError.DeserializationError(formatError, "invalid Int constraint"));
            }
            return API.Right((Object)new Greater(i.getLarger()));
        }
    }

    public static final class Equal
    extends IntConstraint
    implements Serializable {
        private final long value;

        @Override
        public boolean check(long value) {
            return this.value == value;
        }

        public Equal(long value) {
            this.value = value;
        }

        public String toString() {
            return "== " + this.value;
        }

        @Override
        public Schema.IntConstraint serialize() {
            return Schema.IntConstraint.newBuilder().setKind(Schema.IntConstraint.Kind.EQUAL).setEqual(this.value).build();
        }

        public static Either<Error.FormatError, IntConstraint> deserialize(Schema.IntConstraint i) {
            if (!i.hasEqual()) {
                Error.FormatError formatError = new Error.FormatError(new Error());
                formatError.getClass();
                return API.Left((Object)new Error.FormatError.DeserializationError(formatError, "invalid Int constraint"));
            }
            return API.Right((Object)new Equal(i.getEqual()));
        }
    }
}

