/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.datalog;

import com.clevercloud.biscuit.datalog.Caveat;
import com.clevercloud.biscuit.datalog.Fact;
import com.clevercloud.biscuit.datalog.ID;
import com.clevercloud.biscuit.datalog.Predicate;
import com.clevercloud.biscuit.datalog.Rule;
import com.clevercloud.biscuit.datalog.World;
import io.vavr.control.Option;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class SymbolTable
implements Serializable {
    public final List<String> symbols = new ArrayList<String>();

    public long insert(String symbol) {
        int index = this.symbols.indexOf(symbol);
        if (index == -1) {
            this.symbols.add(symbol);
            return this.symbols.size() - 1;
        }
        return index;
    }

    public ID add(String symbol) {
        return new ID.Symbol(this.insert(symbol));
    }

    public Option<Long> get(String symbol) {
        long index = this.symbols.indexOf(symbol);
        if (index == -1L) {
            return Option.none();
        }
        return Option.some((Object)index);
    }

    public String print_rule(Rule r) {
        String res = "*" + this.print_predicate(r.head());
        List preds = r.body().stream().map(p -> "!" + this.print_predicate((Predicate)p)).collect(Collectors.toList());
        List constraints = r.constraints().stream().map(c -> c.toString()).collect(Collectors.toList());
        res = res + " <- " + String.join((CharSequence)", ", preds);
        if (!constraints.isEmpty()) {
            res = res + " @ " + String.join((CharSequence)", ", constraints);
        }
        return res;
    }

    public String print_predicate(Predicate p) {
        List ids = p.ids().stream().map(i -> {
            if (i instanceof ID.Variable) {
                return "$" + ((ID.Variable)i).value();
            }
            if (i instanceof ID.Symbol) {
                return "#" + this.symbols.get((int)((ID.Symbol)i).value());
            }
            if (i instanceof ID.Date) {
                return Date.from(Instant.ofEpochSecond(((ID.Date)i).value())).toString();
            }
            if (i instanceof ID.Integer) {
                return "" + ((ID.Integer)i).value();
            }
            if (i instanceof ID.Str) {
                return "\"" + ((ID.Str)i).value() + "\"";
            }
            return "???";
        }).collect(Collectors.toList());
        return Optional.ofNullable(this.symbols.get((int)p.name())).orElse("<?>") + "(" + String.join((CharSequence)", ", ids) + ")";
    }

    public String print_fact(Fact f) {
        return "!" + this.print_predicate(f.predicate());
    }

    public String print_caveat(Caveat c) {
        List queries = c.queries().stream().map(q -> this.print_rule((Rule)q)).collect(Collectors.toList());
        return String.join((CharSequence)" || ", queries);
    }

    public String print_world(World w) {
        List facts = w.facts().stream().map(f -> this.print_fact((Fact)f)).collect(Collectors.toList());
        List rules = w.rules().stream().map(r -> this.print_rule((Rule)r)).collect(Collectors.toList());
        StringBuilder b = new StringBuilder();
        b.append("World {\n\tfacts: [");
        b.append(String.join((CharSequence)",\n\t\t", facts));
        b.append("\n\t],\n\trules: [");
        b.append(String.join((CharSequence)",\n\t\t", rules));
        b.append("\n\t]\n}");
        return b.toString();
    }

    public String print_symbol(int i) {
        return this.symbols.get(i);
    }

    public SymbolTable() {
    }

    public SymbolTable(SymbolTable s) {
        for (String symbol : s.symbols) {
            this.symbols.add(symbol);
        }
    }
}

