/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.datalog.constraints;

import biscuit.format.schema.Schema;
import com.clevercloud.biscuit.error.Error;
import io.vavr.API;
import io.vavr.control.Either;
import java.io.Serializable;

public abstract class DateConstraint
implements Serializable {
    public abstract boolean check(long var1);

    public abstract Schema.DateConstraint serialize();

    public static Either<Error.FormatError, DateConstraint> deserialize_enum(Schema.DateConstraint c) {
        if (c.getKind() == Schema.DateConstraint.Kind.BEFORE) {
            return Before.deserialize(c);
        }
        if (c.getKind() == Schema.DateConstraint.Kind.AFTER) {
            return After.deserialize(c);
        }
        Error.FormatError formatError = new Error.FormatError(new Error());
        formatError.getClass();
        return API.Left((Object)new Error.FormatError.DeserializationError(formatError, "invalid date constraint kind"));
    }

    public static final class After
    extends DateConstraint
    implements Serializable {
        private final long value;

        @Override
        public boolean check(long value) {
            return this.value <= value;
        }

        public After(long value) {
            this.value = value;
        }

        public String toString() {
            return ">= " + this.value;
        }

        @Override
        public Schema.DateConstraint serialize() {
            return Schema.DateConstraint.newBuilder().setKind(Schema.DateConstraint.Kind.AFTER).setAfter(this.value).build();
        }

        public static Either<Error.FormatError, DateConstraint> deserialize(Schema.DateConstraint i) {
            if (!i.hasAfter()) {
                Error.FormatError formatError = new Error.FormatError(new Error());
                formatError.getClass();
                return API.Left((Object)new Error.FormatError.DeserializationError(formatError, "invalid Date constraint"));
            }
            return API.Right((Object)new After(i.getAfter()));
        }
    }

    public static final class Before
    extends DateConstraint
    implements Serializable {
        private final long value;

        @Override
        public boolean check(long value) {
            return this.value >= value;
        }

        public Before(long value) {
            this.value = value;
        }

        public String toString() {
            return "<= " + this.value;
        }

        @Override
        public Schema.DateConstraint serialize() {
            return Schema.DateConstraint.newBuilder().setKind(Schema.DateConstraint.Kind.BEFORE).setBefore(this.value).build();
        }

        public static Either<Error.FormatError, DateConstraint> deserialize(Schema.DateConstraint i) {
            if (!i.hasBefore()) {
                Error.FormatError formatError = new Error.FormatError(new Error());
                formatError.getClass();
                return API.Left((Object)new Error.FormatError.DeserializationError(formatError, "invalid Date constraint"));
            }
            return API.Right((Object)new Before(i.getBefore()));
        }
    }
}

