/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.token.builder;

import com.clevercloud.biscuit.datalog.constraints.Constraint;
import com.clevercloud.biscuit.token.builder.Atom;
import com.clevercloud.biscuit.token.builder.Caveat;
import com.clevercloud.biscuit.token.builder.Fact;
import com.clevercloud.biscuit.token.builder.Predicate;
import com.clevercloud.biscuit.token.builder.Rule;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Utils {
    public static Fact fact(String name, List<Atom> ids) {
        return new Fact(name, ids);
    }

    public static Predicate pred(String name, List<Atom> ids) {
        return new Predicate(name, ids);
    }

    public static Rule rule(String head_name, List<Atom> head_ids, List<Predicate> predicates) {
        return new Rule(Utils.pred(head_name, head_ids), predicates, new ArrayList<Constraint>());
    }

    public static Rule constrained_rule(String head_name, List<Atom> head_ids, List<Predicate> predicates, List<Constraint> constraints) {
        return new Rule(Utils.pred(head_name, head_ids), predicates, constraints);
    }

    public static Caveat caveat(Rule rule) {
        return new Caveat(rule);
    }

    public static Atom integer(long i) {
        return new Atom.Integer(i);
    }

    public static Atom string(String s) {
        return new Atom.Str(s);
    }

    public static Atom s(String str) {
        return new Atom.Symbol(str);
    }

    public static Atom date(Date d) {
        return new Atom.Date(d.getTime() / 1000L);
    }

    public static Atom var(int i) {
        return new Atom.Variable(i);
    }
}

