/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.datalog.constraints;

import biscuit.format.schema.Schema;
import com.clevercloud.biscuit.error.Error;
import io.vavr.API;
import io.vavr.control.Either;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class StrConstraint
implements Serializable {
    public abstract boolean check(String var1);

    public abstract Schema.StringConstraint serialize();

    public static Either<Error.FormatError, StrConstraint> deserialize_enum(Schema.StringConstraint c) {
        if (c.getKind() == Schema.StringConstraint.Kind.PREFIX) {
            return Prefix.deserialize(c);
        }
        if (c.getKind() == Schema.StringConstraint.Kind.SUFFIX) {
            return Suffix.deserialize(c);
        }
        if (c.getKind() == Schema.StringConstraint.Kind.EQUAL) {
            return Equal.deserialize(c);
        }
        if (c.getKind() == Schema.StringConstraint.Kind.REGEX) {
            return Regex.deserialize(c);
        }
        if (c.getKind() == Schema.StringConstraint.Kind.IN) {
            return InSet.deserialize(c);
        }
        if (c.getKind() == Schema.StringConstraint.Kind.NOT_IN) {
            return NotInSet.deserialize(c);
        }
        Error.FormatError formatError = new Error.FormatError(new Error());
        formatError.getClass();
        return API.Left((Object)new Error.FormatError.DeserializationError(formatError, "invalid String constraint kind"));
    }

    public static final class NotInSet
    extends StrConstraint
    implements Serializable {
        private final Set<String> value;

        @Override
        public boolean check(String value) {
            return !this.value.contains(value);
        }

        public NotInSet(Set<String> value) {
            this.value = value;
        }

        public String toString() {
            return "not in " + this.value;
        }

        @Override
        public Schema.StringConstraint serialize() {
            Schema.StringConstraint.Builder b = Schema.StringConstraint.newBuilder().setKind(Schema.StringConstraint.Kind.NOT_IN);
            for (String s : this.value) {
                b.addNotInSet(s);
            }
            return b.build();
        }

        public static Either<Error.FormatError, StrConstraint> deserialize(Schema.StringConstraint i) {
            HashSet<String> values = new HashSet<String>();
            for (String l : i.getNotInSetList()) {
                values.add(l);
            }
            if (values.isEmpty()) {
                Error.FormatError formatError = new Error.FormatError(new Error());
                formatError.getClass();
                return API.Left((Object)new Error.FormatError.DeserializationError(formatError, "invalid String constraint"));
            }
            return API.Right((Object)new NotInSet(values));
        }
    }

    public static final class InSet
    extends StrConstraint
    implements Serializable {
        private final Set<String> value;

        @Override
        public boolean check(String value) {
            return this.value.contains(value);
        }

        public InSet(Set<String> value) {
            this.value = value;
        }

        public String toString() {
            return "in " + this.value;
        }

        @Override
        public Schema.StringConstraint serialize() {
            Schema.StringConstraint.Builder b = Schema.StringConstraint.newBuilder().setKind(Schema.StringConstraint.Kind.IN);
            for (String s : this.value) {
                b.addInSet(s);
            }
            return b.build();
        }

        public static Either<Error.FormatError, StrConstraint> deserialize(Schema.StringConstraint i) {
            HashSet<String> values = new HashSet<String>();
            for (String l : i.getInSetList()) {
                values.add(l);
            }
            if (values.isEmpty()) {
                Error.FormatError formatError = new Error.FormatError(new Error());
                formatError.getClass();
                return API.Left((Object)new Error.FormatError.DeserializationError(formatError, "invalid String constraint"));
            }
            return API.Right((Object)new InSet(values));
        }
    }

    public static final class Regex
    extends StrConstraint
    implements Serializable {
        private final String pattern;

        @Override
        public boolean check(String value) {
            Pattern p = Pattern.compile(this.pattern);
            Matcher m = p.matcher(value);
            return m.matches();
        }

        public Regex(String value) {
            this.pattern = value;
        }

        public String toString() {
            return "matches /" + this.pattern + "/";
        }

        @Override
        public Schema.StringConstraint serialize() {
            return Schema.StringConstraint.newBuilder().setKind(Schema.StringConstraint.Kind.REGEX).setRegex(this.pattern).build();
        }

        public static Either<Error.FormatError, StrConstraint> deserialize(Schema.StringConstraint i) {
            if (!i.hasRegex()) {
                Error.FormatError formatError = new Error.FormatError(new Error());
                formatError.getClass();
                return API.Left((Object)new Error.FormatError.DeserializationError(formatError, "invalid String constraint"));
            }
            return API.Right((Object)new Regex(i.getRegex()));
        }
    }

    public static final class Equal
    extends StrConstraint
    implements Serializable {
        private final String value;

        @Override
        public boolean check(String value) {
            return this.value.equals(value);
        }

        public Equal(String value) {
            this.value = value;
        }

        public String toString() {
            return "== " + this.value;
        }

        @Override
        public Schema.StringConstraint serialize() {
            return Schema.StringConstraint.newBuilder().setKind(Schema.StringConstraint.Kind.EQUAL).setEqual(this.value).build();
        }

        public static Either<Error.FormatError, StrConstraint> deserialize(Schema.StringConstraint i) {
            if (!i.hasEqual()) {
                Error.FormatError formatError = new Error.FormatError(new Error());
                formatError.getClass();
                return API.Left((Object)new Error.FormatError.DeserializationError(formatError, "invalid String constraint"));
            }
            return API.Right((Object)new Equal(i.getEqual()));
        }
    }

    public static final class Suffix
    extends StrConstraint
    implements Serializable {
        private final String value;

        @Override
        public boolean check(String value) {
            return value.endsWith(this.value);
        }

        public Suffix(String value) {
            this.value = value;
        }

        public String toString() {
            return "matches *" + this.value;
        }

        @Override
        public Schema.StringConstraint serialize() {
            return Schema.StringConstraint.newBuilder().setKind(Schema.StringConstraint.Kind.SUFFIX).setSuffix(this.value).build();
        }

        public static Either<Error.FormatError, StrConstraint> deserialize(Schema.StringConstraint i) {
            if (!i.hasSuffix()) {
                Error.FormatError formatError = new Error.FormatError(new Error());
                formatError.getClass();
                return API.Left((Object)new Error.FormatError.DeserializationError(formatError, "invalid String constraint"));
            }
            return API.Right((Object)new Suffix(i.getSuffix()));
        }
    }

    public static final class Prefix
    extends StrConstraint
    implements Serializable {
        private final String value;

        @Override
        public boolean check(String value) {
            return value.startsWith(this.value);
        }

        public Prefix(String value) {
            this.value = value;
        }

        public String toString() {
            return "matches " + this.value + "*";
        }

        @Override
        public Schema.StringConstraint serialize() {
            return Schema.StringConstraint.newBuilder().setKind(Schema.StringConstraint.Kind.PREFIX).setPrefix(this.value).build();
        }

        public static Either<Error.FormatError, StrConstraint> deserialize(Schema.StringConstraint i) {
            if (!i.hasPrefix()) {
                Error.FormatError formatError = new Error.FormatError(new Error());
                formatError.getClass();
                return API.Left((Object)new Error.FormatError.DeserializationError(formatError, "invalid String constraint"));
            }
            return API.Right((Object)new Prefix(i.getPrefix()));
        }
    }
}

