/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.token.builder.constraints;

import com.clevercloud.biscuit.datalog.SymbolTable;
import com.clevercloud.biscuit.datalog.constraints.Constraint;
import com.clevercloud.biscuit.datalog.constraints.ConstraintKind;
import com.clevercloud.biscuit.datalog.constraints.StrConstraint;
import com.clevercloud.biscuit.token.builder.constraints.ConstraintBuilder;
import java.util.Set;

public abstract class StrConstraint
implements ConstraintBuilder {
    @Override
    public abstract Constraint convert(SymbolTable var1);

    public static class NotInSet
    extends StrConstraint {
        long id;
        Set<String> value;

        public NotInSet(long id, Set<String> value) {
            this.id = id;
            this.value = value;
        }

        @Override
        public Constraint convert(SymbolTable symbols) {
            return new Constraint(this.id, new ConstraintKind.Str(new StrConstraint.NotInSet(this.value)));
        }

        public String toString() {
            return "not in " + this.value;
        }
    }

    public static class InSet
    extends StrConstraint {
        long id;
        Set<String> value;

        public InSet(long id, Set<String> value) {
            this.id = id;
            this.value = value;
        }

        @Override
        public Constraint convert(SymbolTable symbols) {
            return new Constraint(this.id, new ConstraintKind.Str(new StrConstraint.InSet(this.value)));
        }

        public String toString() {
            return "in " + this.value;
        }
    }

    public static class Regex
    extends StrConstraint {
        long id;
        String pattern;

        public Regex(long id, String pattern) {
            this.id = id;
            this.pattern = pattern;
        }

        @Override
        public Constraint convert(SymbolTable symbols) {
            return new Constraint(this.id, new ConstraintKind.Str(new StrConstraint.Regex(this.pattern)));
        }

        public String toString() {
            return "matches /" + this.pattern + "/";
        }
    }

    public static class Equal
    extends StrConstraint {
        long id;
        String value;

        public Equal(long id, String value) {
            this.id = id;
            this.value = value;
        }

        @Override
        public Constraint convert(SymbolTable symbols) {
            return new Constraint(this.id, new ConstraintKind.Str(new StrConstraint.Equal(this.value)));
        }

        public String toString() {
            return "== " + this.value;
        }
    }

    public static class Suffix
    extends StrConstraint {
        long id;
        String value;

        public Suffix(long id, String value) {
            this.id = id;
            this.value = value;
        }

        @Override
        public Constraint convert(SymbolTable symbols) {
            return new Constraint(this.id, new ConstraintKind.Str(new StrConstraint.Suffix(this.value)));
        }

        public String toString() {
            return "matches *" + this.value;
        }
    }

    public static class Prefix
    extends StrConstraint {
        long id;
        String value;

        public Prefix(long id, String value) {
            this.id = id;
            this.value = value;
        }

        @Override
        public Constraint convert(SymbolTable symbols) {
            return new Constraint(this.id, new ConstraintKind.Str(new StrConstraint.Prefix(this.value)));
        }

        public String toString() {
            return "matches " + this.value + "*";
        }
    }
}

