/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.token.format;

import biscuit.format.schema.Schema;
import cafe.cryptography.curve25519.CompressedRistretto;
import cafe.cryptography.curve25519.InvalidEncodingException;
import cafe.cryptography.curve25519.RistrettoElement;
import com.clevercloud.biscuit.crypto.KeyPair;
import com.clevercloud.biscuit.crypto.PublicKey;
import com.clevercloud.biscuit.crypto.TokenSignature;
import com.clevercloud.biscuit.error.Error;
import com.clevercloud.biscuit.token.Block;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import io.vavr.API;
import io.vavr.control.Either;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;

public class SerializedBiscuit {
    public byte[] authority;
    public List<byte[]> blocks;
    public List<RistrettoElement> keys;
    public TokenSignature signature;

    public static Either<Error, SerializedBiscuit> from_bytes(byte[] slice) {
        try {
            Schema.Biscuit data = Schema.Biscuit.parseFrom(slice);
            ArrayList<RistrettoElement> keys = new ArrayList<RistrettoElement>();
            for (ByteString key : data.getKeysList()) {
                keys.add(new CompressedRistretto(key.toByteArray()).decompress());
            }
            byte[] authority = data.getAuthority().toByteArray();
            ArrayList<byte[]> blocks = new ArrayList<byte[]>();
            for (ByteString block : data.getBlocksList()) {
                blocks.add(block.toByteArray());
            }
            Either<Error, TokenSignature> signatureRes = TokenSignature.deserialize(data.getSignature());
            if (signatureRes.isLeft()) {
                Error e = (Error)signatureRes.getLeft();
                return API.Left((Object)e);
            }
            TokenSignature signature = (TokenSignature)signatureRes.get();
            SerializedBiscuit b = new SerializedBiscuit(authority, blocks, keys, signature);
            Either<Error, Void> res = b.verify();
            if (res.isLeft()) {
                Error e = (Error)res.getLeft();
                return API.Left((Object)e);
            }
            return API.Right((Object)b);
        }
        catch (InvalidProtocolBufferException e) {
            Error.FormatError formatError = new Error.FormatError(new Error());
            formatError.getClass();
            return API.Left((Object)new Error.FormatError.DeserializationError(formatError, e.toString()));
        }
        catch (InvalidEncodingException e) {
            Error.FormatError formatError = new Error.FormatError(new Error());
            formatError.getClass();
            return API.Left((Object)new Error.FormatError.DeserializationError(formatError, e.toString()));
        }
    }

    public Either<Error, byte[]> serialize() {
        int i;
        Schema.Biscuit.Builder b = Schema.Biscuit.newBuilder().setSignature(this.signature.serialize());
        for (i = 0; i < this.keys.size(); ++i) {
            b.addKeys(ByteString.copyFrom((byte[])this.keys.get(i).compress().toByteArray()));
        }
        b.setAuthority(ByteString.copyFrom((byte[])this.authority));
        for (i = 0; i < this.blocks.size(); ++i) {
            b.addBlocks(ByteString.copyFrom((byte[])this.blocks.get(i)));
        }
        Schema.Biscuit biscuit = b.build();
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            biscuit.writeTo(stream);
            byte[] data = stream.toByteArray();
            return API.Right((Object)data);
        }
        catch (IOException e) {
            Error.FormatError formatError = new Error.FormatError(new Error());
            formatError.getClass();
            return API.Left((Object)new Error.FormatError.SerializationError(formatError, e.toString()));
        }
    }

    public static Either<Error.FormatError, SerializedBiscuit> make(SecureRandom rng, KeyPair root, Block authority) {
        Schema.Block b = authority.serialize();
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            b.writeTo(stream);
            byte[] data = stream.toByteArray();
            TokenSignature signature = new TokenSignature(rng, root, data);
            ArrayList<RistrettoElement> keys = new ArrayList<RistrettoElement>();
            keys.add(root.public_key);
            return API.Right((Object)new SerializedBiscuit(data, new ArrayList<byte[]>(), keys, signature));
        }
        catch (IOException e) {
            Error.FormatError formatError = new Error.FormatError(new Error());
            formatError.getClass();
            return API.Left((Object)new Error.FormatError.SerializationError(formatError, e.toString()));
        }
    }

    public Either<Error.FormatError, SerializedBiscuit> append(SecureRandom rng, KeyPair keypair, Block block) {
        Schema.Block b = block.serialize();
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            b.writeTo(stream);
            byte[] data = stream.toByteArray();
            TokenSignature signature = this.signature.sign(rng, keypair, data);
            ArrayList<RistrettoElement> keys = new ArrayList<RistrettoElement>();
            for (RistrettoElement key : this.keys) {
                keys.add(key);
            }
            keys.add(keypair.public_key);
            ArrayList<byte[]> blocks = new ArrayList<byte[]>();
            for (byte[] bl : this.blocks) {
                blocks.add(bl);
            }
            blocks.add(data);
            return API.Right((Object)new SerializedBiscuit(this.authority, blocks, keys, signature));
        }
        catch (IOException e) {
            Error.FormatError formatError = new Error.FormatError(new Error());
            formatError.getClass();
            return API.Left((Object)new Error.FormatError.SerializationError(formatError, e.toString()));
        }
    }

    public Either<Error, Void> verify() {
        if (this.keys.isEmpty()) {
            return API.Left((Object)new Error.FormatError.EmptyKeys(new Error.FormatError(new Error())));
        }
        ArrayList<byte[]> blocks = new ArrayList<byte[]>();
        blocks.add(this.authority);
        for (byte[] bl : this.blocks) {
            blocks.add(bl);
        }
        return this.signature.verify(this.keys, blocks);
    }

    public Either<Error, Void> check_root_key(PublicKey public_key) {
        if (this.keys.isEmpty()) {
            return API.Left((Object)new Error.FormatError.EmptyKeys(new Error.FormatError(new Error())));
        }
        if (this.keys.get(0).ctEquals(public_key.key) != 1) {
            return API.Left((Object)new Error.FormatError.UnknownPublicKey(new Error.FormatError(new Error())));
        }
        return API.Right(null);
    }

    SerializedBiscuit(byte[] authority, List<byte[]> blocks, List<RistrettoElement> keys, TokenSignature signature) {
        this.authority = authority;
        this.blocks = blocks;
        this.keys = keys;
        this.signature = signature;
    }
}

