/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.token.builder;

import com.clevercloud.biscuit.crypto.KeyPair;
import com.clevercloud.biscuit.datalog.SymbolTable;
import com.clevercloud.biscuit.error.Error;
import com.clevercloud.biscuit.token.Block;
import com.clevercloud.biscuit.token.builder.Caveat;
import com.clevercloud.biscuit.token.builder.Fact;
import com.clevercloud.biscuit.token.builder.Rule;
import com.clevercloud.biscuit.token.builder.Term;
import com.clevercloud.biscuit.token.builder.Utils;
import io.vavr.control.Either;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Biscuit {
    SecureRandom rng;
    KeyPair root;
    int symbol_start;
    SymbolTable symbols;
    String context;
    List<com.clevercloud.biscuit.datalog.Fact> facts;
    List<com.clevercloud.biscuit.datalog.Rule> rules;
    List<com.clevercloud.biscuit.datalog.Caveat> caveats;

    public Biscuit(SecureRandom rng, KeyPair root, SymbolTable base_symbols) {
        this.rng = rng;
        this.root = root;
        this.symbol_start = base_symbols.symbols.size();
        this.symbols = new SymbolTable(base_symbols);
        this.context = "";
        this.facts = new ArrayList<com.clevercloud.biscuit.datalog.Fact>();
        this.rules = new ArrayList<com.clevercloud.biscuit.datalog.Rule>();
        this.caveats = new ArrayList<com.clevercloud.biscuit.datalog.Caveat>();
    }

    public void add_authority_fact(Fact f) {
        Term.Symbol authority_symbol = new Term.Symbol("authority");
        if (f.predicate.ids.isEmpty() || !f.predicate.ids.get(0).equals(authority_symbol)) {
            ArrayList<Term> ids = new ArrayList<Term>();
            ids.add(authority_symbol);
            for (Term id : f.predicate.ids) {
                ids.add(id);
            }
            f.predicate.ids = ids;
        }
        this.facts.add(f.convert(this.symbols));
    }

    public void add_authority_rule(Rule rule) {
        Term.Symbol authority_symbol = new Term.Symbol("authority");
        if (rule.head.ids.isEmpty() || !rule.head.ids.get(0).equals(authority_symbol)) {
            rule.head.ids.add(0, authority_symbol);
        }
        this.rules.add(rule.convert(this.symbols));
    }

    public void add_authority_caveat(Caveat c) {
        this.caveats.add(c.convert(this.symbols));
    }

    public void set_context(String context) {
        this.context = context;
    }

    public Either<Error, com.clevercloud.biscuit.token.Biscuit> build() {
        int i;
        SymbolTable base_symbols = new SymbolTable();
        SymbolTable symbols = new SymbolTable();
        for (i = 0; i < this.symbol_start; ++i) {
            base_symbols.add(this.symbols.symbols.get(i));
        }
        for (i = this.symbol_start; i < this.symbols.symbols.size(); ++i) {
            symbols.add(this.symbols.symbols.get(i));
        }
        Block authority_block = new Block(0L, symbols, this.context, this.facts, this.rules, this.caveats);
        return com.clevercloud.biscuit.token.Biscuit.make(this.rng, this.root, base_symbols, authority_block);
    }

    public void add_right(String resource, String right) {
        this.add_authority_fact(Utils.fact("right", Arrays.asList(Utils.s("authority"), Utils.string(resource), Utils.s(right))));
    }
}

