/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.token.builder.parser;

import com.clevercloud.biscuit.token.builder.Caveat;
import com.clevercloud.biscuit.token.builder.Fact;
import com.clevercloud.biscuit.token.builder.Predicate;
import com.clevercloud.biscuit.token.builder.Rule;
import com.clevercloud.biscuit.token.builder.Term;
import com.clevercloud.biscuit.token.builder.Utils;
import com.clevercloud.biscuit.token.builder.constraints.ConstraintBuilder;
import com.clevercloud.biscuit.token.builder.parser.Error;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;

public class Parser {
    public static Either<Error, Tuple2<String, Fact>> fact(String s) {
        Either<Error, Tuple2<String, Predicate>> res = Parser.predicate(s);
        if (res.isLeft()) {
            return Either.left((Object)res.getLeft());
        }
        Tuple2 t = (Tuple2)res.get();
        return Either.right((Object)new Tuple2(t._1, (Object)new Fact((Predicate)t._2)));
    }

    public static Either<Error, Tuple2<String, Rule>> rule(String s) {
        Either<Error, Tuple2<String, Predicate>> res0 = Parser.predicate(s.substring(1));
        if (res0.isLeft()) {
            return Either.left((Object)res0.getLeft());
        }
        Tuple2 t0 = (Tuple2)res0.get();
        s = (String)t0._1;
        Predicate head = (Predicate)t0._2;
        int index2 = s.length();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
            index2 = i;
            break;
        }
        if (index2 == s.length() || s.charAt(index2) != '<' || s.charAt(index2 + 1) != '-') {
            return Either.left((Object)new Error(s, "rule arrow not found"));
        }
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        s = s.substring(index2 + 2);
        while (true) {
            Either<Error, Tuple2<String, Predicate>> res;
            int index_loop = s.length();
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
                index_loop = i;
                break;
            }
            if ((res = Parser.predicate(s = s.substring(index_loop))).isLeft()) break;
            Tuple2 t = (Tuple2)res.get();
            s = (String)t._1;
            predicates.add((Predicate)t._2);
            index_loop = s.length();
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
                index_loop = i;
                break;
            }
            if (index_loop == s.length() || s.charAt(index_loop) != ',') {
                s = s.substring(index_loop);
                break;
            }
            s = s.substring(index_loop + 1);
        }
        return Either.right((Object)new Tuple2((Object)s, (Object)Utils.rule(head.getName(), head.getIds(), predicates)));
    }

    public static Either<Error, Tuple2<String, Caveat>> caveat(String s) {
        return Either.left((Object)new Error(s, "unimplemented"));
    }

    public static Either<Error, Tuple2<String, Predicate>> predicate(String s) {
        int index = s.length();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isAlphabetic(c) || c == '_') continue;
            if (i == 0) {
                return Either.left((Object)new Error(s, "empty name"));
            }
            index = i;
            break;
        }
        if (index == s.length()) {
            return Either.left((Object)new Error(s, "end of name not found"));
        }
        String name = s.substring(0, index);
        int index2 = s.length();
        for (int i = index; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
            index2 = i;
            break;
        }
        if (index2 == s.length() || s.charAt(index2) != '(') {
            return Either.left((Object)new Error(s, "opening parens not found"));
        }
        ArrayList<Term> terms = new ArrayList<Term>();
        s = s.substring(index2 + 1);
        while (true) {
            Either<Error, Tuple2<String, Term>> res;
            int index_loop = s.length();
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
                index_loop = i;
                break;
            }
            if ((res = Parser.atom(s = s.substring(index_loop))).isLeft()) break;
            Tuple2 t = (Tuple2)res.get();
            s = (String)t._1;
            terms.add((Term)t._2);
            index_loop = s.length();
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
                index_loop = i;
                break;
            }
            if (s.charAt(index_loop) != ',') {
                s = s.substring(index_loop);
                break;
            }
            s = s.substring(index_loop + 1);
        }
        index = s.length();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
            index = i;
            break;
        }
        if (index == s.length() || s.charAt(index) != ')') {
            return Either.left((Object)new Error(s, "closing parens not found"));
        }
        String remaining = s.substring(index + 1);
        return Either.right((Object)new Tuple2((Object)remaining, (Object)new Predicate(name, terms)));
    }

    public static Either<Error, Tuple2<String, String>> name(String s) {
        int index = s.length();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isAlphabetic(c) || c == '_') continue;
            index = i;
            break;
        }
        if (index == 0) {
            return Either.left((Object)new Error(s, "empty name"));
        }
        String name = s.substring(0, index);
        String remaining = s.substring(index);
        return Either.right((Object)new Tuple2((Object)remaining, (Object)name));
    }

    public static Either<Error, Tuple2<String, Term>> atom(String s) {
        Either<Error, Tuple2<String, Term.Symbol>> res1 = Parser.symbol(s);
        if (res1.isRight()) {
            Tuple2 t = (Tuple2)res1.get();
            return Either.right((Object)new Tuple2(t._1, t._2));
        }
        Either<Error, Tuple2<String, Term.Str>> res2 = Parser.string(s);
        if (res2.isRight()) {
            Tuple2 t = (Tuple2)res2.get();
            return Either.right((Object)new Tuple2(t._1, t._2));
        }
        Either<Error, Tuple2<String, Term.Integer>> res3 = Parser.integer(s);
        if (res3.isRight()) {
            Tuple2 t = (Tuple2)res3.get();
            return Either.right((Object)new Tuple2(t._1, t._2));
        }
        Either<Error, Tuple2<String, Term.Date>> res4 = Parser.date(s);
        if (res4.isRight()) {
            Tuple2 t = (Tuple2)res4.get();
            return Either.right((Object)new Tuple2(t._1, t._2));
        }
        Either<Error, Tuple2<String, Term.Variable>> res5 = Parser.variable(s);
        if (res5.isRight()) {
            Tuple2 t = (Tuple2)res5.get();
            return Either.right((Object)new Tuple2(t._1, t._2));
        }
        return Either.left((Object)new Error(s, "unrecognized value"));
    }

    public static Either<Error, Tuple2<String, Term.Symbol>> symbol(String s) {
        if (s.charAt(0) != '#') {
            return Either.left((Object)new Error(s, "not a symbol"));
        }
        int index = s.length();
        for (int i = 1; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isAlphabetic(c) && c != '_') continue;
            index = i;
            break;
        }
        if (index == 1) {
            return Either.left((Object)new Error(s, "empty symbol"));
        }
        String name = s.substring(1, index);
        String remaining = s.substring(index);
        return Either.right((Object)new Tuple2((Object)remaining, (Object)((Term.Symbol)Utils.s(name))));
    }

    public static Either<Error, Tuple2<String, Term.Str>> string(String s) {
        if (s.charAt(0) != '\"') {
            return Either.left((Object)new Error(s, "not a string"));
        }
        int index = s.length();
        for (int i = 1; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' && s.charAt(i + 1) == '\"') {
                ++i;
                continue;
            }
            if (c != '\"') continue;
            index = i - 1;
            break;
        }
        if (index == s.length()) {
            return Either.left((Object)new Error(s, "end of string not found"));
        }
        if (s.charAt(index + 1) != '\"') {
            return Either.left((Object)new Error(s, "ending double quote not found"));
        }
        String string = s.substring(1, index + 1);
        String remaining = s.substring(index + 2);
        return Either.right((Object)new Tuple2((Object)remaining, (Object)((Term.Str)Utils.string(string))));
    }

    public static Either<Error, Tuple2<String, Term.Integer>> integer(String s) {
        int index = 0;
        if (s.charAt(0) == '-') {
            ++index;
        }
        int index2 = s.length();
        for (int i = index; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isDigit(c)) continue;
            index2 = i;
            break;
        }
        if (index2 == 0) {
            return Either.left((Object)new Error(s, "not an integer"));
        }
        Integer i = Integer.parseInt(s.substring(0, index2));
        String remaining = s.substring(index2);
        return Either.right((Object)new Tuple2((Object)remaining, (Object)((Term.Integer)Utils.integer(i.intValue()))));
    }

    public static Either<Error, Tuple2<String, Term.Date>> date(String s) {
        int index = s.length();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != ' ' && c != ',' && c != ')') continue;
            index = i;
            break;
        }
        try {
            Instant i = Instant.parse(s.substring(0, index));
            String remaining = s.substring(index);
            return Either.right((Object)new Tuple2((Object)remaining, (Object)new Term.Date(i.getEpochSecond())));
        }
        catch (DateTimeParseException e) {
            return Either.left((Object)new Error(s, "not a date"));
        }
    }

    public static Either<Error, Tuple2<String, Term.Variable>> variable(String s) {
        if (s.charAt(0) != '$') {
            return Either.left((Object)new Error(s, "not a variable"));
        }
        int index = s.length();
        for (int i = 1; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isAlphabetic(c) || Character.isDigit(c) || c == '_') continue;
            index = i;
            break;
        }
        String name = s.substring(1, index);
        String remaining = s.substring(index);
        return Either.right((Object)new Tuple2((Object)remaining, (Object)((Term.Variable)Utils.var(name))));
    }

    public static Either<Error, Tuple2<String, ConstraintBuilder>> constraint(String s) {
        return Either.left((Object)new Error(s, "unimplemented"));
    }
}

