/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.datalog.expressions;

import biscuit.format.schema.Schema;
import com.clevercloud.biscuit.datalog.ID;
import com.clevercloud.biscuit.datalog.SymbolTable;
import com.clevercloud.biscuit.datalog.expressions.Op;
import com.clevercloud.biscuit.error.Error;
import io.vavr.API;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Map;

public class Expression {
    private final ArrayList<Op> ops;

    public Expression(ArrayList<Op> ops) {
        this.ops = ops;
    }

    public ArrayList<Op> getOps() {
        return this.ops;
    }

    public Option<ID> evaluate(Map<Long, ID> variables) {
        ArrayDeque<ID> stack = new ArrayDeque<ID>(16);
        for (Op op : this.ops) {
            if (op.evaluate(stack, variables)) continue;
            return Option.none();
        }
        if (stack.size() == 1) {
            return Option.some((Object)((ID)stack.pop()));
        }
        return Option.none();
    }

    public Option<String> print(SymbolTable symbols) {
        ArrayDeque<String> stack = new ArrayDeque<String>();
        for (Op op : this.ops) {
            op.print(stack, symbols);
        }
        if (stack.size() == 1) {
            return Option.some((Object)((String)stack.remove()));
        }
        return Option.none();
    }

    public Schema.ExpressionV1 serialize() {
        Schema.ExpressionV1.Builder b = Schema.ExpressionV1.newBuilder();
        for (Op op : this.ops) {
            b.addOps(op.serialize());
        }
        return b.build();
    }

    public static Either<Error.FormatError, Expression> deserializeV1(Schema.ExpressionV1 e) {
        ArrayList<Op> ops = new ArrayList<Op>();
        for (Schema.Op op : e.getOpsList()) {
            Either<Error.FormatError, Op> res = Op.deserializeV1(op);
            if (res.isLeft()) {
                Error.FormatError err = (Error.FormatError)res.getLeft();
                return API.Left((Object)err);
            }
            ops.add((Op)res.get());
        }
        return API.Right((Object)new Expression(ops));
    }
}

