/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.datalog;

import biscuit.format.schema.Schema;
import com.clevercloud.biscuit.datalog.SymbolTable;
import com.clevercloud.biscuit.error.Error;
import com.clevercloud.biscuit.token.builder.Term;
import com.google.protobuf.ByteString;
import io.vavr.API;
import io.vavr.control.Either;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;

public abstract class ID
implements Serializable {
    public abstract boolean match(ID var1);

    public abstract Schema.IDV1 serialize();

    public static Either<Error.FormatError, ID> deserialize_enumV0(Schema.IDV0 id) {
        if (id.getKind() == Schema.IDV0.Kind.DATE) {
            return Date.deserializeV0(id);
        }
        if (id.getKind() == Schema.IDV0.Kind.INTEGER) {
            return Integer.deserializeV0(id);
        }
        if (id.getKind() == Schema.IDV0.Kind.STR) {
            return Str.deserializeV0(id);
        }
        if (id.getKind() == Schema.IDV0.Kind.BYTES) {
            return Bytes.deserializeV0(id);
        }
        if (id.getKind() == Schema.IDV0.Kind.SYMBOL) {
            return Symbol.deserializeV0(id);
        }
        if (id.getKind() == Schema.IDV0.Kind.VARIABLE) {
            return Variable.deserializeV0(id);
        }
        return API.Left((Object)new Error.FormatError.DeserializationError("invalid ID kind: " + id.getKind()));
    }

    public static Either<Error.FormatError, ID> deserialize_enumV1(Schema.IDV1 id) {
        if (id.hasDate()) {
            return Date.deserializeV1(id);
        }
        if (id.hasInteger()) {
            return Integer.deserializeV1(id);
        }
        if (id.hasString()) {
            return Str.deserializeV1(id);
        }
        if (id.hasBytes()) {
            return Bytes.deserializeV1(id);
        }
        if (id.hasSymbol()) {
            return Symbol.deserializeV1(id);
        }
        if (id.hasVariable()) {
            return Variable.deserializeV1(id);
        }
        if (id.hasBool()) {
            return Bool.deserializeV1(id);
        }
        if (id.hasSet()) {
            return Set.deserializeV1(id);
        }
        return API.Left((Object)new Error.FormatError.DeserializationError("invalid ID kind: id.getKind()"));
    }

    public abstract Term toTerm(SymbolTable var1);

    public static final class Set
    extends ID
    implements Serializable {
        private final HashSet<ID> value;

        public HashSet<ID> value() {
            return this.value;
        }

        @Override
        public boolean match(ID other) {
            if (other instanceof Variable) {
                return true;
            }
            if (other instanceof Set) {
                return this.value.equals(((Set)other).value);
            }
            return false;
        }

        public Set(HashSet<ID> value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Set set = (Set)o;
            return this.value.equals(set.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "" + this.value;
        }

        @Override
        public Schema.IDV1 serialize() {
            Schema.IDSet.Builder s = Schema.IDSet.newBuilder();
            for (ID l : this.value) {
                s.addSet(l.serialize());
            }
            return Schema.IDV1.newBuilder().setSet(s).build();
        }

        public static Either<Error.FormatError, ID> deserializeV1(Schema.IDV1 id) {
            if (!id.hasSet()) {
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid ID kind, expected set"));
            }
            HashSet<ID> values = new HashSet<ID>();
            Schema.IDSet s = id.getSet();
            for (Schema.IDV1 l : s.getSetList()) {
                Either<Error.FormatError, ID> res = ID.deserialize_enumV1(l);
                if (res.isLeft()) {
                    Error.FormatError e = (Error.FormatError)res.getLeft();
                    return API.Left((Object)e);
                }
                ID value = (ID)res.get();
                if (value instanceof Variable) {
                    return API.Left((Object)new Error.FormatError.DeserializationError("sets cannot contain variables"));
                }
                values.add(value);
            }
            if (values.isEmpty()) {
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid Set value"));
            }
            return API.Right((Object)new Set(values));
        }

        @Override
        public Term toTerm(SymbolTable symbols) {
            HashSet<Term> s = new HashSet<Term>();
            for (ID i : this.value) {
                s.add(i.toTerm(symbols));
            }
            return new Term.Set(s);
        }
    }

    public static final class Bool
    extends ID
    implements Serializable {
        private final boolean value;

        public boolean value() {
            return this.value;
        }

        @Override
        public boolean match(ID other) {
            if (other instanceof Variable) {
                return true;
            }
            if (other instanceof Bool) {
                return this.value == ((Bool)other).value;
            }
            return false;
        }

        public Bool(boolean value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bool bool = (Bool)o;
            return this.value == bool.value;
        }

        public int hashCode() {
            return this.value ? 1 : 0;
        }

        public String toString() {
            return "" + this.value;
        }

        @Override
        public Schema.IDV1 serialize() {
            return Schema.IDV1.newBuilder().setBool(this.value).build();
        }

        public static Either<Error.FormatError, ID> deserializeV1(Schema.IDV1 id) {
            if (!id.hasBool()) {
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid ID kind, expected boolean"));
            }
            return API.Right((Object)new Bool(id.getBool()));
        }

        @Override
        public Term toTerm(SymbolTable symbols) {
            return new Term.Bool(this.value);
        }
    }

    public static final class Variable
    extends ID
    implements Serializable {
        private final long value;

        public long value() {
            return this.value;
        }

        @Override
        public boolean match(ID other) {
            return true;
        }

        public Variable(long value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Variable variable = (Variable)o;
            return this.value == variable.value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }

        public String toString() {
            return this.value + "?";
        }

        @Override
        public Schema.IDV1 serialize() {
            return Schema.IDV1.newBuilder().setVariable((int)this.value).build();
        }

        public static Either<Error.FormatError, ID> deserializeV0(Schema.IDV0 id) {
            if (id.getKind() != Schema.IDV0.Kind.VARIABLE) {
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid ID kind, expected variable"));
            }
            return API.Right((Object)new Variable(id.getVariable()));
        }

        public static Either<Error.FormatError, ID> deserializeV1(Schema.IDV1 id) {
            if (!id.hasVariable()) {
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid ID kind, expected variable"));
            }
            return API.Right((Object)new Variable(id.getVariable()));
        }

        @Override
        public Term toTerm(SymbolTable symbols) {
            return new Term.Variable(symbols.print_symbol((int)this.value));
        }
    }

    public static final class Symbol
    extends ID
    implements Serializable {
        private final long value;

        public long value() {
            return this.value;
        }

        @Override
        public boolean match(ID other) {
            if (other instanceof Variable) {
                return true;
            }
            if (other instanceof Symbol) {
                return this.value == ((Symbol)other).value;
            }
            return false;
        }

        public Symbol(long value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Symbol symbol = (Symbol)o;
            return this.value == symbol.value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }

        public String toString() {
            return "#" + this.value;
        }

        @Override
        public Schema.IDV1 serialize() {
            return Schema.IDV1.newBuilder().setSymbol(this.value).build();
        }

        public static Either<Error.FormatError, ID> deserializeV0(Schema.IDV0 id) {
            if (id.getKind() != Schema.IDV0.Kind.SYMBOL) {
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid ID kind, expected symbol"));
            }
            return API.Right((Object)new Symbol(id.getSymbol()));
        }

        public static Either<Error.FormatError, ID> deserializeV1(Schema.IDV1 id) {
            if (!id.hasSymbol()) {
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid ID kind, expected symbol"));
            }
            return API.Right((Object)new Symbol(id.getSymbol()));
        }

        @Override
        public Term toTerm(SymbolTable symbols) {
            return new Term.Symbol(symbols.print_symbol((int)this.value));
        }
    }

    public static final class Bytes
    extends ID
    implements Serializable {
        private final byte[] value;

        public byte[] value() {
            return this.value;
        }

        @Override
        public boolean match(ID other) {
            if (other instanceof Variable) {
                return true;
            }
            if (other instanceof Bytes) {
                return this.value.equals(((Bytes)other).value);
            }
            return false;
        }

        public Bytes(byte[] value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bytes bytes = (Bytes)o;
            return Arrays.equals(this.value, bytes.value);
        }

        public int hashCode() {
            return Arrays.hashCode(this.value);
        }

        public String toString() {
            return this.value.toString();
        }

        @Override
        public Schema.IDV1 serialize() {
            return Schema.IDV1.newBuilder().setBytes(ByteString.copyFrom((byte[])this.value)).build();
        }

        public static Either<Error.FormatError, ID> deserializeV0(Schema.IDV0 id) {
            if (id.getKind() != Schema.IDV0.Kind.STR) {
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid ID kind, expected byte array"));
            }
            return API.Right((Object)new Str(id.getStr()));
        }

        public static Either<Error.FormatError, ID> deserializeV1(Schema.IDV1 id) {
            if (!id.hasBytes()) {
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid ID kind, expected byte array"));
            }
            return API.Right((Object)new Bytes(id.getBytes().toByteArray()));
        }

        @Override
        public Term toTerm(SymbolTable symbols) {
            return new Term.Bytes(this.value);
        }
    }

    public static final class Str
    extends ID
    implements Serializable {
        private final String value;

        public String value() {
            return this.value;
        }

        @Override
        public boolean match(ID other) {
            if (other instanceof Variable) {
                return true;
            }
            if (other instanceof Str) {
                return this.value.equals(((Str)other).value);
            }
            return false;
        }

        public Str(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Str str = (Str)o;
            return this.value != null ? this.value.equals(str.value) : str.value == null;
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }

        public String toString() {
            return this.value;
        }

        @Override
        public Schema.IDV1 serialize() {
            return Schema.IDV1.newBuilder().setString(this.value).build();
        }

        public static Either<Error.FormatError, ID> deserializeV0(Schema.IDV0 id) {
            if (id.getKind() != Schema.IDV0.Kind.STR) {
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid ID kind, expected string"));
            }
            return API.Right((Object)new Str(id.getStr()));
        }

        public static Either<Error.FormatError, ID> deserializeV1(Schema.IDV1 id) {
            if (!id.hasString()) {
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid ID kind, expected string"));
            }
            return API.Right((Object)new Str(id.getString()));
        }

        @Override
        public Term toTerm(SymbolTable symbols) {
            return new Term.Str(this.value);
        }
    }

    public static final class Integer
    extends ID
    implements Serializable {
        private final long value;

        public long value() {
            return this.value;
        }

        @Override
        public boolean match(ID other) {
            if (other instanceof Variable) {
                return true;
            }
            if (other instanceof Integer) {
                return this.value == ((Integer)other).value;
            }
            return false;
        }

        public Integer(long value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Integer integer = (Integer)o;
            return this.value == integer.value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }

        public String toString() {
            return "" + this.value;
        }

        @Override
        public Schema.IDV1 serialize() {
            return Schema.IDV1.newBuilder().setInteger(this.value).build();
        }

        public static Either<Error.FormatError, ID> deserializeV0(Schema.IDV0 id) {
            if (id.getKind() != Schema.IDV0.Kind.INTEGER) {
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid ID kind, expected integer"));
            }
            return API.Right((Object)new Integer(id.getInteger()));
        }

        public static Either<Error.FormatError, ID> deserializeV1(Schema.IDV1 id) {
            if (!id.hasInteger()) {
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid ID kind, expected integer"));
            }
            return API.Right((Object)new Integer(id.getInteger()));
        }

        @Override
        public Term toTerm(SymbolTable symbols) {
            return new Term.Integer(this.value);
        }
    }

    public static final class Date
    extends ID
    implements Serializable {
        private final long value;

        public long value() {
            return this.value;
        }

        @Override
        public boolean match(ID other) {
            if (other instanceof Variable) {
                return true;
            }
            return this.equals(other);
        }

        public Date(long value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Date date = (Date)o;
            return this.value == date.value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }

        public String toString() {
            return "@" + this.value;
        }

        @Override
        public Schema.IDV1 serialize() {
            return Schema.IDV1.newBuilder().setDate(this.value).build();
        }

        public static Either<Error.FormatError, ID> deserializeV0(Schema.IDV0 id) {
            if (id.getKind() != Schema.IDV0.Kind.DATE) {
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid ID kind, expected date"));
            }
            return API.Right((Object)new Date(id.getDate()));
        }

        public static Either<Error.FormatError, ID> deserializeV1(Schema.IDV1 id) {
            if (!id.hasDate()) {
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid ID kind, expected date"));
            }
            return API.Right((Object)new Date(id.getDate()));
        }

        @Override
        public Term toTerm(SymbolTable symbols) {
            return new Term.Date(this.value);
        }
    }
}

