/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.datalog;

import com.clevercloud.biscuit.datalog.ID;
import com.clevercloud.biscuit.datalog.expressions.Expression;
import io.vavr.control.Option;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class MatchedVariables
implements Serializable {
    private final Map<Long, Optional<ID>> variables = new HashMap<Long, Optional<ID>>();

    public boolean insert(long key, ID value) {
        if (this.variables.containsKey(key)) {
            Optional<ID> val = this.variables.get(key);
            if (val.isPresent()) {
                return val.get().equals(value);
            }
            this.variables.put(key, Optional.of(value));
            return true;
        }
        return false;
    }

    public boolean is_complete() {
        return this.variables.values().stream().allMatch(v -> v.isPresent());
    }

    public Optional<Map<Long, ID>> complete() {
        HashMap<Long, ID> variables = new HashMap<Long, ID>();
        for (Map.Entry<Long, Optional<ID>> entry : this.variables.entrySet()) {
            if (entry.getValue().isPresent()) {
                variables.put(entry.getKey(), entry.getValue().get());
                continue;
            }
            return Optional.empty();
        }
        return Optional.of(variables);
    }

    public MatchedVariables clone() {
        MatchedVariables other = new MatchedVariables(this.variables.keySet());
        for (Map.Entry<Long, Optional<ID>> entry : this.variables.entrySet()) {
            if (!entry.getValue().isPresent()) continue;
            other.variables.put(entry.getKey(), entry.getValue());
        }
        return other;
    }

    public MatchedVariables(Set<Long> ids) {
        for (Long id : ids) {
            this.variables.put(id, Optional.empty());
        }
    }

    public Option<Map<Long, ID>> check_expressions(List<Expression> expressions) {
        Optional<Map<Long, ID>> vars = this.complete();
        if (vars.isPresent()) {
            Map<Long, ID> variables = vars.get();
            for (Expression e : expressions) {
                Option<ID> res = e.evaluate(variables);
                if (res.isEmpty()) {
                    return Option.none();
                }
                if (((ID)res.get()).equals(new ID.Bool(true))) continue;
                return Option.none();
            }
            return Option.some(variables);
        }
        return Option.none();
    }
}

