/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.error;

import com.clevercloud.biscuit.error.FailedCheck;
import io.vavr.control.Option;
import java.util.List;
import java.util.Objects;

public class LogicError {
    public Option<List<FailedCheck>> failed_checks() {
        return Option.none();
    }

    public static class VerifierNotEmpty
    extends LogicError {
        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public String toString() {
            return "VerifierNotEmpty";
        }
    }

    public static class Denied
    extends LogicError {
        private long id;

        public Denied(long id) {
            this.id = id;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public String toString() {
            return "Denied(" + this.id + ")";
        }
    }

    public static class NoMatchingPolicy
    extends LogicError {
        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public String toString() {
            return "NoMatchingPolicy{}";
        }
    }

    public static class FailedChecks
    extends LogicError {
        public final List<FailedCheck> errors;

        public FailedChecks(List<FailedCheck> errors) {
            this.errors = errors;
        }

        @Override
        public Option<List<FailedCheck>> failed_checks() {
            return Option.some(this.errors);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FailedChecks other = (FailedChecks)o;
            if (this.errors.size() != other.errors.size()) {
                return false;
            }
            for (int i = 0; i < this.errors.size(); ++i) {
                if (this.errors.get(i).equals(other.errors.get(i))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.errors);
        }

        public String toString() {
            return "LogicError.FailedCaveats{ errors: " + this.errors + " }";
        }
    }

    public static class InvalidBlockFact
    extends LogicError {
        public final long id;
        public final String e;

        public InvalidBlockFact(long id, String e) {
            this.id = id;
            this.e = e;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InvalidBlockFact other = (InvalidBlockFact)o;
            return this.id == other.id && this.e.equals(other.e);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.e);
        }

        public String toString() {
            return "LogicError.InvalidBlockFact{ id: " + this.id + ", error: " + this.e + " }";
        }
    }

    public static class InvalidAmbientFact
    extends LogicError {
        public final String e;

        public InvalidAmbientFact(String e) {
            this.e = e;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InvalidAmbientFact other = (InvalidAmbientFact)o;
            return this.e.equals(other.e);
        }

        public int hashCode() {
            return Objects.hash(this.e);
        }

        public String toString() {
            return "LogicError.InvalidAmbientFact{ error: " + this.e + " }";
        }
    }

    public static class InvalidAuthorityFact
    extends LogicError {
        public final String e;

        public InvalidAuthorityFact(String e) {
            this.e = e;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InvalidAuthorityFact other = (InvalidAuthorityFact)o;
            return this.e.equals(other.e);
        }

        public int hashCode() {
            return Objects.hash(this.e);
        }

        public String toString() {
            return "LogicError.InvalidAuthorityFact{ error: " + this.e + " }";
        }
    }
}

