/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.token;

import biscuit.format.schema.Schema;
import com.clevercloud.biscuit.datalog.Check;
import com.clevercloud.biscuit.datalog.Fact;
import com.clevercloud.biscuit.datalog.ID;
import com.clevercloud.biscuit.datalog.Rule;
import com.clevercloud.biscuit.datalog.SymbolTable;
import com.clevercloud.biscuit.datalog.World;
import com.clevercloud.biscuit.error.Error;
import com.clevercloud.biscuit.error.FailedCheck;
import com.clevercloud.biscuit.error.LogicError;
import com.clevercloud.biscuit.token.format.SerializedBiscuit;
import com.google.protobuf.InvalidProtocolBufferException;
import io.vavr.API;
import io.vavr.control.Either;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class Block {
    final long index;
    final SymbolTable symbols;
    final String context;
    final List<Fact> facts;
    final List<Rule> rules;
    final List<Check> checks;
    final long version;

    public Block(long index, SymbolTable base_symbols) {
        this.index = index;
        this.symbols = base_symbols;
        this.context = "";
        this.facts = new ArrayList<Fact>();
        this.rules = new ArrayList<Rule>();
        this.checks = new ArrayList<Check>();
        this.version = SerializedBiscuit.MAX_SCHEMA_VERSION;
    }

    public Block(long index, SymbolTable base_symbols, String context, List<Fact> facts, List<Rule> rules, List<Check> checks) {
        this.index = index;
        this.symbols = base_symbols;
        this.context = context;
        this.facts = facts;
        this.rules = rules;
        this.checks = checks;
        this.version = SerializedBiscuit.MAX_SCHEMA_VERSION;
    }

    Either<LogicError, Void> check(long i, World w, SymbolTable symbols, List<Check> verifier_checks, HashMap<String, Rule> queries, HashMap<String, HashMap<Long, Set<Fact>>> query_results) {
        Set<Fact> res;
        int k;
        Check c;
        boolean successful;
        int j;
        World world = new World(w);
        long authority_index = (Long)symbols.get("authority").get();
        long ambient_index = (Long)symbols.get("ambient").get();
        for (Fact fact : this.facts) {
            if (fact.predicate().ids().get(0).equals(new ID.Symbol(authority_index)) || fact.predicate().ids().get(0).equals(new ID.Symbol(ambient_index))) {
                return API.Left((Object)new LogicError.InvalidBlockFact(i, symbols.print_fact(fact)));
            }
            world.add_fact(fact);
        }
        for (Rule rule : this.rules) {
            world.add_rule(rule);
        }
        world.run();
        ArrayList<FailedCheck> errors = new ArrayList<FailedCheck>();
        for (j = 0; j < this.checks.size(); ++j) {
            successful = false;
            c = this.checks.get(j);
            for (k = 0; k < c.queries().size(); ++k) {
                res = world.query_rule(c.queries().get(k));
                if (res.isEmpty()) continue;
                successful = true;
                break;
            }
            if (successful) continue;
            errors.add(new FailedCheck.FailedBlock(i, j, symbols.print_check(this.checks.get(j))));
        }
        for (j = 0; j < verifier_checks.size(); ++j) {
            successful = false;
            c = verifier_checks.get(j);
            for (k = 0; k < c.queries().size(); ++k) {
                res = world.query_rule(c.queries().get(k));
                if (res.isEmpty()) continue;
                successful = true;
                break;
            }
            if (successful) continue;
            errors.add(new FailedCheck.FailedVerifier(j, symbols.print_check(verifier_checks.get(j))));
        }
        for (String name : queries.keySet()) {
            Set<Fact> res2 = world.query_rule(queries.get(name));
            query_results.get(name).put(new Long(this.index), res2);
        }
        if (errors.isEmpty()) {
            return API.Right(null);
        }
        return API.Left((Object)new LogicError.FailedChecks(errors));
    }

    public String print(SymbolTable symbol_table) {
        StringBuilder s = new StringBuilder();
        s.append("Block[");
        s.append(this.index);
        s.append("] {\n\t\tsymbols: ");
        s.append(this.symbols.symbols);
        s.append("\n\t\tcontext: ");
        s.append(this.context);
        s.append("\n\t\tfacts: [");
        for (Fact f : this.facts) {
            s.append("\n\t\t\t");
            s.append(symbol_table.print_fact(f));
        }
        s.append("\n\t\t]\n\t\trules: [");
        for (Rule r : this.rules) {
            s.append("\n\t\t\t");
            s.append(symbol_table.print_rule(r));
        }
        s.append("\n\t\t]\n\t\tchecks: [");
        for (Check c : this.checks) {
            s.append("\n\t\t\t");
            s.append(symbol_table.print_check(c));
        }
        s.append("\n\t\t]\n\t}");
        return s.toString();
    }

    public Schema.Block serialize() {
        int i;
        Schema.Block.Builder b = Schema.Block.newBuilder().setIndex((int)this.index);
        for (i = 0; i < this.symbols.symbols.size(); ++i) {
            b.addSymbols(this.symbols.symbols.get(i));
        }
        if (!this.context.isEmpty()) {
            b.setContext(this.context);
        }
        for (i = 0; i < this.facts.size(); ++i) {
            b.addFactsV1(this.facts.get(i).serialize());
        }
        for (i = 0; i < this.rules.size(); ++i) {
            b.addRulesV1(this.rules.get(i).serialize());
        }
        for (i = 0; i < this.checks.size(); ++i) {
            b.addChecksV1(this.checks.get(i).serialize());
        }
        b.setVersion(SerializedBiscuit.MAX_SCHEMA_VERSION);
        return b.build();
    }

    public static Either<Error.FormatError, Block> deserialize(Schema.Block b) {
        int version = b.getVersion();
        if (version > SerializedBiscuit.MAX_SCHEMA_VERSION) {
            return API.Left((Object)new Error.FormatError.Version(SerializedBiscuit.MAX_SCHEMA_VERSION, version));
        }
        SymbolTable symbols = new SymbolTable();
        for (String s : b.getSymbolsList()) {
            symbols.add(s);
        }
        ArrayList<Fact> facts = new ArrayList<Fact>();
        ArrayList<Rule> rules = new ArrayList<Rule>();
        ArrayList<Check> checks = new ArrayList<Check>();
        if (version == 0) {
            Object res;
            for (Schema.FactV0 fact : b.getFactsV0List()) {
                res = Fact.deserializeV0(fact);
                if (res.isLeft()) {
                    Error.FormatError e = (Error.FormatError)res.getLeft();
                    return API.Left((Object)e);
                }
                facts.add((Fact)res.get());
            }
            for (Schema.RuleV0 rule : b.getRulesV0List()) {
                res = Rule.deserializeV0(rule);
                if (res.isLeft()) {
                    Error.FormatError e = (Error.FormatError)res.getLeft();
                    return API.Left((Object)e);
                }
                rules.add((Rule)res.get());
            }
            for (Schema.CaveatV0 caveat : b.getCaveatsV0List()) {
                res = Check.deserializeV0(caveat);
                if (res.isLeft()) {
                    Error.FormatError e = (Error.FormatError)res.getLeft();
                    return API.Left((Object)e);
                }
                checks.add((Check)res.get());
            }
        } else {
            Object res;
            for (Schema.FactV1 fact : b.getFactsV1List()) {
                res = Fact.deserializeV1(fact);
                if (res.isLeft()) {
                    Error.FormatError e = (Error.FormatError)res.getLeft();
                    return API.Left((Object)e);
                }
                facts.add((Fact)res.get());
            }
            for (Schema.RuleV1 rule : b.getRulesV1List()) {
                res = Rule.deserializeV1(rule);
                if (res.isLeft()) {
                    Error.FormatError e = (Error.FormatError)res.getLeft();
                    return API.Left((Object)e);
                }
                rules.add((Rule)res.get());
            }
            for (Schema.CheckV1 check : b.getChecksV1List()) {
                res = Check.deserializeV1(check);
                if (res.isLeft()) {
                    Error.FormatError e = (Error.FormatError)res.getLeft();
                    return API.Left((Object)e);
                }
                checks.add((Check)res.get());
            }
        }
        return API.Right((Object)new Block(b.getIndex(), symbols, b.getContext(), facts, rules, checks));
    }

    public static Either<Error.FormatError, Block> from_bytes(byte[] slice) {
        try {
            Schema.Block data = Schema.Block.parseFrom(slice);
            return Block.deserialize(data);
        }
        catch (InvalidProtocolBufferException e) {
            return API.Left((Object)new Error.FormatError.DeserializationError(e.toString()));
        }
    }

    public Either<Error.FormatError, byte[]> to_bytes() {
        Schema.Block b = this.serialize();
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            b.writeTo(stream);
            byte[] data = stream.toByteArray();
            return API.Right((Object)data);
        }
        catch (IOException e) {
            return API.Left((Object)new Error.FormatError.SerializationError(e.toString()));
        }
    }
}

