/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.datalog;

import biscuit.format.schema.Schema;
import com.clevercloud.biscuit.datalog.Combinator;
import com.clevercloud.biscuit.datalog.Fact;
import com.clevercloud.biscuit.datalog.ID;
import com.clevercloud.biscuit.datalog.MatchedVariables;
import com.clevercloud.biscuit.datalog.Predicate;
import com.clevercloud.biscuit.datalog.constraints.Constraint;
import com.clevercloud.biscuit.datalog.expressions.Expression;
import com.clevercloud.biscuit.error.Error;
import io.vavr.API;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class Rule
implements Serializable {
    private final Predicate head;
    private final List<Predicate> body;
    private final List<Expression> expressions;

    public final Predicate head() {
        return this.head;
    }

    public final List<Predicate> body() {
        return this.body;
    }

    public final List<Expression> expressions() {
        return this.expressions;
    }

    public void apply(Set<Fact> facts, Set<Fact> new_facts, Set<Long> restricted_symbols) {
        ListIterator<ID> idit;
        Predicate p;
        Option<Map<Long, ID>> h_opt;
        HashSet<Long> variables_set = new HashSet<Long>();
        for (Predicate pred : this.body) {
            variables_set.addAll(pred.ids().stream().filter(id -> id instanceof ID.Variable).map(id -> ((ID.Variable)id).value()).collect(Collectors.toSet()));
        }
        MatchedVariables variables = new MatchedVariables(variables_set);
        if (this.body.isEmpty() && (h_opt = variables.check_expressions(this.expressions)).isDefined()) {
            Map<Long, ID> h = (Map<Long, ID>)h_opt.get();
            p = this.head.clone();
            idit = p.ids_iterator();
            while (idit.hasNext()) {
                ID id2 = idit.next();
                if (!(id2 instanceof ID.Variable)) continue;
                ID value = h.get(((ID.Variable)id2).value());
                idit.set(value);
            }
            new_facts.add(new Fact(p));
        }
        for (Map<Long, ID> h : new Combinator(variables, this.body, this.expressions, facts).combine()) {
            p = this.head.clone();
            idit = p.ids_iterator();
            boolean unbound_variable = false;
            while (idit.hasNext()) {
                ID id3 = idit.next();
                if (!(id3 instanceof ID.Variable)) continue;
                ID value = h.get(((ID.Variable)id3).value());
                idit.set(value);
                if (value != null) continue;
                unbound_variable = true;
            }
            ID first = p.ids().get(0);
            if (first != null && first instanceof ID.Symbol && restricted_symbols.contains(((ID.Symbol)first).value()) || unbound_variable) continue;
            new_facts.add(new Fact(p));
        }
    }

    public boolean test(Set<Fact> facts) {
        HashSet<Long> variables_set = new HashSet<Long>();
        for (Predicate pred : this.body) {
            variables_set.addAll(pred.ids().stream().filter(id -> id instanceof ID.Variable).map(id -> ((ID.Variable)id).value()).collect(Collectors.toSet()));
        }
        MatchedVariables variables = new MatchedVariables(variables_set);
        if (this.body.isEmpty()) {
            return variables.check_expressions(this.expressions).isDefined();
        }
        Combinator c = new Combinator(variables, this.body, this.expressions, facts);
        return c.next().isDefined();
    }

    public Rule(Predicate head, List<Predicate> body, List<Expression> expressions) {
        this.head = head;
        this.body = body;
        this.expressions = expressions;
    }

    public Schema.RuleV1 serialize() {
        int i;
        Schema.RuleV1.Builder b = Schema.RuleV1.newBuilder().setHead(this.head.serialize());
        for (i = 0; i < this.body.size(); ++i) {
            b.addBody(this.body.get(i).serialize());
        }
        for (i = 0; i < this.expressions.size(); ++i) {
            b.addExpressions(this.expressions.get(i).serialize());
        }
        return b.build();
    }

    public static Either<Error.FormatError, Rule> deserializeV0(Schema.RuleV0 rule) {
        ArrayList<Predicate> body = new ArrayList<Predicate>();
        for (Schema.PredicateV0 predicateV0 : rule.getBodyList()) {
            Either<Error.FormatError, Predicate> res = Predicate.deserializeV0(predicateV0);
            if (res.isLeft()) {
                Error.FormatError e = (Error.FormatError)res.getLeft();
                return API.Left((Object)e);
            }
            body.add((Predicate)res.get());
        }
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        for (Schema.ConstraintV0 constraint : rule.getConstraintsList()) {
            Either<Error.FormatError, Expression> res = Constraint.deserializeV0(constraint);
            if (res.isLeft()) {
                Error.FormatError e = (Error.FormatError)res.getLeft();
                return API.Left((Object)e);
            }
            expressions.add((Expression)res.get());
        }
        Either<Error.FormatError, Predicate> either = Predicate.deserializeV0(rule.getHead());
        if (either.isLeft()) {
            Error.FormatError e = (Error.FormatError)either.getLeft();
            return API.Left((Object)e);
        }
        return API.Right((Object)new Rule((Predicate)either.get(), body, expressions));
    }

    public static Either<Error.FormatError, Rule> deserializeV1(Schema.RuleV1 rule) {
        ArrayList<Predicate> body = new ArrayList<Predicate>();
        for (Schema.PredicateV1 predicateV1 : rule.getBodyList()) {
            Either<Error.FormatError, Predicate> res = Predicate.deserializeV1(predicateV1);
            if (res.isLeft()) {
                Error.FormatError e = (Error.FormatError)res.getLeft();
                return API.Left((Object)e);
            }
            body.add((Predicate)res.get());
        }
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        for (Schema.ExpressionV1 expression : rule.getExpressionsList()) {
            Either<Error.FormatError, Expression> res = Expression.deserializeV1(expression);
            if (res.isLeft()) {
                Error.FormatError e = (Error.FormatError)res.getLeft();
                return API.Left((Object)e);
            }
            expressions.add((Expression)res.get());
        }
        Either<Error.FormatError, Predicate> either = Predicate.deserializeV1(rule.getHead());
        if (either.isLeft()) {
            Error.FormatError e = (Error.FormatError)either.getLeft();
            return API.Left((Object)e);
        }
        return API.Right((Object)new Rule((Predicate)either.get(), body, expressions));
    }
}

