/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.datalog;

import com.clevercloud.biscuit.datalog.Check;
import com.clevercloud.biscuit.datalog.Fact;
import com.clevercloud.biscuit.datalog.ID;
import com.clevercloud.biscuit.datalog.Predicate;
import com.clevercloud.biscuit.datalog.Rule;
import com.clevercloud.biscuit.datalog.RunLimits;
import com.clevercloud.biscuit.datalog.SymbolTable;
import com.clevercloud.biscuit.error.Error;
import io.vavr.API;
import io.vavr.control.Either;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class World
implements Serializable {
    private final Set<Fact> facts;
    private final List<Rule> rules;
    private final List<Rule> privileged_rules;
    private final List<Check> checks;

    public void add_fact(Fact fact) {
        this.facts.add(fact);
    }

    public void add_rule(Rule rule) {
        this.rules.add(rule);
    }

    public void add_privileged_rule(Rule rule) {
        this.privileged_rules.add(rule);
    }

    public void add_check(Check check) {
        this.checks.add(check);
    }

    public void clearRules() {
        this.rules.clear();
    }

    public Either<Error, Void> run(Set<Long> restricted_symbols) {
        return this.run(new RunLimits(), restricted_symbols);
    }

    public Either<Error, Void> run(RunLimits limits, Set<Long> restricted_symbols) {
        int iterations = 0;
        Instant limit = Instant.now().plus(limits.maxTime);
        do {
            HashSet<Fact> new_facts = new HashSet<Fact>();
            for (Rule rule : this.privileged_rules) {
                rule.apply(this.facts, new_facts, new HashSet<Long>());
                if (Instant.now().compareTo(limit) < 0) continue;
                return API.Left((Object)new Error.Timeout());
            }
            for (Rule rule : this.rules) {
                rule.apply(this.facts, new_facts, restricted_symbols);
                if (Instant.now().compareTo(limit) < 0) continue;
                return API.Left((Object)new Error.Timeout());
            }
            int len = this.facts.size();
            this.facts.addAll(new_facts);
            if (this.facts.size() == len) {
                return API.Right(null);
            }
            if (this.facts.size() < limits.maxFacts) continue;
            return API.Left((Object)new Error.TooManyFacts());
        } while (++iterations < limits.maxIterations);
        return API.Left((Object)new Error.TooManyIterations());
    }

    public final Set<Fact> facts() {
        return this.facts;
    }

    public List<Rule> rules() {
        return this.rules;
    }

    public List<Check> checks() {
        return this.checks;
    }

    public final Set<Fact> query(Predicate pred) {
        return this.facts.stream().filter(f -> {
            if (f.predicate().name() != pred.name()) {
                return false;
            }
            int min_size = Math.min(f.predicate().ids().size(), pred.ids().size());
            for (int i = 0; i < min_size; ++i) {
                ID fid = f.predicate().ids().get(i);
                ID pid = pred.ids().get(i);
                if (!((fid instanceof ID.Symbol || fid instanceof ID.Integer || fid instanceof ID.Str || fid instanceof ID.Date) && fid.getClass() == pid.getClass() ? !fid.equals(pid) : !(fid instanceof ID.Symbol) || !(pid instanceof ID.Variable))) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toSet());
    }

    public final Set<Fact> query_rule(Rule rule) {
        HashSet<Fact> new_facts = new HashSet<Fact>();
        rule.apply(this.facts, new_facts, new HashSet<Long>());
        return new_facts;
    }

    public final boolean test_rule(Rule rule) {
        return rule.test(this.facts);
    }

    public World() {
        this.facts = new HashSet<Fact>();
        this.rules = new ArrayList<Rule>();
        this.privileged_rules = new ArrayList<Rule>();
        this.checks = new ArrayList<Check>();
    }

    public World(Set<Fact> facts, List<Rule> privileged_rules, List<Rule> rules) {
        this.facts = facts;
        this.privileged_rules = privileged_rules;
        this.rules = rules;
        this.checks = new ArrayList<Check>();
    }

    public World(Set<Fact> facts, List<Rule> privileged_rules, List<Rule> rules, List<Check> checks) {
        this.facts = facts;
        this.privileged_rules = privileged_rules;
        this.rules = rules;
        this.checks = checks;
    }

    public World(World w) {
        this.facts = new HashSet<Fact>();
        for (Fact fact : w.facts) {
            this.facts.add(fact);
        }
        this.privileged_rules = new ArrayList<Rule>();
        for (Rule rule : w.privileged_rules) {
            this.privileged_rules.add(rule);
        }
        this.rules = new ArrayList<Rule>();
        for (Rule rule : w.rules) {
            this.rules.add(rule);
        }
        this.checks = new ArrayList<Check>();
        for (Check check : w.checks) {
            this.checks.add(check);
        }
    }

    public String print(SymbolTable symbol_table) {
        StringBuilder s = new StringBuilder();
        s.append("World {\n\t\tfacts: [");
        for (Fact f : this.facts) {
            s.append("\n\t\t\t");
            s.append(symbol_table.print_fact(f));
        }
        s.append("\n\t\t]\n\t\tprivileged rules: [");
        for (Rule r : this.privileged_rules) {
            s.append("\n\t\t\t");
            s.append(symbol_table.print_rule(r));
        }
        s.append("\n\t\t]\n\t\trules: [");
        for (Rule r : this.rules) {
            s.append("\n\t\t\t");
            s.append(symbol_table.print_rule(r));
        }
        s.append("\n\t\t]\n\t\tchecks: [");
        for (Check c : this.checks) {
            s.append("\n\t\t\t");
            s.append(symbol_table.print_check(c));
        }
        s.append("\n\t\t]\n\t}");
        return s.toString();
    }
}

