/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.datalog.constraints;

import biscuit.format.schema.Schema;
import com.clevercloud.biscuit.datalog.ID;
import com.clevercloud.biscuit.datalog.expressions.Expression;
import com.clevercloud.biscuit.datalog.expressions.Op;
import com.clevercloud.biscuit.error.Error;
import com.google.protobuf.ByteString;
import io.vavr.API;
import io.vavr.control.Either;
import java.util.ArrayList;
import java.util.HashSet;

public final class Constraint {
    public static Either<Error.FormatError, Expression> deserializeV0(Schema.ConstraintV0 c) {
        ArrayList<Op> ops = new ArrayList<Op>();
        long id = c.getId();
        ops.add(new Op.Value(new ID.Variable(id)));
        switch (c.getKind()) {
            case INT: {
                if (c.hasInt()) {
                    Schema.IntConstraintV0 ic = c.getInt();
                    switch (ic.getKind()) {
                        case LOWER: {
                            ops.add(new Op.Value(new ID.Integer(ic.getLower())));
                            ops.add(new Op.Binary(Op.BinaryOp.LessThan));
                            return API.Right((Object)new Expression(ops));
                        }
                        case LARGER: {
                            ops.add(new Op.Value(new ID.Integer(ic.getLarger())));
                            ops.add(new Op.Binary(Op.BinaryOp.GreaterThan));
                            return API.Right((Object)new Expression(ops));
                        }
                        case LOWER_OR_EQUAL: {
                            ops.add(new Op.Value(new ID.Integer(ic.getLowerOrEqual())));
                            ops.add(new Op.Binary(Op.BinaryOp.LessOrEqual));
                            return API.Right((Object)new Expression(ops));
                        }
                        case LARGER_OR_EQUAL: {
                            ops.add(new Op.Value(new ID.Integer(ic.getLargerOrEqual())));
                            ops.add(new Op.Binary(Op.BinaryOp.GreaterOrEqual));
                            return API.Right((Object)new Expression(ops));
                        }
                        case EQUAL: {
                            ops.add(new Op.Value(new ID.Integer(ic.getEqual())));
                            ops.add(new Op.Binary(Op.BinaryOp.Equal));
                            return API.Right((Object)new Expression(ops));
                        }
                        case IN: {
                            HashSet<ID> set = new HashSet<ID>();
                            for (Long l : ic.getInSetList()) {
                                set.add(new ID.Integer(l));
                            }
                            ops.add(new Op.Value(new ID.Set(set)));
                            ops.add(new Op.Binary(Op.BinaryOp.Contains));
                            return API.Right((Object)new Expression(ops));
                        }
                        case NOT_IN: {
                            HashSet<ID> set2 = new HashSet<ID>();
                            for (Long l : ic.getNotInSetList()) {
                                set2.add(new ID.Integer(l));
                            }
                            ops.add(new Op.Value(new ID.Set(set2)));
                            ops.add(new Op.Binary(Op.BinaryOp.Contains));
                            ops.add(new Op.Unary(Op.UnaryOp.Negate));
                            return API.Right((Object)new Expression(ops));
                        }
                    }
                }
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid Int constraint"));
            }
            case DATE: {
                if (!c.hasDate()) {
                    return API.Left((Object)new Error.FormatError.DeserializationError("invalid Date constraint"));
                }
                Schema.DateConstraintV0 ic = c.getDate();
                switch (ic.getKind()) {
                    case BEFORE: {
                        ops.add(new Op.Value(new ID.Date(ic.getBefore())));
                        ops.add(new Op.Binary(Op.BinaryOp.LessOrEqual));
                        return API.Right((Object)new Expression(ops));
                    }
                    case AFTER: {
                        ops.add(new Op.Value(new ID.Date(ic.getBefore())));
                        ops.add(new Op.Binary(Op.BinaryOp.GreaterOrEqual));
                        return API.Right((Object)new Expression(ops));
                    }
                }
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid Int constraint"));
            }
            case BYTES: {
                if (c.hasBytes()) {
                    Schema.BytesConstraintV0 ic = c.getBytes();
                    switch (ic.getKind()) {
                        case EQUAL: {
                            ops.add(new Op.Value(new ID.Bytes(ic.getEqual().toByteArray())));
                            ops.add(new Op.Binary(Op.BinaryOp.Equal));
                            return API.Right((Object)new Expression(ops));
                        }
                        case IN: {
                            HashSet<ID> set = new HashSet<ID>();
                            for (ByteString l : ic.getInSetList()) {
                                set.add(new ID.Bytes(l.toByteArray()));
                            }
                            ops.add(new Op.Value(new ID.Set(set)));
                            ops.add(new Op.Binary(Op.BinaryOp.Contains));
                            return API.Right((Object)new Expression(ops));
                        }
                        case NOT_IN: {
                            HashSet<ID> set2 = new HashSet<ID>();
                            for (ByteString l : ic.getNotInSetList()) {
                                set2.add(new ID.Bytes(l.toByteArray()));
                            }
                            ops.add(new Op.Value(new ID.Set(set2)));
                            ops.add(new Op.Binary(Op.BinaryOp.Contains));
                            ops.add(new Op.Unary(Op.UnaryOp.Negate));
                            return API.Right((Object)new Expression(ops));
                        }
                    }
                }
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid Bytes constraint"));
            }
            case STRING: {
                if (c.hasStr()) {
                    Schema.StringConstraintV0 ic = c.getStr();
                    switch (ic.getKind()) {
                        case EQUAL: {
                            ops.add(new Op.Value(new ID.Str(ic.getEqual())));
                            ops.add(new Op.Binary(Op.BinaryOp.Equal));
                            return API.Right((Object)new Expression(ops));
                        }
                        case PREFIX: {
                            ops.add(new Op.Value(new ID.Str(ic.getPrefix())));
                            ops.add(new Op.Binary(Op.BinaryOp.Prefix));
                            return API.Right((Object)new Expression(ops));
                        }
                        case SUFFIX: {
                            ops.add(new Op.Value(new ID.Str(ic.getSuffix())));
                            ops.add(new Op.Binary(Op.BinaryOp.Suffix));
                            return API.Right((Object)new Expression(ops));
                        }
                        case REGEX: {
                            ops.add(new Op.Value(new ID.Str(ic.getRegex())));
                            ops.add(new Op.Binary(Op.BinaryOp.Regex));
                            return API.Right((Object)new Expression(ops));
                        }
                        case IN: {
                            HashSet<ID> set = new HashSet<ID>();
                            for (String l : ic.getInSetList()) {
                                set.add(new ID.Str(l));
                            }
                            ops.add(new Op.Value(new ID.Set(set)));
                            ops.add(new Op.Binary(Op.BinaryOp.Contains));
                            return API.Right((Object)new Expression(ops));
                        }
                        case NOT_IN: {
                            HashSet<ID> set2 = new HashSet<ID>();
                            for (String l : ic.getNotInSetList()) {
                                set2.add(new ID.Str(l));
                            }
                            ops.add(new Op.Value(new ID.Set(set2)));
                            ops.add(new Op.Binary(Op.BinaryOp.Contains));
                            ops.add(new Op.Unary(Op.UnaryOp.Negate));
                            return API.Right((Object)new Expression(ops));
                        }
                    }
                }
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid String constraint"));
            }
            case SYMBOL: {
                if (c.hasSymbol()) {
                    Schema.SymbolConstraintV0 ic = c.getSymbol();
                    switch (ic.getKind()) {
                        case IN: {
                            HashSet<ID> set = new HashSet<ID>();
                            for (Long l : ic.getInSetList()) {
                                set.add(new ID.Symbol(l));
                            }
                            ops.add(new Op.Value(new ID.Set(set)));
                            ops.add(new Op.Binary(Op.BinaryOp.Contains));
                            return API.Right((Object)new Expression(ops));
                        }
                        case NOT_IN: {
                            HashSet<ID> set2 = new HashSet<ID>();
                            for (Long l : ic.getNotInSetList()) {
                                set2.add(new ID.Symbol(l));
                            }
                            ops.add(new Op.Value(new ID.Set(set2)));
                            ops.add(new Op.Binary(Op.BinaryOp.Contains));
                            ops.add(new Op.Unary(Op.UnaryOp.Negate));
                            return API.Right((Object)new Expression(ops));
                        }
                    }
                }
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid Symbol constraint"));
            }
        }
        return API.Left((Object)new Error.FormatError.DeserializationError("invalid constraint kind"));
    }
}

