/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.token.builder;

import com.clevercloud.biscuit.datalog.ID;
import com.clevercloud.biscuit.datalog.SymbolTable;
import com.clevercloud.biscuit.token.builder.Term;
import java.util.ArrayList;
import java.util.List;

public class Predicate {
    String name;
    List<Term> ids;

    public Predicate(String name, List<Term> ids) {
        this.name = name;
        this.ids = ids;
    }

    public String getName() {
        return this.name;
    }

    public List<Term> getIds() {
        return this.ids;
    }

    public com.clevercloud.biscuit.datalog.Predicate convert(SymbolTable symbols) {
        long name = symbols.insert(this.name);
        ArrayList<ID> ids = new ArrayList<ID>();
        for (Term a : this.ids) {
            ids.add(a.convert(symbols));
        }
        return new com.clevercloud.biscuit.datalog.Predicate(name, ids);
    }

    public static Predicate convert_from(com.clevercloud.biscuit.datalog.Predicate p, SymbolTable symbols) {
        String name = symbols.print_symbol((int)p.name());
        ArrayList<Term> ids = new ArrayList<Term>();
        for (ID i : p.ids()) {
            ids.add(i.toTerm(symbols));
        }
        return new Predicate(name, ids);
    }

    public String toString() {
        return this.name + "(" + this.ids + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Predicate predicate = (Predicate)o;
        if (this.name != null ? !this.name.equals(predicate.name) : predicate.name != null) {
            return false;
        }
        return this.ids != null ? this.ids.equals(predicate.ids) : predicate.ids == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.ids != null ? this.ids.hashCode() : 0);
        return result;
    }
}

