/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.token.builder;

import com.clevercloud.biscuit.datalog.SymbolTable;
import com.clevercloud.biscuit.token.builder.Expression;
import com.clevercloud.biscuit.token.builder.Predicate;
import java.util.ArrayList;
import java.util.List;

public class Rule {
    Predicate head;
    List<Predicate> body;
    List<Expression> expressions;

    public Rule(Predicate head, List<Predicate> body, List<Expression> expressions) {
        this.head = head;
        this.body = body;
        this.expressions = expressions;
    }

    public com.clevercloud.biscuit.datalog.Rule convert(SymbolTable symbols) {
        com.clevercloud.biscuit.datalog.Predicate head = this.head.convert(symbols);
        ArrayList<com.clevercloud.biscuit.datalog.Predicate> body = new ArrayList<com.clevercloud.biscuit.datalog.Predicate>();
        ArrayList<com.clevercloud.biscuit.datalog.expressions.Expression> expressions = new ArrayList<com.clevercloud.biscuit.datalog.expressions.Expression>();
        for (Predicate p : this.body) {
            body.add(p.convert(symbols));
        }
        for (Expression e : this.expressions) {
            expressions.add(e.convert(symbols));
        }
        return new com.clevercloud.biscuit.datalog.Rule(head, body, expressions);
    }

    public static Rule convert_from(com.clevercloud.biscuit.datalog.Rule r, SymbolTable symbols) {
        Predicate head = Predicate.convert_from(r.head(), symbols);
        ArrayList<Predicate> body = new ArrayList<Predicate>();
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        for (com.clevercloud.biscuit.datalog.Predicate p : r.body()) {
            body.add(Predicate.convert_from(p, symbols));
        }
        for (com.clevercloud.biscuit.datalog.expressions.Expression e : r.expressions()) {
            expressions.add(Expression.convert_from(e, symbols));
        }
        return new Rule(head, body, expressions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rule rule = (Rule)o;
        if (this.head != null ? !this.head.equals(rule.head) : rule.head != null) {
            return false;
        }
        if (this.body != null ? !this.body.equals(rule.body) : rule.body != null) {
            return false;
        }
        return this.expressions != null ? this.expressions.equals(rule.expressions) : rule.expressions == null;
    }

    public int hashCode() {
        int result = this.head != null ? this.head.hashCode() : 0;
        result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
        result = 31 * result + (this.expressions != null ? this.expressions.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.head.toString() + " <- " + this.body + ", " + this.expressions;
    }
}

