/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.token.builder;

import com.clevercloud.biscuit.datalog.ID;
import com.clevercloud.biscuit.datalog.SymbolTable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;

public abstract class Term {
    public abstract ID convert(SymbolTable var1);

    public static Term convert_from(ID id, SymbolTable symbols) {
        return id.toTerm(symbols);
    }

    public static class Set
    extends Term {
        HashSet<Term> value;

        public Set(HashSet<Term> value) {
            this.value = value;
        }

        @Override
        public ID convert(SymbolTable symbols) {
            HashSet<ID> s = new HashSet<ID>();
            for (Term t : this.value) {
                s.add(t.convert(symbols));
            }
            return new ID.Set(s);
        }

        public String toString() {
            return "[" + this.value + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Set set = (Set)o;
            return this.value != null ? this.value.equals(set.value) : set.value == null;
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }
    }

    public static class Bool
    extends Term {
        boolean value;

        public Bool(boolean value) {
            this.value = value;
        }

        @Override
        public ID convert(SymbolTable symbols) {
            return new ID.Bool(this.value);
        }

        public String toString() {
            return "" + this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bool bool = (Bool)o;
            return this.value == bool.value;
        }

        public int hashCode() {
            return this.value ? 1 : 0;
        }
    }

    public static class Date
    extends Term {
        long value;

        public Date(long value) {
            this.value = value;
        }

        @Override
        public ID convert(SymbolTable symbols) {
            return new ID.Date(this.value);
        }

        public String toString() {
            return "" + this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Date date = (Date)o;
            return this.value == date.value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }
    }

    public static class Bytes
    extends Term {
        byte[] value;

        public Bytes(byte[] value) {
            this.value = value;
        }

        @Override
        public ID convert(SymbolTable symbols) {
            return new ID.Bytes(this.value);
        }

        public String toString() {
            return "\"" + this.value + "\"";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bytes bytes = (Bytes)o;
            return Arrays.equals(this.value, bytes.value);
        }

        public int hashCode() {
            return Arrays.hashCode(this.value);
        }
    }

    public static class Str
    extends Term {
        String value;

        public Str(String value) {
            this.value = value;
        }

        @Override
        public ID convert(SymbolTable symbols) {
            return new ID.Str(this.value);
        }

        public String toString() {
            return "\"" + this.value + "\"";
        }

        public String value() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Str str = (Str)o;
            return this.value != null ? this.value.equals(str.value) : str.value == null;
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }
    }

    public static class Integer
    extends Term {
        long value;

        public Integer(long value) {
            this.value = value;
        }

        @Override
        public ID convert(SymbolTable symbols) {
            return new ID.Integer(this.value);
        }

        public String toString() {
            return "" + this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Integer integer = (Integer)o;
            return this.value == integer.value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }
    }

    public static class Variable
    extends Term {
        String value;

        public Variable(String value) {
            this.value = value;
        }

        @Override
        public ID convert(SymbolTable symbols) {
            return new ID.Variable(symbols.insert(this.value));
        }

        public String toString() {
            return "$" + this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Variable variable = (Variable)o;
            return this.value.equals(variable.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static class Symbol
    extends Term {
        String value;

        public Symbol(String value) {
            this.value = value;
        }

        @Override
        public ID convert(SymbolTable symbols) {
            return new ID.Symbol(symbols.insert(this.value));
        }

        public String toString() {
            return "#" + this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Symbol symbol = (Symbol)o;
            return Objects.equals(this.value, symbol.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

