/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.datalog;

import biscuit.format.schema.Schema;
import com.clevercloud.biscuit.datalog.Rule;
import com.clevercloud.biscuit.error.Error;
import io.vavr.API;
import io.vavr.control.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Check {
    private final List<Rule> queries;

    public Check(List<Rule> queries) {
        this.queries = queries;
    }

    public List<Rule> queries() {
        return this.queries;
    }

    public int hashCode() {
        return Objects.hash(this.queries);
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public String toString() {
        return super.toString();
    }

    public Schema.CheckV2 serialize() {
        Schema.CheckV2.Builder b = Schema.CheckV2.newBuilder();
        for (int i = 0; i < this.queries.size(); ++i) {
            b.addQueries(this.queries.get(i).serialize());
        }
        return b.build();
    }

    public static Either<Error.FormatError, Check> deserializeV2(Schema.CheckV2 check) {
        ArrayList<Rule> queries = new ArrayList<Rule>();
        for (Schema.RuleV2 query : check.getQueriesList()) {
            Either<Error.FormatError, Rule> res = Rule.deserializeV2(query);
            if (res.isLeft()) {
                Error.FormatError e = (Error.FormatError)res.getLeft();
                return API.Left((Object)e);
            }
            queries.add((Rule)res.get());
        }
        return API.Right((Object)new Check(queries));
    }
}

