/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.datalog;

import biscuit.format.schema.Schema;
import com.clevercloud.biscuit.datalog.Term;
import com.clevercloud.biscuit.error.Error;
import io.vavr.API;
import io.vavr.control.Either;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.stream.Collectors;

public final class Predicate
implements Serializable {
    private final long name;
    private final List<Term> terms;

    public long name() {
        return this.name;
    }

    public final List<Term> terms() {
        return this.terms;
    }

    public final ListIterator<Term> ids_iterator() {
        return this.terms.listIterator();
    }

    public boolean match(Predicate rule_predicate) {
        if (this.name != rule_predicate.name) {
            return false;
        }
        if (this.terms.size() != rule_predicate.terms.size()) {
            return false;
        }
        for (int i = 0; i < this.terms.size(); ++i) {
            if (this.terms.get(i).match(rule_predicate.terms.get(i))) continue;
            return false;
        }
        return true;
    }

    public Predicate clone() {
        ArrayList<Term> terms = new ArrayList<Term>();
        terms.addAll(this.terms);
        return new Predicate(this.name, terms);
    }

    public Predicate(long name, List<Term> terms) {
        this.name = name;
        this.terms = terms;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Predicate predicate = (Predicate)o;
        return this.name == predicate.name && Objects.equals(this.terms, predicate.terms);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.terms);
    }

    public String toString() {
        return this.name + "(" + String.join((CharSequence)", ", this.terms.stream().map(i -> i == null ? "(null)" : i.toString()).collect(Collectors.toList())) + ")";
    }

    public Schema.PredicateV2 serialize() {
        Schema.PredicateV2.Builder builder = Schema.PredicateV2.newBuilder().setName(this.name);
        for (int i = 0; i < this.terms.size(); ++i) {
            builder.addTerms(this.terms.get(i).serialize());
        }
        return builder.build();
    }

    public static Either<Error.FormatError, Predicate> deserializeV2(Schema.PredicateV2 predicate) {
        ArrayList<Term> terms = new ArrayList<Term>();
        for (Schema.TermV2 id : predicate.getTermsList()) {
            Either<Error.FormatError, Term> res = Term.deserialize_enumV2(id);
            if (res.isLeft()) {
                Error.FormatError e = (Error.FormatError)res.getLeft();
                return API.Left((Object)e);
            }
            terms.add((Term)res.get());
        }
        return API.Right((Object)new Predicate(predicate.getName(), terms));
    }
}

