/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.datalog;

import com.clevercloud.biscuit.crypto.TokenSignature;
import com.clevercloud.biscuit.datalog.Check;
import com.clevercloud.biscuit.datalog.Fact;
import com.clevercloud.biscuit.datalog.Predicate;
import com.clevercloud.biscuit.datalog.Rule;
import com.clevercloud.biscuit.datalog.Term;
import com.clevercloud.biscuit.datalog.World;
import com.clevercloud.biscuit.datalog.expressions.Expression;
import com.clevercloud.biscuit.token.builder.Utils;
import io.vavr.control.Option;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class SymbolTable
implements Serializable {
    private final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ssxxx");
    public final List<String> symbols = new ArrayList<String>();

    private String fromEpochIsoDate(long epochSec) {
        return Instant.ofEpochSecond(epochSec).atOffset(ZoneOffset.ofTotalSeconds(0)).format(this.dateTimeFormatter);
    }

    public long insert(String symbol) {
        int index = this.symbols.indexOf(symbol);
        if (index == -1) {
            this.symbols.add(symbol);
            return this.symbols.size() - 1;
        }
        return index;
    }

    public Term add(String symbol) {
        return new Term.Str(this.insert(symbol));
    }

    public Option<Long> get(String symbol) {
        long index = this.symbols.indexOf(symbol);
        if (index == -1L) {
            return Option.none();
        }
        return Option.some((Object)index);
    }

    public Option<String> get_s(int i) {
        if (i >= 0 && i < this.symbols.size()) {
            return Option.some((Object)this.symbols.get(i));
        }
        return Option.none();
    }

    public String print_id(Term value) {
        Object _s = "";
        if (value instanceof Term.Bool) {
            _s = Boolean.toString(((Term.Bool)value).value());
        } else if (value instanceof Term.Bytes) {
            _s = TokenSignature.hex(((Term.Bytes)value).value());
        } else if (value instanceof Term.Date) {
            _s = this.fromEpochIsoDate(((Term.Date)value).value());
        } else if (value instanceof Term.Integer) {
            _s = Long.toString(((Term.Integer)value).value());
        } else if (value instanceof Term.Set) {
            Term.Set idset = (Term.Set)value;
            if (idset.value().size() > 0) {
                _s = "[ ";
                _s = (String)_s + String.join((CharSequence)", ", idset.value().stream().map(id -> this.print_id((Term)id)).collect(Collectors.toList()));
                _s = (String)_s + " ]";
            }
        } else if (value instanceof Term.Str) {
            _s = "\"" + this.print_symbol((int)((Term.Str)value).value()) + "\"";
        } else if (value instanceof Term.Variable) {
            _s = "$" + this.print_symbol((int)((Term.Variable)value).value());
        }
        return _s;
    }

    public String print_rule(Rule r) {
        Object res = this.print_predicate(r.head());
        res = (String)res + " <- " + this.print_rule_body(r);
        return res;
    }

    public String print_rule_body(Rule r) {
        List preds = r.body().stream().map(p -> this.print_predicate((Predicate)p)).collect(Collectors.toList());
        List expressions = r.expressions().stream().map(c -> this.print_expression((Expression)c)).collect(Collectors.toList());
        Object res = String.join((CharSequence)", ", preds);
        if (!expressions.isEmpty()) {
            if (!preds.isEmpty()) {
                res = (String)res + ", ";
            }
            res = (String)res + String.join((CharSequence)", ", expressions);
        }
        return res;
    }

    public String print_expression(Expression e) {
        return (String)e.print(this).get();
    }

    public String print_predicate(Predicate p) {
        List ids = p.terms().stream().map(i -> {
            if (i instanceof Term.Variable) {
                return "$" + this.print_symbol((int)((Term.Variable)i).value());
            }
            if (i instanceof Term.Date) {
                return this.fromEpochIsoDate(((Term.Date)i).value());
            }
            if (i instanceof Term.Integer) {
                return "" + ((Term.Integer)i).value();
            }
            if (i instanceof Term.Str) {
                return "\"" + this.print_symbol((int)((Term.Str)i).value()) + "\"";
            }
            if (i instanceof Term.Bytes) {
                return "hex:" + Utils.byteArrayToHexString(((Term.Bytes)i).value());
            }
            return "???";
        }).collect(Collectors.toList());
        return Optional.ofNullable(this.print_symbol((int)p.name())).orElse("<?>") + "(" + String.join((CharSequence)", ", ids) + ")";
    }

    public String print_fact(Fact f) {
        return this.print_predicate(f.predicate());
    }

    public String print_check(Check c) {
        String res = "check if ";
        List queries = c.queries().stream().map(q -> this.print_rule_body((Rule)q)).collect(Collectors.toList());
        return res + String.join((CharSequence)" or ", queries);
    }

    public String print_world(World w) {
        List facts = w.facts().stream().map(f -> this.print_fact((Fact)f)).collect(Collectors.toList());
        List rules = w.rules().stream().map(r -> this.print_rule((Rule)r)).collect(Collectors.toList());
        StringBuilder b = new StringBuilder();
        b.append("World {\n\tfacts: [\n\t\t");
        b.append(String.join((CharSequence)",\n\t\t", facts));
        b.append("\n\t],\n\trules: [\n\t\t");
        b.append(String.join((CharSequence)",\n\t\t", rules));
        b.append("\n\t]\n}");
        return b.toString();
    }

    public String print_symbol(int i) {
        if (i >= 0 && i < this.symbols.size()) {
            return this.symbols.get(i);
        }
        return "<" + i + "?>";
    }

    public SymbolTable() {
    }

    public SymbolTable(SymbolTable s) {
        for (String symbol : s.symbols) {
            this.symbols.add(symbol);
        }
    }
}

