/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.error;

import com.clevercloud.biscuit.error.FailedCheck;
import com.clevercloud.biscuit.error.LogicError;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.vavr.control.Option;
import java.util.List;
import java.util.Objects;

public class Error
extends Exception {
    public Option<List<FailedCheck>> failed_checks() {
        return Option.none();
    }

    public JsonElement toJson() {
        return new JsonObject();
    }

    public static class Parser
    extends Error {
        public final com.clevercloud.biscuit.token.builder.parser.Error error;

        public Parser(com.clevercloud.biscuit.token.builder.parser.Error error) {
            this.error = error;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parser parser = (Parser)o;
            return this.error.equals(parser.error);
        }

        public int hashCode() {
            return this.error.hashCode();
        }

        @Override
        public String toString() {
            return "Parser{error=" + this.error + "}";
        }

        @Override
        public JsonElement toJson() {
            JsonObject jo = new JsonObject();
            JsonObject error = new JsonObject();
            error.add("error", this.error.toJson());
            return jo;
        }
    }

    public static class Timeout
    extends Error {
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        @Override
        public JsonElement toJson() {
            return new JsonPrimitive("Timeout");
        }
    }

    public static class TooManyIterations
    extends Error {
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        @Override
        public JsonElement toJson() {
            return new JsonPrimitive("TooManyIterations");
        }
    }

    public static class TooManyFacts
    extends Error {
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        @Override
        public JsonElement toJson() {
            return new JsonPrimitive("TooManyFacts");
        }
    }

    public static class Language
    extends Error {
        public final FailedCheck.LanguageError langError;

        public Language(FailedCheck.LanguageError langError) {
            this.langError = langError;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        @Override
        public JsonElement toJson() {
            JsonObject jo = new JsonObject();
            jo.add("Language", this.langError.toJson());
            return jo;
        }
    }

    public static class FailedLogic
    extends Error {
        public final LogicError error;

        public FailedLogic(LogicError error) {
            this.error = error;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FailedLogic other = (FailedLogic)o;
            return this.error.equals(other.error);
        }

        public int hashCode() {
            return Objects.hash(this.error);
        }

        @Override
        public String toString() {
            return "Err(FailedLogic(" + this.error + "))";
        }

        @Override
        public Option<List<FailedCheck>> failed_checks() {
            return this.error.failed_checks();
        }

        @Override
        public JsonElement toJson() {
            JsonObject jo = new JsonObject();
            jo.add("FailedLogic", this.error.toJson());
            return jo;
        }
    }

    public static class Sealed
    extends Error {
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        @Override
        public JsonElement toJson() {
            return new JsonPrimitive("Sealed");
        }
    }

    public static class MissingSymbols
    extends Error {
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        @Override
        public JsonElement toJson() {
            return new JsonPrimitive("MissingSymbols");
        }
    }

    public static class SymbolTableOverlap
    extends Error {
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        @Override
        public JsonElement toJson() {
            return new JsonPrimitive("SymbolTableOverlap");
        }
    }

    public static class InvalidBlockIndex
    extends Error {
        public final long expected;
        public final long found;

        public InvalidBlockIndex(long expected, long found) {
            this.expected = expected;
            this.found = found;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InvalidBlockIndex other = (InvalidBlockIndex)o;
            return this.expected == other.expected && this.found == other.found;
        }

        public int hashCode() {
            return Objects.hash(this.expected, this.found);
        }

        @Override
        public String toString() {
            return "Err(InvalidBlockIndex{ expected: " + this.expected + ", found: " + this.found + " }";
        }

        @Override
        public JsonElement toJson() {
            JsonObject child = new JsonObject();
            child.addProperty("expected", (Number)this.expected);
            child.addProperty("fount", (Number)this.found);
            JsonObject jo = new JsonObject();
            jo.add("InvalidBlockIndex", (JsonElement)child);
            return jo;
        }
    }

    public static class InvalidAuthorityIndex
    extends Error {
        public final long index;

        public InvalidAuthorityIndex(long index) {
            this.index = index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InvalidAuthorityIndex other = (InvalidAuthorityIndex)o;
            return this.index == other.index;
        }

        public int hashCode() {
            return Objects.hash(this.index);
        }

        @Override
        public String toString() {
            return "Err(InvalidAuthorityIndex{ index: " + this.index + " }";
        }

        @Override
        public JsonElement toJson() {
            JsonObject child = new JsonObject();
            child.addProperty("index", (Number)this.index);
            JsonObject jo = new JsonObject();
            jo.add("InvalidAuthorityIndex", (JsonElement)child);
            return jo;
        }
    }

    public static class FormatError
    extends Error {
        private static JsonElement jsonWrapper(JsonElement e) {
            JsonObject root = new JsonObject();
            root.add("Format", e);
            return root;
        }

        public static class InvalidSignatureSize
        extends FormatError {
            public final int size;

            public InvalidSignatureSize(int size) {
                this.size = size;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                InvalidSignatureSize iss = (InvalidSignatureSize)o;
                return this.size == iss.size;
            }

            public int hashCode() {
                return Objects.hash(this.size);
            }

            @Override
            public String toString() {
                return "InvalidSignatureSize{size=" + this.size + "}";
            }

            @Override
            public JsonElement toJson() {
                JsonObject jo = new JsonObject();
                jo.add("InvalidSignatureSize", (JsonElement)new JsonPrimitive((Number)this.size));
                return FormatError.jsonWrapper((JsonElement)jo);
            }
        }

        public static class Version
        extends FormatError {
            public final int maximum;
            public final int actual;

            public Version(int maximum, int actual) {
                this.maximum = maximum;
                this.actual = actual;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Version version = (Version)o;
                if (this.maximum != version.maximum) {
                    return false;
                }
                return this.actual == version.actual;
            }

            public int hashCode() {
                int result = this.maximum;
                result = 31 * result + this.actual;
                return result;
            }

            @Override
            public String toString() {
                return "Version{maximum=" + this.maximum + ", actual=" + this.actual + "}";
            }

            @Override
            public JsonElement toJson() {
                JsonObject child = new JsonObject();
                child.addProperty("maximum", (Number)this.maximum);
                child.addProperty("actual", (Number)this.actual);
                JsonObject jo = new JsonObject();
                jo.add("Version", (JsonElement)child);
                return FormatError.jsonWrapper((JsonElement)jo);
            }
        }

        public static class BlockSerializationError
        extends FormatError {
            public final String e;

            public BlockSerializationError(String e) {
                this.e = e;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                BlockSerializationError other = (BlockSerializationError)o;
                return this.e.equals(other.e);
            }

            public int hashCode() {
                return Objects.hash(this.e);
            }

            @Override
            public String toString() {
                return "Err(FormatError.BlockSerializationError{ error: " + this.e + " }";
            }

            @Override
            public JsonElement toJson() {
                JsonObject jo = new JsonObject();
                jo.addProperty("BlockSerializationError", this.e);
                return FormatError.jsonWrapper((JsonElement)jo);
            }
        }

        public static class BlockDeserializationError
        extends FormatError {
            public final String e;

            public BlockDeserializationError(String e) {
                this.e = e;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                BlockDeserializationError other = (BlockDeserializationError)o;
                return this.e.equals(other.e);
            }

            public int hashCode() {
                return Objects.hash(this.e);
            }

            @Override
            public String toString() {
                return "Err(FormatError.BlockDeserializationError{ error: " + this.e + " }";
            }

            @Override
            public JsonElement toJson() {
                JsonObject jo = new JsonObject();
                jo.addProperty("BlockDeserializationError", this.e);
                return FormatError.jsonWrapper((JsonElement)jo);
            }
        }

        public static class SerializationError
        extends FormatError {
            public final String e;

            public SerializationError(String e) {
                this.e = e;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                SerializationError other = (SerializationError)o;
                return this.e.equals(other.e);
            }

            public int hashCode() {
                return Objects.hash(this.e);
            }

            @Override
            public String toString() {
                return "Err(Format(SerializationError(\"" + this.e + "\"))";
            }

            @Override
            public JsonElement toJson() {
                JsonObject jo = new JsonObject();
                jo.addProperty("SerializationError", this.e);
                return FormatError.jsonWrapper((JsonElement)jo);
            }
        }

        public static class DeserializationError
        extends FormatError {
            public final String e;

            public DeserializationError(String e) {
                this.e = e;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                DeserializationError other = (DeserializationError)o;
                return this.e.equals(other.e);
            }

            public int hashCode() {
                return Objects.hash(this.e);
            }

            @Override
            public String toString() {
                return "Err(Format(DeserializationError(\"" + this.e + "\"))";
            }

            @Override
            public JsonElement toJson() {
                JsonObject jo = new JsonObject();
                jo.addProperty("DeserializationError", this.e);
                return FormatError.jsonWrapper((JsonElement)jo);
            }
        }

        public static class UnknownPublicKey
        extends FormatError {
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                return o != null && this.getClass() == o.getClass();
            }

            @Override
            public JsonElement toJson() {
                return FormatError.jsonWrapper((JsonElement)new JsonPrimitive("UnknownPublicKey"));
            }

            @Override
            public String toString() {
                return "Err(Format(UnknownPublicKey))";
            }
        }

        public static class EmptyKeys
        extends FormatError {
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                return o != null && this.getClass() == o.getClass();
            }

            @Override
            public JsonElement toJson() {
                return FormatError.jsonWrapper((JsonElement)new JsonPrimitive("EmptyKeys"));
            }

            @Override
            public String toString() {
                return "Err(Format(EmptyKeys))";
            }
        }

        public static class SealedSignature
        extends FormatError {
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                return o != null && this.getClass() == o.getClass();
            }

            @Override
            public JsonElement toJson() {
                return FormatError.jsonWrapper((JsonElement)new JsonPrimitive("SealedSignature"));
            }

            @Override
            public String toString() {
                return "Err(Format(SealedSignature))";
            }
        }

        public static class Signature
        extends FormatError {
            private static JsonElement jsonWrapper(JsonElement e) {
                JsonObject signature = new JsonObject();
                signature.add("Signature", e);
                return FormatError.jsonWrapper((JsonElement)signature);
            }

            public static class InvalidSignature
            extends Signature {
                public final String e;

                public InvalidSignature(String e) {
                    this.e = e;
                }

                public boolean equals(Object o) {
                    if (this == o) {
                        return true;
                    }
                    return o != null && this.getClass() == o.getClass();
                }

                @Override
                public JsonElement toJson() {
                    JsonObject jo = new JsonObject();
                    jo.addProperty("InvalidSignature", this.e);
                    return Signature.jsonWrapper((JsonElement)jo);
                }

                @Override
                public String toString() {
                    return "Err(Format(Signature(InvalidFormat(\"" + this.e + "\"))))";
                }
            }

            public static class InvalidFormat
            extends Signature {
                public boolean equals(Object o) {
                    if (this == o) {
                        return true;
                    }
                    return o != null && this.getClass() == o.getClass();
                }

                @Override
                public JsonElement toJson() {
                    return Signature.jsonWrapper((JsonElement)new JsonPrimitive("InvalidFormat"));
                }

                @Override
                public String toString() {
                    return "Err(Format(Signature(InvalidFormat)))";
                }
            }
        }
    }

    public static class InternalError
    extends Error {
    }
}

