/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.datalog;

import com.clevercloud.biscuit.datalog.Fact;
import com.clevercloud.biscuit.datalog.MatchedVariables;
import com.clevercloud.biscuit.datalog.Predicate;
import com.clevercloud.biscuit.datalog.SymbolTable;
import com.clevercloud.biscuit.datalog.Term;
import com.clevercloud.biscuit.datalog.expressions.Expression;
import io.vavr.control.Option;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class Combinator
implements Serializable {
    private final MatchedVariables variables;
    private final List<Predicate> next_predicates;
    private final List<Expression> expressions;
    private final Set<Fact> all_facts;
    private final Predicate pred;
    private final Iterator<Fact> fit;
    private Combinator current_it;
    private final SymbolTable symbols;

    public Option<MatchedVariables> next() {
        while (true) {
            if (this.current_it != null) {
                Option<MatchedVariables> next_vars_opt = this.current_it.next();
                if (next_vars_opt.isEmpty()) {
                    this.current_it = null;
                    continue;
                }
                MatchedVariables next_vars = (MatchedVariables)next_vars_opt.get();
                Option<Map<Long, Term>> v_opt = next_vars.check_expressions(this.expressions, this.symbols);
                if (v_opt.isEmpty()) continue;
                return Option.some((Object)next_vars);
            }
            if (!this.fit.hasNext()) break;
            Fact current_fact = this.fit.next();
            MatchedVariables vars = this.variables.clone();
            boolean match_ids = true;
            for (int i = 0; i < this.pred.terms().size(); ++i) {
                Term value;
                Term id = this.pred.terms().get(i);
                if (!(id instanceof Term.Variable)) continue;
                long key = ((Term.Variable)id).value();
                if (!vars.insert(key, value = current_fact.predicate().terms().get(i))) {
                    match_ids = false;
                }
                if (!match_ids) break;
            }
            if (!match_ids) continue;
            if (this.next_predicates.isEmpty()) {
                Option<Map<Long, Term>> v_opt = vars.check_expressions(this.expressions, this.symbols);
                if (v_opt.isEmpty()) continue;
                return Option.some((Object)vars);
            }
            this.current_it = new Combinator(vars, this.next_predicates, new ArrayList<Expression>(), this.all_facts, this.symbols);
        }
        return Option.none();
    }

    public List<Map<Long, Term>> combine() {
        ArrayList<Map<Long, Term>> variables = new ArrayList<Map<Long, Term>>();
        Option<MatchedVariables> res;
        while (!(res = this.next()).isEmpty()) {
            Optional<Map<Long, Term>> vars = ((MatchedVariables)res.get()).complete();
            if (!vars.isPresent()) continue;
            variables.add(vars.get());
        }
        return variables;
    }

    public Combinator(MatchedVariables variables, List<Predicate> predicates, List<Expression> expressions, Set<Fact> all_facts, SymbolTable symbols) {
        this.variables = variables;
        this.expressions = expressions;
        this.all_facts = all_facts;
        this.current_it = null;
        this.pred = predicates.get(0);
        this.fit = all_facts.stream().filter(fact -> fact.match_predicate((Predicate)predicates.get(0))).iterator();
        this.symbols = symbols;
        ArrayList<Predicate> next_predicates = new ArrayList<Predicate>();
        for (int i = 1; i < predicates.size(); ++i) {
            next_predicates.add(predicates.get(i));
        }
        this.next_predicates = next_predicates;
    }
}

