/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.datalog;

import com.clevercloud.biscuit.datalog.SymbolTable;
import com.clevercloud.biscuit.datalog.Term;
import com.clevercloud.biscuit.datalog.expressions.Expression;
import io.vavr.control.Option;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class MatchedVariables
implements Serializable {
    private final Map<Long, Optional<Term>> variables = new HashMap<Long, Optional<Term>>();

    public boolean insert(long key, Term value) {
        if (this.variables.containsKey(key)) {
            Optional<Term> val = this.variables.get(key);
            if (val.isPresent()) {
                return val.get().equals(value);
            }
            this.variables.put(key, Optional.of(value));
            return true;
        }
        return false;
    }

    public boolean is_complete() {
        return this.variables.values().stream().allMatch(v -> v.isPresent());
    }

    public Optional<Map<Long, Term>> complete() {
        HashMap<Long, Term> variables = new HashMap<Long, Term>();
        for (Map.Entry<Long, Optional<Term>> entry : this.variables.entrySet()) {
            if (entry.getValue().isPresent()) {
                variables.put(entry.getKey(), entry.getValue().get());
                continue;
            }
            return Optional.empty();
        }
        return Optional.of(variables);
    }

    public MatchedVariables clone() {
        MatchedVariables other = new MatchedVariables(this.variables.keySet());
        for (Map.Entry<Long, Optional<Term>> entry : this.variables.entrySet()) {
            if (!entry.getValue().isPresent()) continue;
            other.variables.put(entry.getKey(), entry.getValue());
        }
        return other;
    }

    public MatchedVariables(Set<Long> ids) {
        for (Long id : ids) {
            this.variables.put(id, Optional.empty());
        }
    }

    public Option<Map<Long, Term>> check_expressions(List<Expression> expressions, SymbolTable symbols) {
        Optional<Map<Long, Term>> vars = this.complete();
        if (vars.isPresent()) {
            Map<Long, Term> variables = vars.get();
            for (Expression e : expressions) {
                Option<Term> res = e.evaluate(variables, symbols);
                if (res.isEmpty()) {
                    return Option.none();
                }
                if (((Term)res.get()).equals(new Term.Bool(true))) continue;
                return Option.none();
            }
            return Option.some(variables);
        }
        return Option.none();
    }
}

