/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.datalog;

import biscuit.format.schema.Schema;
import com.clevercloud.biscuit.datalog.SymbolTable;
import com.clevercloud.biscuit.error.Error;
import com.clevercloud.biscuit.token.builder.Term;
import com.google.protobuf.ByteString;
import io.vavr.API;
import io.vavr.control.Either;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;

public abstract class Term
implements Serializable {
    public abstract boolean match(Term var1);

    public abstract Schema.TermV2 serialize();

    public static Either<Error.FormatError, Term> deserialize_enumV2(Schema.TermV2 term) {
        if (term.hasDate()) {
            return Date.deserializeV2(term);
        }
        if (term.hasInteger()) {
            return Integer.deserializeV2(term);
        }
        if (term.hasString()) {
            return Str.deserializeV2(term);
        }
        if (term.hasBytes()) {
            return Bytes.deserializeV2(term);
        }
        if (term.hasVariable()) {
            return Variable.deserializeV2(term);
        }
        if (term.hasBool()) {
            return Bool.deserializeV2(term);
        }
        if (term.hasSet()) {
            return Set.deserializeV2(term);
        }
        return API.Left((Object)new Error.FormatError.DeserializationError("invalid Term kind: term.getKind()"));
    }

    public abstract com.clevercloud.biscuit.token.builder.Term toTerm(SymbolTable var1);

    public static final class Set
    extends Term
    implements Serializable {
        private final HashSet<Term> value;

        public HashSet<Term> value() {
            return this.value;
        }

        @Override
        public boolean match(Term other) {
            if (other instanceof Variable) {
                return true;
            }
            if (other instanceof Set) {
                return this.value.equals(((Set)other).value);
            }
            return false;
        }

        public Set(HashSet<Term> value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Set set = (Set)o;
            return this.value.equals(set.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "" + this.value;
        }

        @Override
        public Schema.TermV2 serialize() {
            Schema.TermSet.Builder s = Schema.TermSet.newBuilder();
            for (Term l : this.value) {
                s.addSet(l.serialize());
            }
            return Schema.TermV2.newBuilder().setSet(s).build();
        }

        public static Either<Error.FormatError, Term> deserializeV2(Schema.TermV2 term) {
            if (!term.hasSet()) {
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid Term kind, expected set"));
            }
            HashSet<Term> values = new HashSet<Term>();
            Schema.TermSet s = term.getSet();
            for (Schema.TermV2 l : s.getSetList()) {
                Either<Error.FormatError, Term> res = Term.deserialize_enumV2(l);
                if (res.isLeft()) {
                    Error.FormatError e = (Error.FormatError)res.getLeft();
                    return API.Left((Object)e);
                }
                Term value = (Term)res.get();
                if (value instanceof Variable) {
                    return API.Left((Object)new Error.FormatError.DeserializationError("sets cannot contain variables"));
                }
                values.add(value);
            }
            if (values.isEmpty()) {
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid Set value"));
            }
            return API.Right((Object)new Set(values));
        }

        @Override
        public com.clevercloud.biscuit.token.builder.Term toTerm(SymbolTable symbols) {
            HashSet<com.clevercloud.biscuit.token.builder.Term> s = new HashSet<com.clevercloud.biscuit.token.builder.Term>();
            for (Term i : this.value) {
                s.add(i.toTerm(symbols));
            }
            return new Term.Set(s);
        }
    }

    public static final class Bool
    extends Term
    implements Serializable {
        private final boolean value;

        public boolean value() {
            return this.value;
        }

        @Override
        public boolean match(Term other) {
            if (other instanceof Variable) {
                return true;
            }
            if (other instanceof Bool) {
                return this.value == ((Bool)other).value;
            }
            return false;
        }

        public Bool(boolean value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bool bool = (Bool)o;
            return this.value == bool.value;
        }

        public int hashCode() {
            return this.value ? 1 : 0;
        }

        public String toString() {
            return "" + this.value;
        }

        @Override
        public Schema.TermV2 serialize() {
            return Schema.TermV2.newBuilder().setBool(this.value).build();
        }

        public static Either<Error.FormatError, Term> deserializeV2(Schema.TermV2 term) {
            if (!term.hasBool()) {
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid Term kind, expected boolean"));
            }
            return API.Right((Object)new Bool(term.getBool()));
        }

        @Override
        public com.clevercloud.biscuit.token.builder.Term toTerm(SymbolTable symbols) {
            return new Term.Bool(this.value);
        }
    }

    public static final class Variable
    extends Term
    implements Serializable {
        private final long value;

        public long value() {
            return this.value;
        }

        @Override
        public boolean match(Term other) {
            return true;
        }

        public Variable(long value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Variable variable = (Variable)o;
            return this.value == variable.value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }

        public String toString() {
            return this.value + "?";
        }

        @Override
        public Schema.TermV2 serialize() {
            return Schema.TermV2.newBuilder().setVariable((int)this.value).build();
        }

        public static Either<Error.FormatError, Term> deserializeV2(Schema.TermV2 term) {
            if (!term.hasVariable()) {
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid Term kind, expected variable"));
            }
            return API.Right((Object)new Variable(term.getVariable()));
        }

        @Override
        public com.clevercloud.biscuit.token.builder.Term toTerm(SymbolTable symbols) {
            return new Term.Variable(symbols.print_symbol((int)this.value));
        }
    }

    public static final class Str
    extends Term
    implements Serializable {
        private final long value;

        public long value() {
            return this.value;
        }

        @Override
        public boolean match(Term other) {
            if (other instanceof Variable) {
                return true;
            }
            if (other instanceof Str) {
                return this.value == ((Str)other).value;
            }
            return false;
        }

        public Str(long value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Str s = (Str)o;
            return this.value == s.value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }

        @Override
        public Schema.TermV2 serialize() {
            return Schema.TermV2.newBuilder().setString(this.value).build();
        }

        public static Either<Error.FormatError, Term> deserializeV2(Schema.TermV2 term) {
            if (!term.hasString()) {
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid Term kind, expected string"));
            }
            return API.Right((Object)new Str(term.getString()));
        }

        @Override
        public com.clevercloud.biscuit.token.builder.Term toTerm(SymbolTable symbols) {
            return new Term.Str(symbols.print_symbol((int)this.value));
        }
    }

    public static final class Bytes
    extends Term
    implements Serializable {
        private final byte[] value;

        public byte[] value() {
            return this.value;
        }

        @Override
        public boolean match(Term other) {
            if (other instanceof Variable) {
                return true;
            }
            if (other instanceof Bytes) {
                return this.value.equals(((Bytes)other).value);
            }
            return false;
        }

        public Bytes(byte[] value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bytes bytes = (Bytes)o;
            return Arrays.equals(this.value, bytes.value);
        }

        public int hashCode() {
            return Arrays.hashCode(this.value);
        }

        public String toString() {
            return this.value.toString();
        }

        @Override
        public Schema.TermV2 serialize() {
            return Schema.TermV2.newBuilder().setBytes(ByteString.copyFrom((byte[])this.value)).build();
        }

        public static Either<Error.FormatError, Term> deserializeV2(Schema.TermV2 term) {
            if (!term.hasBytes()) {
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid Term kind, expected byte array"));
            }
            return API.Right((Object)new Bytes(term.getBytes().toByteArray()));
        }

        @Override
        public com.clevercloud.biscuit.token.builder.Term toTerm(SymbolTable symbols) {
            return new Term.Bytes(this.value);
        }
    }

    public static final class Integer
    extends Term
    implements Serializable {
        private final long value;

        public long value() {
            return this.value;
        }

        @Override
        public boolean match(Term other) {
            if (other instanceof Variable) {
                return true;
            }
            if (other instanceof Integer) {
                return this.value == ((Integer)other).value;
            }
            return false;
        }

        public Integer(long value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Integer integer = (Integer)o;
            return this.value == integer.value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }

        public String toString() {
            return "" + this.value;
        }

        @Override
        public Schema.TermV2 serialize() {
            return Schema.TermV2.newBuilder().setInteger(this.value).build();
        }

        public static Either<Error.FormatError, Term> deserializeV2(Schema.TermV2 term) {
            if (!term.hasInteger()) {
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid Term kind, expected integer"));
            }
            return API.Right((Object)new Integer(term.getInteger()));
        }

        @Override
        public com.clevercloud.biscuit.token.builder.Term toTerm(SymbolTable symbols) {
            return new Term.Integer(this.value);
        }
    }

    public static final class Date
    extends Term
    implements Serializable {
        private final long value;

        public long value() {
            return this.value;
        }

        @Override
        public boolean match(Term other) {
            if (other instanceof Variable) {
                return true;
            }
            return this.equals(other);
        }

        public Date(long value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Date date = (Date)o;
            return this.value == date.value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }

        public String toString() {
            return "@" + this.value;
        }

        @Override
        public Schema.TermV2 serialize() {
            return Schema.TermV2.newBuilder().setDate(this.value).build();
        }

        public static Either<Error.FormatError, Term> deserializeV2(Schema.TermV2 term) {
            if (!term.hasDate()) {
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid Term kind, expected date"));
            }
            return API.Right((Object)new Date(term.getDate()));
        }

        @Override
        public com.clevercloud.biscuit.token.builder.Term toTerm(SymbolTable symbols) {
            return new Term.Date(this.value);
        }
    }
}

